/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ApplicationLoader
extends URLClassLoader
implements Runnable {
    protected final String[] f_asArgs;
    private static final boolean SHARED_ROOT = Boolean.getBoolean(ApplicationLoader.class.getName() + ".sharedRoot");

    public ApplicationLoader(URL[] aUrl, String[] asArgs) {
        super(aUrl, SHARED_ROOT ? ClassLoader.getSystemClassLoader() : ClassLoader.getSystemClassLoader().getParent());
        this.f_asArgs = asArgs;
    }

    public void invokeClass(String name, String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> c = this.loadClass(name);
        Method m = c.getMethod("main", args.getClass());
        m.setAccessible(true);
        int mods = m.getModifiers();
        if (m.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        try {
            m.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setContextClassLoader(this);
        String name = this.f_asArgs[1];
        String[] newArgs = new String[this.f_asArgs.length - 2];
        System.arraycopy(this.f_asArgs, 2, newArgs, 0, newArgs.length);
        try {
            this.invokeClass(name, newArgs);
        }
        catch (ClassNotFoundException e) {
            ApplicationLoader.fatal("Class not found: " + name);
        }
        catch (NoSuchMethodException e) {
            ApplicationLoader.fatal("Class does not define a 'main' method: " + name);
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
    }

    public static String[][] splitArgs(String[] args) {
        ArrayList<String[]> listArgs = new ArrayList<String[]>();
        int ofStart = 0;
        int c = args.length;
        for (int i = 0; i < c; ++i) {
            if (!args[i].contains("&") && !args[i].contains(";")) continue;
            int ofAmp = args[i].indexOf(38);
            int ofSemi = args[i].indexOf(59);
            int ofTerm = ofAmp == -1 ? ofSemi : ofAmp;
            String sSuffix = args[i].substring(ofTerm + 1);
            args[i] = args[i].substring(0, ofTerm + (ofAmp == -1 ? 0 : 1));
            int cTok = args[i].isEmpty() ? 0 : 1;
            String[] newArgs = new String[i + cTok - ofStart];
            System.arraycopy(args, ofStart, newArgs, 0, i + cTok);
            listArgs.add(newArgs);
            ofStart = i + 1;
            if (sSuffix.isEmpty()) continue;
            int cReps = Integer.parseInt(sSuffix);
            for (int j = 1; j < cReps; ++j) {
                listArgs.add((String[])newArgs.clone());
            }
        }
        if (ofStart < args.length) {
            String[] newArgs = new String[args.length - ofStart];
            System.arraycopy(args, ofStart, newArgs, 0, newArgs.length);
            listArgs.add(newArgs);
        }
        return (String[][])listArgs.toArray((T[])new String[listArgs.size()][]);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            ApplicationLoader.usage();
        }
        String[][] aaArgs = ApplicationLoader.splitArgs(args);
        int cMain = 0;
        for (String[] asArgs : aaArgs) {
            ArrayList<URL> listJars = new ArrayList<URL>();
            try {
                StringTokenizer tok = new StringTokenizer(asArgs[0], ":");
                while (tok.hasMoreElements()) {
                    listJars.add(new URL("file:" + tok.nextToken()));
                }
            }
            catch (MalformedURLException e) {
                ApplicationLoader.fatal("Invalid URL: " + asArgs[0]);
            }
            String sLast = asArgs[asArgs.length - 1];
            if (sLast.endsWith("&")) {
                asArgs[asArgs.length - 1] = sLast.substring(0, sLast.length() - 1);
                new Thread((Runnable)new ApplicationLoader(listJars.toArray(new URL[0]), asArgs), "main-" + ++cMain).start();
                continue;
            }
            new ApplicationLoader(listJars.toArray(new URL[0]), asArgs).run();
        }
    }

    private static void fatal(String s) {
        System.err.println(s);
        System.exit(1);
    }

    private static void usage() {
        ApplicationLoader.fatal("Usage: java " + ApplicationLoader.class.getName() + " [classpath class [args..] [&[N]]]+ ");
    }
}

