/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

import com.oracle.coherence.common.internal.util.TimerTask;
import java.util.Arrays;

class TaskQueue {
    private TimerTask[] queue = new TimerTask[128];
    private int size = 0;
    private long addCount = 0L;

    TaskQueue() {
    }

    int size() {
        return this.size;
    }

    void add(TimerTask task) {
        if (this.size + 1 == this.queue.length) {
            this.queue = Arrays.copyOf(this.queue, 2 * this.queue.length);
        }
        task.scheduleOrder = this.addCount++;
        this.queue[++this.size] = task;
        this.fixUp(this.size);
    }

    TimerTask getMin() {
        return this.queue[1];
    }

    TimerTask get(int i) {
        return this.queue[i];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void quickRemove(int i) {
        assert (i <= this.size);
        this.queue[i] = this.queue[this.size];
        this.queue[this.size--] = null;
    }

    void rescheduleMin(long newTime) {
        this.queue[1].nextExecutionTime = newTime;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    private void fixUp(int k) {
        int j;
        while (k > 1 && this.queue[j = k >> 1].compareTo(this.queue[k]) > 0) {
            TimerTask tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[k] = tmp;
            k = j;
        }
    }

    private void fixDown(int k) {
        int j;
        while ((j = k << 1) <= this.size && j > 0) {
            if (j < this.size && this.queue[j].compareTo(this.queue[j + 1]) > 0) {
                ++j;
            }
            if (this.queue[k].compareTo(this.queue[j]) <= 0) break;
            TimerTask tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[k] = tmp;
            k = j;
        }
    }

    void heapify() {
        for (int i = this.size / 2; i >= 1; --i) {
            this.fixDown(i);
        }
    }
}

