/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferSequenceInputStream
extends InputStream
implements DataInput {
    protected BufferSequence m_bufseq;
    private ByteBuffer m_bufTmp;
    protected long m_cb;
    protected int m_ofNext;
    protected int m_ofMark;
    protected int m_posMark;
    protected long m_cbMark;
    protected int m_cbLimit;
    protected final boolean f_fAutoDispose;
    protected ByteBuffer m_bufUnsafe = Buffers.getEmptyBuffer();
    protected int m_nPosBuf;
    protected int m_nLimBuf;

    public BufferSequenceInputStream(BufferSequence bufseq) {
        this(bufseq, false);
    }

    public BufferSequenceInputStream(BufferSequence bufseq, boolean fAutoDispose) {
        this.m_bufseq = bufseq;
        this.m_cbMark = this.m_cb = bufseq.getLength();
        this.f_fAutoDispose = fAutoDispose;
    }

    public void read(ByteBuffer bufDst) {
        ByteBuffer bufUnsafe = this.ensureBuffer();
        while (bufDst.hasRemaining() && bufUnsafe != null) {
            int nPosSrc = this.m_nPosBuf;
            int cbCopy = Math.min(this.m_nLimBuf - nPosSrc, bufDst.remaining());
            this.consumeBytes(cbCopy);
            Buffers.copy(bufUnsafe, nPosSrc, cbCopy, bufDst);
            this.m_nPosBuf += cbCopy;
            bufUnsafe = this.ensureBuffer();
        }
    }

    public ByteBuffer getCurrentBuffer() {
        ByteBuffer bufUnsafe = this.m_bufUnsafe;
        if (bufUnsafe == null) {
            bufUnsafe = this.ensureBuffer();
        }
        bufUnsafe = bufUnsafe.duplicate();
        bufUnsafe.position(this.m_nPosBuf).limit(this.m_nLimBuf);
        return bufUnsafe;
    }

    public BufferSequenceInputStream reset(BufferSequence bufseq) {
        this.close();
        this.m_bufseq = bufseq;
        this.m_cbMark = this.m_cb = bufseq.getLength();
        this.m_ofNext = 0;
        this.m_ofMark = 0;
        this.m_posMark = 0;
        this.m_bufUnsafe = Buffers.getEmptyBuffer();
        this.m_cbLimit = 0;
        this.m_nPosBuf = 0;
        this.m_nLimBuf = 0;
        return this;
    }

    @Override
    public void readFully(byte[] ab) throws IOException {
        this.readFully(ab, 0, ab.length);
    }

    @Override
    public void readFully(byte[] ab, int off, int len) throws IOException {
        if (this.read(ab, off, len) < len) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public short readShort() throws IOException {
        ByteBuffer buf;
        return buf.getShort((buf = this.ensureBuffer(2)) == this.m_bufTmp ? 0 : this.m_nPosBuf - 2);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }

    @Override
    public char readChar() throws IOException {
        ByteBuffer buf;
        return buf.getChar((buf = this.ensureBuffer(2)) == this.m_bufTmp ? 0 : this.m_nPosBuf - 2);
    }

    @Override
    public int readInt() throws IOException {
        ByteBuffer buf;
        return buf.getInt((buf = this.ensureBuffer(4)) == this.m_bufTmp ? 0 : this.m_nPosBuf - 4);
    }

    @Override
    public long readLong() throws IOException {
        ByteBuffer buf;
        return buf.getLong((buf = this.ensureBuffer(8)) == this.m_bufTmp ? 0 : this.m_nPosBuf - 8);
    }

    @Override
    public float readFloat() throws IOException {
        ByteBuffer buf;
        return buf.getFloat((buf = this.ensureBuffer(4)) == this.m_bufTmp ? 0 : this.m_nPosBuf - 4);
    }

    @Override
    public double readDouble() throws IOException {
        ByteBuffer buf;
        return buf.getDouble((buf = this.ensureBuffer(8)) == this.m_bufTmp ? 0 : this.m_nPosBuf - 8);
    }

    @Override
    @Deprecated
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    @Override
    public int read() throws IOException {
        ByteBuffer buf = this.ensureBuffer();
        if (this.m_nPosBuf < this.m_nLimBuf) {
            this.consumeBytes(1);
            return buf.get(this.m_nPosBuf++) & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] abDest, int ofDest, int cbDest) throws IOException {
        int cbRead;
        if (abDest == null || ofDest < 0 || cbDest < 0 || ofDest + cbDest > abDest.length) {
            if (abDest == null) {
                throw new IllegalArgumentException("null byte array");
            }
            throw new IllegalArgumentException("abDest.length=" + abDest.length + ", ofDest=" + ofDest + ", cbDest=" + cbDest);
        }
        int cbResult = 0;
        do {
            ByteBuffer bufDupe = this.ensureBuffer().duplicate();
            bufDupe.position(this.m_nPosBuf).limit(this.m_nLimBuf);
            int posStart = bufDupe.position();
            bufDupe.get(abDest, ofDest, Math.min(cbDest, bufDupe.remaining()));
            cbRead = bufDupe.position() - posStart;
            if (cbRead == 0 && this.m_cb == 0L) break;
            this.consumeBytes(cbRead);
            this.m_nPosBuf += cbRead;
            cbResult += cbRead;
            ofDest += cbRead;
        } while ((cbDest -= cbRead) > 0);
        return cbResult == 0 && this.m_cb == 0L ? -1 : cbResult;
    }

    @Override
    public long skip(long lcb) throws IOException {
        if (lcb <= 0L) {
            return 0L;
        }
        int cb = (int)Math.min(Integer.MAX_VALUE, lcb);
        int cbResult = 0;
        while (cb > 0) {
            this.ensureBuffer();
            int cbSkip = Math.min(cb, this.m_nLimBuf - this.m_nPosBuf);
            if (cbSkip == 0 && this.m_cb == 0L) break;
            this.consumeBytes(cbSkip);
            this.m_nPosBuf += cbSkip;
            cb -= cbSkip;
            cbResult += cbSkip;
        }
        return cbResult;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, this.m_cb);
    }

    @Override
    public void mark(int readlimit) {
        this.ensureBuffer();
        this.m_cbLimit = readlimit;
        this.m_cbMark = this.m_cb;
        this.m_ofMark = this.m_ofNext - 1;
        this.m_posMark = this.m_nPosBuf;
    }

    @Override
    public void reset() throws IOException {
        long cbMark = this.m_cbMark;
        BufferSequence bufseq = this.m_bufseq;
        long cb = this.m_cb;
        long cbBack = cbMark - cb;
        if (cbBack == 0L) {
            return;
        }
        if (cbBack > (long)this.m_cbLimit) {
            throw new IOException("Invalid mark, limit exceeded");
        }
        if (bufseq == null) {
            throw new IOException("Closed stream");
        }
        int of = this.m_ofMark;
        this.m_bufUnsafe = bufseq.getUnsafeBuffer(of);
        this.m_nLimBuf = bufseq.getBufferLimit(of);
        this.m_nPosBuf = this.m_posMark;
        this.m_ofNext = of + 1;
        this.m_cb = cbMark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() {
        BufferSequence bufSeq = this.m_bufseq;
        this.m_bufUnsafe = null;
        this.m_bufseq = null;
        this.m_bufTmp = null;
        this.m_cb = 0L;
        this.m_nLimBuf = 0;
        this.m_nPosBuf = 0;
        if (bufSeq != null && this.f_fAutoDispose) {
            bufSeq.dispose();
        }
    }

    protected final void consumeBytes(int cb) {
        if ((this.m_cb -= (long)cb) == 0L && this.f_fAutoDispose && this.m_cbMark > (long)this.m_cbLimit) {
            this.close();
        }
    }

    protected final ByteBuffer ensureBuffer() {
        int of;
        BufferSequence bufseq = this.m_bufseq;
        if (bufseq == null) {
            this.m_nLimBuf = 0;
            this.m_nPosBuf = 0;
            return Buffers.getEmptyBuffer();
        }
        ByteBuffer bufUnsafe = this.m_bufUnsafe;
        int cBuf = bufseq.getBufferCount();
        for (of = this.m_ofNext; this.m_nPosBuf == this.m_nLimBuf && of < cBuf; ++of) {
            bufUnsafe = bufseq.getUnsafeBuffer(of);
            this.m_bufUnsafe = bufUnsafe.order() == ByteOrder.BIG_ENDIAN ? bufUnsafe : bufUnsafe.duplicate().order(ByteOrder.BIG_ENDIAN);
            this.m_nPosBuf = bufseq.getBufferPosition(of);
            this.m_nLimBuf = bufseq.getBufferLimit(of);
        }
        this.m_ofNext = of;
        return bufUnsafe;
    }

    private final ByteBuffer ensureBuffer(int cb) throws IOException {
        int cbUnsafe = this.m_nLimBuf - this.m_nPosBuf;
        ByteBuffer bufUnsafe = this.m_bufUnsafe;
        if (cbUnsafe == 0) {
            bufUnsafe = this.ensureBuffer();
            cbUnsafe = this.m_nLimBuf - this.m_nPosBuf;
        }
        if (cbUnsafe >= cb) {
            this.consumeBytes(cb);
            this.m_nPosBuf += cb;
            return bufUnsafe;
        }
        ByteBuffer buffTmp = this.m_bufTmp;
        if (buffTmp == null) {
            this.m_bufTmp = buffTmp = ByteBuffer.allocate(8);
        }
        buffTmp.position(0).limit(cb);
        this.readFully(buffTmp.array(), 0, cb);
        return buffTmp;
    }
}

