/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import java.net.InetAddress;
import java.util.Comparator;

public class InetAddressComparator
implements Comparator<InetAddress> {
    public static final InetAddressComparator INSTANCE = new InetAddressComparator();

    @Override
    public int compare(InetAddress addrA, InetAddress addrB) {
        int ofB;
        int ofA;
        if (addrA == addrB) {
            return 0;
        }
        if (addrA == null) {
            return -1;
        }
        if (addrB == null) {
            return 1;
        }
        byte[] abA = addrA.getAddress();
        byte[] abB = addrB.getAddress();
        int cbA = abA.length;
        for (ofA = 0; ofA < cbA && abA[ofA] == 0; ++ofA) {
        }
        int cbsA = cbA - ofA;
        int cbB = abB.length;
        for (ofB = 0; ofB < cbB && abB[ofB] == 0; ++ofB) {
        }
        int cbsB = cbB - ofB;
        if (cbsA < cbsB) {
            return -1;
        }
        if (cbsB < cbsA) {
            return 1;
        }
        for (int i = 0; i < cbsA; ++i) {
            int n = (0xFF & abA[ofA + i]) - (0xFF & abB[ofB + i]);
            if (n == 0) continue;
            return n < 0 ? -1 : 1;
        }
        return 0;
    }
}

