/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import com.oracle.coherence.common.base.Hasher;
import com.oracle.coherence.common.net.InetAddressComparator;
import java.net.InetAddress;

public class InetAddressHasher
implements Hasher<InetAddress> {
    public static final InetAddressHasher INSTANCE = new InetAddressHasher();

    @Override
    public int hashCode(InetAddress addr) {
        if (addr == null) {
            return 0;
        }
        int nHash = 0;
        for (byte b : addr.getAddress()) {
            nHash += b;
        }
        return nHash;
    }

    @Override
    public boolean equals(InetAddress addrA, InetAddress addrB) {
        return InetAddressComparator.INSTANCE.compare(addrA, addrB) == 0;
    }
}

