/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.TypeDescriptor;
import com.oracle.coherence.common.schema.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractTypeDescriptor<T extends TypeDescriptor>
implements TypeDescriptor<T> {
    private final boolean m_fArray;
    private final List<T> m_genericArgs;
    private String[] m_namespace;
    private String m_name;
    private T m_arrayType;

    protected AbstractTypeDescriptor(String name) {
        this(null, name, false);
    }

    protected AbstractTypeDescriptor(String[] namespace, String name) {
        this(namespace, name, false);
    }

    protected AbstractTypeDescriptor(String[] namespace, String name, boolean fArray) {
        this(namespace, name, fArray, null);
    }

    protected AbstractTypeDescriptor(String[] namespace, String name, boolean fArray, List<T> genericArgs) {
        this.m_namespace = namespace;
        this.m_name = name;
        this.m_fArray = fArray;
        this.m_genericArgs = genericArgs;
        if (!fArray) {
            this.m_arrayType = this.createArrayType(namespace, name);
        }
    }

    protected abstract T createArrayType(String[] var1, String var2);

    protected abstract Parser getParser();

    @Override
    public String getNamespace() {
        return this.m_namespace == null ? null : String.join((CharSequence)this.getParser().getSeparator(), this.m_namespace);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getFullName() {
        String ns = this.getNamespace();
        return ns == null ? this.m_name : ns + this.getParser().getSeparator() + this.m_name;
    }

    @Override
    public boolean isArray() {
        return this.m_fArray;
    }

    @Override
    public boolean isGenericType() {
        return this.m_genericArgs != null && this.m_genericArgs.size() > 0;
    }

    @Override
    public List<T> getGenericArguments() {
        return this.m_genericArgs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTypeDescriptor that = (AbstractTypeDescriptor)o;
        if (this.m_fArray != that.m_fArray) {
            return false;
        }
        if (!Arrays.equals(this.m_namespace, that.m_namespace)) {
            return false;
        }
        if (this.m_name != null ? !this.m_name.equals(that.m_name) : that.m_name != null) {
            return false;
        }
        if (this.m_arrayType != null ? !this.m_arrayType.equals(that.m_arrayType) : that.m_arrayType != null) {
            return false;
        }
        return this.m_genericArgs != null ? this.m_genericArgs.equals(that.m_genericArgs) : that.m_genericArgs == null;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.m_namespace);
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_fArray ? 1 : 0);
        result = 31 * result + (this.m_arrayType != null ? this.m_arrayType.hashCode() : 0);
        result = 31 * result + (this.m_genericArgs != null ? this.m_genericArgs.hashCode() : 0);
        return result;
    }

    public String[] getNamespaceComponents() {
        return this.m_namespace;
    }

    public void setNamespace(String[] namespace) {
        this.m_namespace = namespace;
    }

    public void setNamespace(String namespace) {
        this.m_namespace = namespace == null ? null : StringUtils.split(namespace, this.getParser().getSeparator());
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean isNameEqual(AbstractTypeDescriptor other) {
        return this.m_name.equals(other.m_name) && Arrays.equals(this.m_namespace, other.m_namespace);
    }

    protected T getArrayType() {
        return this.m_arrayType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_namespace != null) {
            sb.append(this.getNamespace());
            sb.append(this.getParser().getSeparator());
        }
        sb.append(this.m_name);
        if (this.m_genericArgs != null) {
            sb.append('(');
            for (int i = 0; i < this.m_genericArgs.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.m_genericArgs.get(i));
            }
            sb.append(')');
        }
        if (this.m_fArray) {
            sb.append("[]");
        }
        return sb.toString();
    }

    protected static abstract class Parser<T extends AbstractTypeDescriptor> {
        protected final String m_separator;

        protected Parser(String separator) {
            this.m_separator = separator;
        }

        protected abstract T getStandardType(String var1);

        protected abstract T createTypeDescriptor(String[] var1, String var2, boolean var3, List<T> var4);

        public String getSeparator() {
            return this.m_separator;
        }

        public T parse(String type) {
            boolean fArray = type.endsWith("[]");
            if (fArray) {
                type = type.substring(0, type.length() - 2);
            }
            List<T> genericArgs = null;
            boolean fGeneric = type.contains("(");
            if (fGeneric) {
                genericArgs = this.parseGenericArgs(type.substring(type.indexOf("(") + 1, type.lastIndexOf(")")));
                type = type.substring(0, type.indexOf("("));
            }
            return this.createTypeDescriptor(type, fArray, genericArgs);
        }

        public T parseInternal(String type) {
            T primitiveType;
            boolean fArray;
            boolean bl = fArray = type.charAt(0) == '[';
            if (fArray) {
                type = type.substring(1);
            }
            List<T> genericArgs = null;
            boolean fGeneric = type.contains("<");
            if (fGeneric) {
                genericArgs = this.parseGenericArgsInternal(type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")));
                type = type.substring(0, type.indexOf("<")) + ";";
            }
            if (type.startsWith("L") && type.endsWith(";")) {
                type = type.substring(1, type.length() - 1);
            }
            type = type.replaceAll("/", this.getSeparator());
            if (!fGeneric && type.length() == 1 && (primitiveType = this.getPrimitiveType(type)) != null) {
                return (T)(fArray ? (AbstractTypeDescriptor)((AbstractTypeDescriptor)primitiveType).getArrayType() : primitiveType);
            }
            return this.createTypeDescriptor(type, fArray, genericArgs);
        }

        protected T getPrimitiveType(String type) {
            if ("Z".equals(type)) {
                return this.getStandardType("boolean");
            }
            if ("B".equals(type)) {
                return this.getStandardType("byte");
            }
            if ("C".equals(type)) {
                return this.getStandardType("char");
            }
            if ("S".equals(type)) {
                return this.getStandardType("short");
            }
            if ("I".equals(type)) {
                return this.getStandardType("int");
            }
            if ("J".equals(type)) {
                return this.getStandardType("long");
            }
            if ("F".equals(type)) {
                return this.getStandardType("float");
            }
            if ("D".equals(type)) {
                return this.getStandardType("double");
            }
            return null;
        }

        protected T createTypeDescriptor(String type, boolean fArray, List<T> genericArgs) {
            T standardType = this.getStandardType(type);
            if (standardType != null) {
                return (T)(fArray ? (AbstractTypeDescriptor)((AbstractTypeDescriptor)standardType).getArrayType() : standardType);
            }
            String[] tmp = StringUtils.split(type, this.getSeparator());
            String[] namespace = null;
            if (tmp.length > 1) {
                namespace = new String[tmp.length - 1];
                System.arraycopy(tmp, 0, namespace, 0, tmp.length - 1);
            }
            String name = tmp[tmp.length - 1];
            return this.createTypeDescriptor(namespace, name, fArray, genericArgs);
        }

        protected List<T> parseGenericArgs(String sArgs) {
            ArrayList<T> args = new ArrayList<T>();
            int i = 0;
            while (i < sArgs.length()) {
                int start = i;
                int c = 0;
                while (i < sArgs.length() && (c > 0 || sArgs.charAt(i) != ',')) {
                    if (sArgs.charAt(i) == '(') {
                        ++c;
                    } else if (sArgs.charAt(i) == ')') {
                        --c;
                    }
                    ++i;
                }
                T ref = this.parse(sArgs.substring(start, i));
                args.add(ref);
            }
            return args;
        }

        protected List<T> parseGenericArgsInternal(String sArgs) {
            ArrayList<T> args = new ArrayList<T>();
            int i = 0;
            while (i < sArgs.length()) {
                int start = i;
                int c = 0;
                while (c > 0 || sArgs.charAt(i) != ';') {
                    if (sArgs.charAt(i) == '<') {
                        ++c;
                    } else if (sArgs.charAt(i) == '>') {
                        --c;
                    }
                    ++i;
                }
                T ref = this.parseInternal(sArgs.substring(start, ++i));
                args.add(ref);
            }
            return args;
        }
    }
}

