/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.AbstractTypeDescriptor;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.lang.java.JavaTypeDescriptor;
import com.oracle.coherence.common.schema.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CanonicalTypeDescriptor
extends AbstractTypeDescriptor<CanonicalTypeDescriptor> {
    public static final CanonicalTypeDescriptor OBJECT = new CanonicalTypeDescriptor("Object");
    public static final CanonicalTypeDescriptor BOOLEAN = new CanonicalTypeDescriptor("boolean");
    public static final CanonicalTypeParser PARSER = new CanonicalTypeParser(".");

    public CanonicalTypeDescriptor(String namespace, String name) {
        this(StringUtils.split(namespace, PARSER.getSeparator()), name);
    }

    private CanonicalTypeDescriptor(String name) {
        super(null, name, false);
    }

    private CanonicalTypeDescriptor(String[] namespace, String name) {
        super(namespace, name);
    }

    private CanonicalTypeDescriptor(String[] namespace, String name, boolean fArray) {
        super(namespace, name, fArray);
    }

    private CanonicalTypeDescriptor(String[] namespace, String name, boolean fArray, List<CanonicalTypeDescriptor> genericArgs) {
        super(namespace, name, fArray, genericArgs);
    }

    public static CanonicalTypeDescriptor parse(String type) {
        return (CanonicalTypeDescriptor)PARSER.parse(type);
    }

    public static CanonicalTypeDescriptor from(JavaTypeDescriptor type, Schema schema) {
        CanonicalTypeDescriptor ctd = new CanonicalTypeDescriptor(type.getNamespaceComponents(), type.getName(), type.isArray(), CanonicalTypeDescriptor.from(type.getGenericArguments(), schema));
        ExtensibleType extType = schema.findTypeByJavaName(type.getFullName());
        if (extType != null) {
            ctd.setNamespace(extType.getNamespace());
            ctd.setName(extType.getName());
        }
        return ctd;
    }

    private static List<CanonicalTypeDescriptor> from(List<JavaTypeDescriptor> types, Schema schema) {
        if (types != null) {
            ArrayList<CanonicalTypeDescriptor> result = new ArrayList<CanonicalTypeDescriptor>(types.size());
            for (JavaTypeDescriptor jtd : types) {
                ExtensibleType type = schema.findTypeByJavaName(jtd.getFullName());
                if (type == null) {
                    throw new IllegalStateException("Generic argument type " + jtd.getFullName() + " is not present in the schema.");
                }
                result.add(type.getDescriptor());
            }
            return result;
        }
        return null;
    }

    @Override
    protected CanonicalTypeDescriptor createArrayType(String[] namespace, String name) {
        return new CanonicalTypeDescriptor(namespace, name, true);
    }

    @Override
    protected AbstractTypeDescriptor.Parser getParser() {
        return PARSER;
    }

    private static class CanonicalTypeParser
    extends AbstractTypeDescriptor.Parser<CanonicalTypeDescriptor> {
        private static final Map<String, CanonicalTypeDescriptor> STANDARD_TYPES;

        public CanonicalTypeParser(String separator) {
            super(separator);
        }

        @Override
        protected CanonicalTypeDescriptor createTypeDescriptor(String[] namespace, String name, boolean fArray, List<CanonicalTypeDescriptor> genericArgs) {
            return new CanonicalTypeDescriptor(namespace, name, fArray, genericArgs);
        }

        @Override
        protected CanonicalTypeDescriptor getStandardType(String type) {
            return STANDARD_TYPES.get(type);
        }

        static {
            HashMap<String, CanonicalTypeDescriptor> map = new HashMap<String, CanonicalTypeDescriptor>();
            map.put("boolean", BOOLEAN);
            map.put("byte", new CanonicalTypeDescriptor("byte"));
            map.put("char", new CanonicalTypeDescriptor("char"));
            map.put("short", new CanonicalTypeDescriptor("short"));
            map.put("int", new CanonicalTypeDescriptor("int"));
            map.put("long", new CanonicalTypeDescriptor("long"));
            map.put("float", new CanonicalTypeDescriptor("float"));
            map.put("double", new CanonicalTypeDescriptor("double"));
            map.put("Object", OBJECT);
            map.put("String", new CanonicalTypeDescriptor("String"));
            map.put("BigDecimal", new CanonicalTypeDescriptor("BigDecimal"));
            map.put("BigInteger", new CanonicalTypeDescriptor("BigInteger"));
            map.put("DateTime", new CanonicalTypeDescriptor("DateTime"));
            STANDARD_TYPES = map;
        }
    }
}

