/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.AbstractSchemaExporter;
import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.ExtensibleType;
import com.oracle.coherence.common.schema.PropertyHandler;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.TypeHandler;
import com.oracle.coherence.common.schema.lang.java.JavaProperty;
import com.oracle.coherence.common.schema.lang.java.JavaType;
import com.oracle.coherence.common.schema.lang.java.JavaTypeDescriptor;
import com.oracle.coherence.common.schema.util.CapitalizationTransformer;
import com.oracle.coherence.common.schema.util.NameTransformer;
import com.oracle.coherence.common.schema.util.StringUtils;
import com.tangosol.internal.codemodel.JClass;
import com.tangosol.internal.codemodel.JCodeModel;
import com.tangosol.internal.codemodel.JDefinedClass;
import com.tangosol.internal.codemodel.JExpr;
import com.tangosol.internal.codemodel.JFieldVar;
import com.tangosol.internal.codemodel.JMethod;
import com.tangosol.internal.codemodel.JPackage;
import com.tangosol.internal.codemodel.JVar;
import com.tangosol.internal.codemodel.writer.SingleStreamCodeWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JavaSourceSchemaExporter
extends AbstractSchemaExporter<JDefinedClass, JProperty> {
    private static NameTransformer FIRST_LOWER = new CapitalizationTransformer(CapitalizationTransformer.Mode.FIRST_LOWER);
    private static NameTransformer FIRST_UPPER = new CapitalizationTransformer(CapitalizationTransformer.Mode.FIRST_UPPER);
    private OutputStream m_outputStream;

    public JavaSourceSchemaExporter() {
        this(System.out);
    }

    public JavaSourceSchemaExporter(OutputStream outputStream) {
        this.m_outputStream = outputStream;
    }

    @Override
    public void export(Schema schema) {
        try {
            JCodeModel cm = new JCodeModel();
            for (ExtensibleType t : schema) {
                if (t.getNamespace() == null) continue;
                JavaType javaType = t.getExtension(JavaType.class);
                System.out.println("Generating " + javaType.getFullName());
                String[] classNames = StringUtils.split(javaType.getName(), "$");
                String outerClassName = javaType.getNamespace() + "." + classNames[0];
                JDefinedClass clazz = cm._getClass(outerClassName);
                if (clazz == null) {
                    clazz = cm._class(outerClassName);
                }
                for (int i = 1; i < classNames.length; ++i) {
                    JDefinedClass nestedClass = this.getNestedClass(clazz, classNames[i]);
                    if (nestedClass == null) {
                        nestedClass = clazz._class(17, classNames[i]);
                    }
                    clazz = nestedClass;
                }
                this.exportType(t, clazz, schema);
                for (TypeHandler handler : schema.getTypeHandlers(this.getExternalTypeClass())) {
                    Object ext = t.getExtension(handler.getInternalTypeClass());
                    handler.exportType(ext, clazz, schema);
                }
                for (ExtensibleProperty p : t.getProperties()) {
                    JProperty property = JProperty.create(clazz, p, schema);
                    this.exportProperty(p, property, schema);
                    for (PropertyHandler handler : schema.getPropertyHandlers(this.getExternalPropertyClass())) {
                        Object ext = p.getExtension(handler.getInternalPropertyClass());
                        handler.exportProperty(ext, property, schema);
                    }
                }
            }
            Iterator<JPackage> itp = cm.packages();
            while (itp.hasNext()) {
                JPackage p = itp.next();
                System.out.println("package " + p.name());
                Iterator<JDefinedClass> itc = p.classes();
                while (itc.hasNext()) {
                    JDefinedClass c = itc.next();
                    System.out.println("\tclass " + c.fullName());
                    Iterator<JDefinedClass> itc2 = c.classes();
                    while (itc2.hasNext()) {
                        JDefinedClass c2 = itc2.next();
                        System.out.println("\t\tclass " + c2.fullName());
                    }
                }
            }
            cm.build(new SingleStreamCodeWriter(this.m_outputStream));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JDefinedClass getNestedClass(JDefinedClass outerClass, String className) {
        Iterator<JDefinedClass> it = outerClass.classes();
        while (it.hasNext()) {
            JDefinedClass clazz = it.next();
            if (!clazz.name().equals(className)) continue;
            return clazz;
        }
        return null;
    }

    @Override
    public Class<JDefinedClass> getExternalTypeClass() {
        return JDefinedClass.class;
    }

    @Override
    public void exportType(ExtensibleType type, JDefinedClass target, Schema schema) {
        if (type.getBase() != null) {
            JavaType baseType = schema.getType(type.getBase(), JavaType.class);
            target._extends(target.owner().ref(baseType.getFullName()));
        }
        for (CanonicalTypeDescriptor td : type.getInterfaces()) {
            JavaType intfType = schema.getType(td, JavaType.class);
            target._implements(target.owner().ref(intfType.getFullName()));
        }
    }

    @Override
    public Class<JProperty> getExternalPropertyClass() {
        return JProperty.class;
    }

    @Override
    public void exportProperty(ExtensibleProperty property, JProperty target, Schema schema) {
    }

    public static class JProperty {
        private JFieldVar m_field;
        private JMethod m_getter;
        private JMethod m_setter;

        private JProperty(JFieldVar field, JMethod getter, JMethod setter) {
            this.m_field = field;
            this.m_getter = getter;
            this.m_setter = setter;
        }

        public static JProperty create(JDefinedClass clazz, ExtensibleProperty p, Schema schema) {
            String fieldName = FIRST_LOWER.transform(p.getName());
            String getterName = (CanonicalTypeDescriptor.BOOLEAN.equals(p.getType()) ? "is" : "get") + FIRST_UPPER.transform(p.getName());
            String setterName = "set" + FIRST_UPPER.transform(p.getName());
            JavaProperty jp = p.getExtension(JavaProperty.class);
            JavaTypeDescriptor jtd = jp.resolveType(schema);
            JClass type = clazz.owner().ref(jtd.getFullName().replace("$", "."));
            if (jtd.isGenericType()) {
                type = type.narrow(JProperty.resolveGenericParameters(clazz.owner(), jtd.getGenericArguments()));
            }
            JFieldVar field = clazz.field(4, type, "m_" + fieldName);
            JMethod getter = clazz.method(1, type, getterName);
            getter.body()._return(field);
            JMethod setter = clazz.method(1, Void.TYPE, setterName);
            JVar setterParam = setter.param(type, fieldName);
            setter.body().assign(JExpr._this().ref(field), setterParam);
            return new JProperty(field, getter, setter);
        }

        private static List<JClass> resolveGenericParameters(JCodeModel cm, List<JavaTypeDescriptor> genericArguments) {
            ArrayList<JClass> params = new ArrayList<JClass>(genericArguments.size());
            for (JavaTypeDescriptor arg : genericArguments) {
                params.add(cm.ref(arg.getFullName()));
            }
            return params;
        }

        public JFieldVar field() {
            return this.m_field;
        }

        public JMethod getter() {
            return this.m_getter;
        }

        public JMethod setter() {
            return this.m_setter;
        }
    }
}

