/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.lang;

import com.oracle.coherence.common.schema.AbstractTypeHandler;
import com.oracle.coherence.common.schema.Property;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.TypeDescriptor;
import com.oracle.coherence.common.schema.lang.AbstractLangType;
import com.oracle.coherence.common.schema.util.StringUtils;
import com.oracle.coherence.common.schema.util.XmlUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlTypeHandler<T extends AbstractLangType<? extends Property, TD>, TD extends TypeDescriptor>
extends AbstractTypeHandler<T, Element> {
    private String m_nsPrefix;
    private final String m_ns;
    private Class<TD> m_typeDescriptorClass;
    private Method m_parseMethod;

    public XmlTypeHandler(String ns) {
        this.m_ns = ns;
        Type superclass = this.getClass().getGenericSuperclass();
        this.m_typeDescriptorClass = (Class)((ParameterizedType)superclass).getActualTypeArguments()[1];
    }

    @Override
    public void importType(T type, Element source, Schema schema) {
        Element xmlType = XmlUtils.getChildElement(source, this.getNS(), "type");
        if (xmlType != null) {
            String name = xmlType.getAttribute("name");
            ((AbstractLangType)type).setDescriptor(this.parseTypeName(name));
            List<Element> aliases = XmlUtils.toElementList(xmlType.getElementsByTagNameNS(this.getNS(), "alias"));
            for (Element i : aliases) {
                name = i.getAttribute("name");
                ((AbstractLangType)type).addAlias(this.parseTypeName(name));
            }
            this.importTypeInternal(type, source, xmlType, schema);
        }
    }

    @Override
    public void exportType(T type, Element target, Schema schema) {
        if (((AbstractLangType)type).getDescriptor() != null) {
            Document doc = target.getOwnerDocument();
            doc.getDocumentElement().setAttribute("xmlns:" + this.getPrefix(), this.getNS());
            Element xmlType = doc.createElementNS(this.getNS(), this.getPrefix() + ":type");
            xmlType.setAttribute("name", ((AbstractLangType)type).getDescriptor().getFullName());
            for (TypeDescriptor i : ((AbstractLangType)type).getAliases()) {
                Element xmlInterface = doc.createElementNS(this.getNS(), this.getPrefix() + ":alias");
                xmlInterface.setAttribute("name", i.getFullName());
                xmlType.appendChild(xmlInterface);
            }
            this.exportTypeInternal(type, doc, target, xmlType, schema);
            target.appendChild(xmlType);
        }
    }

    protected void importTypeInternal(T type, Element source, Element xmlType, Schema schema) {
    }

    protected void exportTypeInternal(T type, Document doc, Element target, Element xmlType, Schema schema) {
    }

    protected TD parseTypeName(String name) {
        try {
            if (this.m_parseMethod == null) {
                this.m_parseMethod = this.m_typeDescriptorClass.getMethod("parse", String.class);
            }
            return (TD)((TypeDescriptor)this.m_parseMethod.invoke(this.m_typeDescriptorClass, name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getPrefix() {
        if (this.m_nsPrefix == null) {
            String[] ns = StringUtils.split(this.m_ns, "/");
            this.m_nsPrefix = ns[ns.length - 1];
        }
        return this.m_nsPrefix;
    }

    protected String getNS() {
        return this.m_ns;
    }
}

