/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.lang.java;

import com.oracle.coherence.common.schema.AbstractTypeDescriptor;
import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.lang.java.JavaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaTypeDescriptor
extends AbstractTypeDescriptor<JavaTypeDescriptor> {
    private static String[] JAVA_LANG = new String[]{"java", "lang"};
    private static String[] JAVA_MATH = new String[]{"java", "math"};
    private static String[] JAVA_UTIL = new String[]{"java", "util"};
    private static String[] JAVA_TIME = new String[]{"java", "time"};
    public static final JavaTypeDescriptor OBJECT = new JavaTypeDescriptor(JAVA_LANG, "Object");
    public static final JavaTypeParser PARSER = new JavaTypeParser(".");

    private JavaTypeDescriptor(String name) {
        super(name);
    }

    private JavaTypeDescriptor(String[] namespace, String name) {
        super(namespace, name);
    }

    private JavaTypeDescriptor(String[] namespace, String name, boolean fArray) {
        super(namespace, name, fArray);
    }

    private JavaTypeDescriptor(String[] namespace, String name, boolean fArray, List<JavaTypeDescriptor> genericArgs) {
        super(namespace, name, fArray, genericArgs);
    }

    public static JavaTypeDescriptor parse(String type) {
        return (JavaTypeDescriptor)PARSER.parse(type);
    }

    public static JavaTypeDescriptor fromInternal(String type) {
        return (JavaTypeDescriptor)PARSER.parseInternal(type);
    }

    public static JavaTypeDescriptor from(CanonicalTypeDescriptor type, Schema schema) {
        JavaTypeDescriptor jtd = new JavaTypeDescriptor(type.getNamespaceComponents(), type.getName(), type.isArray(), JavaTypeDescriptor.from(type.getGenericArguments(), schema));
        JavaType javaType = schema.getType(type, JavaType.class);
        if (javaType != null) {
            String name;
            String namespace = javaType.getNamespace();
            if (namespace != null) {
                jtd.setNamespace(namespace);
            }
            if ((name = javaType.getName()) != null) {
                jtd.setName(name);
            }
        }
        return jtd;
    }

    private static List<JavaTypeDescriptor> from(List<CanonicalTypeDescriptor> types, Schema schema) {
        if (types == null) {
            return null;
        }
        ArrayList<JavaTypeDescriptor> result = new ArrayList<JavaTypeDescriptor>(types.size());
        for (CanonicalTypeDescriptor type : types) {
            result.add(JavaTypeDescriptor.from(type, schema));
        }
        return result;
    }

    @Override
    protected JavaTypeDescriptor createArrayType(String[] namespace, String name) {
        return new JavaTypeDescriptor(namespace, name, true);
    }

    @Override
    protected AbstractTypeDescriptor.Parser getParser() {
        return PARSER;
    }

    private static class JavaTypeParser
    extends AbstractTypeDescriptor.Parser<JavaTypeDescriptor> {
        private static final Map<String, JavaTypeDescriptor> STANDARD_TYPES;

        public JavaTypeParser(String separator) {
            super(separator);
        }

        @Override
        protected JavaTypeDescriptor createTypeDescriptor(String[] namespace, String name, boolean fArray, List<JavaTypeDescriptor> genericArgs) {
            return new JavaTypeDescriptor(namespace, name, fArray, genericArgs);
        }

        @Override
        protected JavaTypeDescriptor getStandardType(String type) {
            return STANDARD_TYPES.get(type);
        }

        static {
            HashMap<String, JavaTypeDescriptor> map = new HashMap<String, JavaTypeDescriptor>();
            map.put("boolean", new JavaTypeDescriptor("boolean"));
            map.put("byte", new JavaTypeDescriptor("byte"));
            map.put("char", new JavaTypeDescriptor("char"));
            map.put("short", new JavaTypeDescriptor("short"));
            map.put("int", new JavaTypeDescriptor("int"));
            map.put("long", new JavaTypeDescriptor("long"));
            map.put("float", new JavaTypeDescriptor("float"));
            map.put("double", new JavaTypeDescriptor("double"));
            map.put("java.lang.Object", OBJECT);
            map.put("java.lang.String", new JavaTypeDescriptor(JAVA_LANG, "String"));
            map.put("java.math.BigDecimal", new JavaTypeDescriptor(JAVA_MATH, "BigDecimal"));
            map.put("java.math.BigInteger", new JavaTypeDescriptor(JAVA_MATH, "BigInteger"));
            map.put("java.util.Date", new JavaTypeDescriptor(JAVA_UTIL, "Date"));
            map.put("java.time.LocalDate", new JavaTypeDescriptor(JAVA_TIME, "LocalDate"));
            map.put("java.time.LocalDateTime", new JavaTypeDescriptor(JAVA_TIME, "LocalDateTime"));
            map.put("java.time.LocalTime", new JavaTypeDescriptor(JAVA_TIME, "LocalTime"));
            map.put("java.time.OffsetDateTime", new JavaTypeDescriptor(JAVA_TIME, "OffsetDateTime"));
            map.put("java.time.OffsetTime", new JavaTypeDescriptor(JAVA_TIME, "OffsetTime"));
            map.put("java.time.ZonedDateTime", new JavaTypeDescriptor(JAVA_TIME, "ZonedDateTime"));
            STANDARD_TYPES = map;
        }
    }
}

