/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.util;

import com.oracle.coherence.common.schema.util.CapitalizationTransformer;
import com.oracle.coherence.common.schema.util.NameTransformer;
import com.oracle.coherence.common.schema.util.PrefixTransformer;
import com.oracle.coherence.common.schema.util.SuffixTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class NameTransformerChain
implements NameTransformer {
    private List<NameTransformer> m_transformers = new ArrayList<NameTransformer>();

    public NameTransformerChain() {
    }

    public NameTransformerChain(NameTransformer ... transformers) {
        this.m_transformers.addAll(Arrays.asList(transformers));
    }

    public NameTransformerChain(Collection<NameTransformer> transformers) {
        this.m_transformers.addAll(transformers);
    }

    @Override
    public String transform(String source) {
        String result = source;
        for (NameTransformer t : this.m_transformers) {
            result = t.transform(result);
        }
        return result;
    }

    @Override
    public String[] transform(String[] source) {
        String[] result = source;
        if (result != null) {
            for (NameTransformer t : this.m_transformers) {
                result = t.transform(result);
            }
        }
        return result;
    }

    public NameTransformerChain add(NameTransformer transformer) {
        this.m_transformers.add(transformer);
        return this;
    }

    public NameTransformerChain toUppercase() {
        return this.add(new CapitalizationTransformer(CapitalizationTransformer.Mode.UPPER));
    }

    public NameTransformerChain toLowercase() {
        return this.add(new CapitalizationTransformer(CapitalizationTransformer.Mode.LOWER));
    }

    public NameTransformerChain firstLetterToUppercase() {
        return this.add(new CapitalizationTransformer(CapitalizationTransformer.Mode.FIRST_UPPER));
    }

    public NameTransformerChain firstLetterToLowercase() {
        return this.add(new CapitalizationTransformer(CapitalizationTransformer.Mode.FIRST_LOWER));
    }

    public NameTransformerChain addPrefix(String prefix) {
        return this.add(new PrefixTransformer(prefix, PrefixTransformer.Mode.ADD));
    }

    public NameTransformerChain removePrefix(String prefix) {
        return this.add(new PrefixTransformer(prefix, PrefixTransformer.Mode.REMOVE));
    }

    public NameTransformerChain addSuffix(String suffix) {
        return this.add(new SuffixTransformer(suffix, SuffixTransformer.Mode.ADD));
    }

    public NameTransformerChain removeSuffix(String suffix) {
        return this.add(new SuffixTransformer(suffix, SuffixTransformer.Mode.REMOVE));
    }
}

