/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bandwidth {
    private long m_cBits;
    private static final Pattern REGEX_PATTERN = Pattern.compile("([0-9]+(?:\\.[0-9]+)?)([kKMmGgTtPpEe]?)/?([Bb]?)[Pp/]?[Ss]");

    public Bandwidth(String s) {
        String string = s = s == null ? null : s.trim();
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("An empty or null string was provided.  Expected a bandwidth");
        }
        if (!s.equals("0")) {
            Matcher matcher = REGEX_PATTERN.matcher(s);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("The specified %s [%s] is invalid.", this.getClass().getName(), s));
            }
            Rate rate = Rate.fromSuffix(matcher.group(3));
            Magnitude magnitude = Magnitude.fromSuffix(matcher.group(2));
            double cUnits = Double.valueOf(matcher.group(1));
            this.m_cBits = rate.toBits(Math.round(cUnits * (double)magnitude.getFactor()));
        }
    }

    public Bandwidth(double cUnits, Rate rate) {
        assert (cUnits >= 0.0);
        this.m_cBits = rate.toBits(Math.round(cUnits));
    }

    public Bandwidth(int cUnits, Rate rate) {
        this((long)cUnits, rate);
    }

    public Bandwidth(long cBytes, Rate rate) {
        assert (cBytes >= 0L);
        this.m_cBits = rate.toBits(cBytes);
    }

    public long as(Magnitude magnitude) {
        return this.m_cBits / magnitude.getFactor();
    }

    public long as(Rate rate) {
        return rate.fromBits(this.m_cBits);
    }

    public String toString(boolean fExact) {
        int nSignificanceFactor;
        long nDecimals;
        Magnitude magnitude = Magnitude.BASE;
        long nBits = this.m_cBits;
        while (magnitude.next() != null && nBits >= magnitude.next().getFactor() && (fExact && nBits % magnitude.next().getFactor() % (magnitude.next().getFactor() / 4L) == 0L || !fExact)) {
            magnitude = magnitude.next();
        }
        long cMagnitudeUnits = nBits / magnitude.getFactor();
        long nRemainder = nBits % magnitude.getFactor();
        int cSignificantDigits = 3;
        StringBuilder bldrString = new StringBuilder();
        bldrString.append(cMagnitudeUnits);
        int cDigits = bldrString.length();
        int cRemainingDigits = cSignificantDigits - cDigits;
        if (cRemainingDigits > 0 && nRemainder > 0L && (nDecimals = (long)Math.floor((double)nRemainder * (double)(nSignificanceFactor = (int)Math.pow(10.0, cRemainingDigits)) / (double)magnitude.getFactor())) > 0L) {
            bldrString.append(".");
            int cLeadingZeros = cRemainingDigits - (int)Math.log10(nDecimals) - 1;
            for (int i = 0; i < cLeadingZeros; ++i) {
                bldrString.append('0');
            }
            bldrString.append(nDecimals);
        }
        bldrString.append(magnitude.getSuffix());
        bldrString.append("b/s");
        return bldrString.toString();
    }

    public int hashCode() {
        return 31 + (int)(this.m_cBits ^ this.m_cBits >>> 32);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof Bandwidth && ((Bandwidth)obj).m_cBits == this.m_cBits;
    }

    public String toString() {
        return this.toString(false);
    }

    public static enum Rate {
        BITS(0, "b"),
        BYTES(3, "B");

        private static final Rate[] VALUES;
        private final int SHIFT;
        private final String SUFFIX;

        private Rate(int cShift, String sSuffix) {
            this.SHIFT = cShift;
            this.SUFFIX = sSuffix;
        }

        public String getDescription() {
            return this.name().toLowerCase();
        }

        public String getSuffix() {
            return this.SUFFIX;
        }

        public long toBits(long cUnits) {
            return cUnits << this.SHIFT;
        }

        public long fromBits(long cBits) {
            return cBits >> this.SHIFT;
        }

        public static long convert(long cUnits, Rate rateFrom, Rate rateTo) {
            if (rateFrom.equals((Object)rateTo)) {
                return cUnits;
            }
            return rateTo.fromBits(rateFrom.toBits(cUnits));
        }

        public static Rate fromSuffix(String sSuffix) {
            if ((sSuffix = sSuffix.trim()).length() == 0) {
                return BITS;
            }
            if (sSuffix.length() > 0) {
                for (Rate rate : VALUES) {
                    if (!rate.getSuffix().equals(sSuffix)) continue;
                    return rate;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown %s suffix [%s]", Rate.class.getName(), sSuffix));
        }

        static {
            VALUES = Rate.values();
        }
    }

    public static enum Magnitude {
        BASE(1L, ""),
        KILO(1000L, "kilo"),
        MEGA(1000000L, "mega"),
        GIGA(1000000000L, "giga"),
        TERA(1000000000000L, "tera"),
        PETA(1000000000000000L, "peta"),
        EXA(1000000000000000000L, "exa");

        private final String DESCRIPTION;
        private final long FACTOR;
        private final String SUFFIX;
        private static final Magnitude[] VALUES;
        public static final Magnitude LOWEST;
        public static final Magnitude HIGHEST;

        private Magnitude(long nFactor, String sDescription) {
            this.DESCRIPTION = sDescription.trim();
            this.SUFFIX = this.DESCRIPTION.isEmpty() ? "" : this.DESCRIPTION.substring(0, 1);
            this.FACTOR = nFactor;
        }

        public String getDescription() {
            return this.DESCRIPTION;
        }

        public String getSuffix() {
            return this.SUFFIX;
        }

        public long getFactor() {
            return this.FACTOR;
        }

        public boolean isSuffix(String s) {
            return s.equalsIgnoreCase(this.SUFFIX);
        }

        public Magnitude next() {
            if (this.equals((Object)HIGHEST)) {
                return null;
            }
            return VALUES[this.ordinal() + 1];
        }

        public Magnitude previous() {
            if (this.equals((Object)LOWEST)) {
                return null;
            }
            return VALUES[this.ordinal() - 1];
        }

        public static Magnitude fromSuffix(String sSuffix) {
            if ((sSuffix = sSuffix.trim()).length() == 0) {
                return BASE;
            }
            if (sSuffix.length() > 0) {
                for (Magnitude magnitude : VALUES) {
                    if (!magnitude.isSuffix(sSuffix)) continue;
                    return magnitude;
                }
            }
            throw new IllegalArgumentException(String.format("Unknown %s suffix [%s]", Magnitude.class.getName(), sSuffix));
        }

        static {
            VALUES = Magnitude.values();
            LOWEST = VALUES[0];
            HIGHEST = VALUES[VALUES.length - 1];
        }
    }
}

