/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.base.Associated;
import com.oracle.coherence.common.base.ConcurrentNotifier;
import com.oracle.coherence.common.collections.ConcurrentHashMap;
import com.oracle.coherence.common.util.AssociationPile;
import com.oracle.coherence.common.util.Sentry;
import com.oracle.coherence.common.util.ThreadGate;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class ConcurrentAssociationPile<T, A>
extends ConcurrentNotifier
implements AssociationPile<T> {
    protected final AtomicLong f_nPosCounter = new AtomicLong();
    protected long m_cAdds;
    protected final LongAdder f_cValues = new LongAdder();
    protected final AtomicLong f_cAssociatedPendingRelease = new AtomicLong();
    protected final ConcurrentSkipListSet<Node<T>> f_queueAvailablePriority = new ConcurrentSkipListSet();
    protected final ConcurrentLinkedQueue<T> f_queueAvailable = new ConcurrentLinkedQueue();
    protected int m_cPolls;
    protected long m_lPosAvailableLast;
    protected final ConcurrentHashMap<A, CloseableQueue<Node<T>>> f_mapQueueDeferred = new ConcurrentHashMap();
    protected final ConcurrentSkipListSet<Node<T>> f_queueDeferredAlls = new ConcurrentSkipListSet();
    protected long m_lPosNextAll = Long.MAX_VALUE;
    protected ThreadGate.NonReentrant f_gateAll = new ThreadGate.NonReentrant();
    protected static final int MAX_UNFAIRNESS_VARIANCE = Integer.parseInt(System.getProperty(ConcurrentAssociationPile.class.getCanonicalName() + ".maxVariance", String.valueOf(Runtime.getRuntime().availableProcessors() * 4)));
    protected final CloseableQueue<Node<T>> EMPTY_QUEUE = EMPTY_QUEUE_UNTYPED;
    protected static final CloseableQueue EMPTY_QUEUE_UNTYPED = new CloseableQueue(){

        @Override
        public boolean add(Object o) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isOpen() {
            return false;
        }
    };

    @Override
    public boolean add(T value) {
        this.f_cValues.increment();
        A key = this.getAssociation(value);
        if (key == null) {
            return this.addAvailable(value);
        }
        if (key == ASSOCIATION_ALL) {
            return this.handleAddAll(value);
        }
        try (Sentry sentry = this.f_gateAll.enter();){
            CloseableQueue<Node<T>> queue = this.m_lPosNextAll == Long.MAX_VALUE ? this.f_mapQueueDeferred.putIfAbsent(key, this.EMPTY_QUEUE) : this.EMPTY_QUEUE;
            boolean bl = queue == null ? this.addAvailable(value) : this.handleAssociatedAdd(key, value, queue);
            return bl;
        }
    }

    @Override
    public T poll() {
        T value;
        boolean fPriority = (++this.m_cPolls & 1) == 0;
        Node<T> node = null;
        if (fPriority) {
            node = this.f_queueAvailablePriority.pollFirst();
            value = node == null ? this.f_queueAvailable.poll() : node.getValue();
        } else {
            value = this.f_queueAvailable.poll();
            if (value == null) {
                node = this.f_queueAvailablePriority.pollFirst();
                value = node == null ? null : node.getValue();
                Object v0 = value;
            }
        }
        if (value != null) {
            this.f_cValues.decrement();
        }
        return value;
    }

    @Override
    public void release(T value) {
        A key = this.getAssociation(value);
        if (key != null) {
            if (key == ASSOCIATION_ALL) {
                this.handleReleaseAll();
            } else {
                try (Sentry sentry = this.f_gateAll.enter();){
                    Node<T> node;
                    Node<T> node2 = node = this.f_mapQueueDeferred.remove(key, this.EMPTY_QUEUE) ? null : this.pollOrRemoveAssociation(key);
                    if (this.m_lPosNextAll < Long.MAX_VALUE) {
                        this.handlePostReleaseWithPendingAll(node);
                    } else if (node != null) {
                        this.addAvailable((T)node);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("while releasing " + value + " of " + value.getClass(), e);
                }
            }
        }
    }

    @Override
    public int size() {
        return Math.max(0, this.f_cValues.intValue());
    }

    @Override
    public boolean isAvailable() {
        return !this.f_queueAvailable.isEmpty() || !this.f_queueAvailablePriority.isEmpty();
    }

    @Override
    protected boolean isReady() {
        return this.isAvailable();
    }

    public String toString() {
        return this.getClass().getCanonicalName() + " size=" + this.size() + ", available=" + this.isAvailable() + ", associations=" + this.f_mapQueueDeferred.size();
    }

    protected Node<T> makeNode(T value, long lPosition) {
        return new SimpleNode<T>(value, lPosition);
    }

    protected A getAssociation(T value) {
        return value instanceof Associated ? (A)((Associated)value).getAssociatedKey() : null;
    }

    protected boolean addAvailable(Node<T> node) {
        long lPos = node.getPosition();
        if (this.m_lPosAvailableLast - lPos > (long)MAX_UNFAIRNESS_VARIANCE) {
            this.f_queueAvailablePriority.add(node);
        } else {
            this.m_lPosAvailableLast = lPos;
            this.f_queueAvailable.add(node.getValue());
        }
        this.signal();
        return true;
    }

    protected boolean addAvailable(T value) {
        this.m_lPosAvailableLast = ++this.m_cAdds;
        this.f_queueAvailable.add(value);
        this.signal();
        return true;
    }

    protected boolean handleAddAll(T valueAll) {
        try (Sentry sentry = this.f_gateAll.close();){
            long lPos = this.nextPosition();
            if (this.m_lPosNextAll == Long.MAX_VALUE) {
                if (this.f_mapQueueDeferred.isEmpty()) {
                    this.m_lPosNextAll = lPos;
                    this.addAvailable(valueAll);
                } else {
                    this.m_lPosNextAll = lPos;
                    this.f_queueDeferredAlls.add(this.makeNode(valueAll, lPos));
                    this.f_cAssociatedPendingRelease.set(this.f_mapQueueDeferred.size());
                }
            } else {
                this.f_queueDeferredAlls.add(this.makeNode(valueAll, lPos));
            }
        }
        return true;
    }

    protected void handleReleaseAll() {
        try (Sentry sentry = this.f_gateAll.close();){
            this.m_lPosNextAll = Long.MAX_VALUE;
            int cAssociatedPendingRelease = 0;
            Node<T> node = this.f_queueDeferredAlls.pollFirst();
            while (node != null) {
                if (this.getAssociation(node.getValue()) == ASSOCIATION_ALL) {
                    this.m_lPosNextAll = node.getPosition();
                    if (cAssociatedPendingRelease == 0) {
                        this.addAvailable((T)node);
                    } else {
                        this.f_queueDeferredAlls.add(node);
                        this.f_cAssociatedPendingRelease.set(cAssociatedPendingRelease);
                    }
                    break;
                }
                this.addAvailable((T)node);
                ++cAssociatedPendingRelease;
                node = this.f_queueDeferredAlls.pollFirst();
            }
        }
    }

    protected boolean handleAssociatedAdd(A key, T value, CloseableQueue<Node<T>> queue) {
        boolean fAdded;
        Node<T> node = this.makeNode(value, this.nextPosition());
        boolean fNoAll = this.m_lPosNextAll == Long.MAX_VALUE;
        boolean bl = fAdded = fNoAll && queue.add(node);
        while (!fAdded) {
            queue = this.f_mapQueueDeferred.putIfAbsent(key, this.EMPTY_QUEUE);
            fAdded = queue == null ? (fNoAll ? this.addAvailable(value) : this.f_queueDeferredAlls.add(node)) : (queue == this.EMPTY_QUEUE ? this.f_mapQueueDeferred.replace(key, this.EMPTY_QUEUE, new CloseableQueue<Node<T>>(node)) : queue.add(node));
        }
        return true;
    }

    protected long nextPosition() {
        long lPosCurr = this.f_nPosCounter.get();
        long lPosNext = Math.max(lPosCurr, this.m_cAdds) + 1L;
        while (!this.f_nPosCounter.compareAndSet(lPosCurr, lPosNext)) {
            lPosCurr = this.f_nPosCounter.get();
            lPosNext = Math.max(lPosCurr, this.m_cAdds) + 1L;
        }
        this.m_cAdds = lPosNext;
        return lPosNext;
    }

    protected void handlePostReleaseWithPendingAll(Node<T> nodeNext) {
        if (nodeNext == null || nodeNext.getPosition() > this.m_lPosNextAll && this.f_queueDeferredAlls.add(nodeNext)) {
            if (this.f_cAssociatedPendingRelease.decrementAndGet() == 0L) {
                this.addAvailable((T)this.f_queueDeferredAlls.pollFirst());
            }
        } else {
            this.addAvailable((T)nodeNext);
        }
    }

    protected Node<T> pollOrRemoveAssociation(A key) {
        CloseableQueue queue = (CloseableQueue)this.f_mapQueueDeferred.get(key);
        if (queue == null) {
            throw new IllegalArgumentException("association " + key + " of " + key.getClass() + " is not currently pending release in the pile");
        }
        Node node = (Node)queue.poll();
        if (node == null) {
            try (Sentry sentry = queue.f_gate.close();){
                node = (Node)queue.poll();
                if (node == null) {
                    queue.close();
                    this.f_mapQueueDeferred.remove(key);
                }
            }
        }
        return node;
    }

    protected static class CloseableQueue<E>
    extends ConcurrentLinkedQueue<E>
    implements AutoCloseable {
        protected boolean m_fClosed;
        protected final ThreadGate.NonReentrant f_gate = new ThreadGate.NonReentrant();

        public CloseableQueue() {
        }

        public CloseableQueue(E initial) {
            this();
            super.add(initial);
        }

        @Override
        public boolean add(E e) {
            try (Sentry sentry = this.f_gate.enter();){
                boolean bl = this.isOpen() && super.add(e);
                return bl;
            }
        }

        @Override
        public void close() {
            this.m_fClosed = true;
        }

        public boolean isOpen() {
            return !this.m_fClosed;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    protected static class SimpleNode<T>
    implements Node<T> {
        protected final T f_value;
        protected long m_lPosition;

        public SimpleNode(T value, long lPosition) {
            this.f_value = value;
            this.m_lPosition = lPosition;
        }

        @Override
        public long getPosition() {
            return this.m_lPosition;
        }

        @Override
        public T getValue() {
            return this.f_value;
        }
    }

    protected static interface Node<T>
    extends Comparable<Node<T>> {
        public long getPosition();

        public T getValue();

        @Override
        default public int compareTo(Node<T> o) {
            return Long.compare(this.getPosition(), o.getPosition());
        }
    }
}

