/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.IdentityHolder;
import com.oracle.coherence.common.base.MutableLong;
import com.oracle.coherence.common.collections.ConcurrentHashMap;
import com.oracle.coherence.common.collections.InflatableMap;
import com.oracle.coherence.common.util.Gate;
import com.oracle.coherence.common.util.SafeClock;
import com.oracle.coherence.common.util.Sentry;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadGate<R>
implements Gate {
    public static final int GATE_OPEN = 0;
    public static final int GATE_CLOSING = 1;
    public static final int GATE_CLOSED = 2;
    public static final int GATE_DESTROYED = 3;
    private static final int STATUS_OFFSET = 60;
    private static final long ACTIVE_COUNT_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long EMPTY_GATE_OPEN = 0L;
    private static final long FULL_GATE_OPEN = 0xFFFFFFFFFFFFFFFL;
    private static final long EMPTY_GATE_CLOSING = 0x1000000000000000L;
    private static final long EMPTY_GATE_CLOSED = 0x2000000000000000L;
    private final R f_resource;
    protected final AtomicLong f_atomicState = new AtomicLong();
    private int m_cClose;
    private volatile transient Object m_closer;
    private final ThreadLocal<int[]> f_tlcEnters = new ThreadLocal();
    private volatile ConcurrentHashMap<IdentityHolder<Object>, MutableLong> m_mapContenderEnters;
    protected final Sentry<R> f_exitSentry = new Sentry<R>(){

        @Override
        public R getResource() {
            return ThreadGate.this.f_resource;
        }

        @Override
        public void close() {
            ThreadGate.this.exit();
        }
    };
    protected final Sentry<R> f_openSentry = new Sentry<R>(){

        @Override
        public R getResource() {
            return ThreadGate.this.f_resource;
        }

        @Override
        public void close() {
            ThreadGate.this.open();
        }
    };

    public ThreadGate() {
        this(null);
    }

    public ThreadGate(R resource) {
        this.f_resource = resource;
    }

    @Override
    public boolean barEntry(long cMillis) {
        return this.barEntryInternal(Thread.currentThread(), cMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean barEntry(Object oContender, long cMillis) {
        Object object = oContender;
        synchronized (object) {
            return this.barEntryInternal(oContender, cMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean barEntryInternal(Object oContender, long cMillis) {
        if (oContender == this.getCloser()) {
            this.setCloseCount(this.getCloseCount() + 1);
            return true;
        }
        ThreadGate threadGate = this;
        synchronized (threadGate) {
            do {
                if (this.getCloser() != null) continue;
                if (this.updateStatus(1) == 3) {
                    this.updateStatus(3);
                    throw new IllegalStateException("ThreadGate.close: ThreadGate has been destroyed.");
                }
                this.setCloser(oContender);
                this.setCloseCount(1);
                return true;
            } while ((cMillis = this.doWait(cMillis)) != 0L);
            return false;
        }
    }

    @Override
    public Sentry<R> close() {
        this.close(-1L);
        return this.f_openSentry;
    }

    @Override
    public boolean close(long cMillis) {
        return this.closeInternal(Thread.currentThread(), cMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(Object oContender, long cMillis) {
        Object object = oContender;
        synchronized (object) {
            return this.closeInternal(oContender, cMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean closeInternal(Object oContender, long cMillis) {
        if (oContender == this.getCloser() && this.getStatus() == 2) {
            this.setCloseCount(this.getCloseCount() + 1);
            return true;
        }
        AtomicLong atomicState = this.f_atomicState;
        long cEnterThis = Math.min(1L, this.getEnterCount(oContender));
        long lStatusReq = 0L | cEnterThis;
        long lStatusEnd = 0x2000000000000000L | cEnterThis;
        boolean fReenter = false;
        boolean fReopen = false;
        ThreadGate threadGate = this;
        synchronized (threadGate) {
            try {
                if (oContender == this.getCloser()) {
                    lStatusReq = 0x1000000000000000L;
                    if (cEnterThis > 0L) {
                        fReenter = true;
                        atomicState.addAndGet(-cEnterThis);
                    }
                }
                while (true) {
                    if (atomicState.compareAndSet(lStatusReq, lStatusEnd)) {
                        this.setCloseCount(this.getCloseCount() + 1);
                        this.setCloser(oContender);
                        fReopen = false;
                        fReenter = false;
                        boolean bl = true;
                        return bl;
                    }
                    if (this.getCloser() == null) {
                        if (this.updateStatus(1) == 3) {
                            this.updateStatus(3);
                            throw new IllegalStateException("ThreadGate.close: ThreadGate has been destroyed.");
                        }
                        this.setCloser(oContender);
                        lStatusReq = 0x1000000000000000L;
                        fReopen = true;
                        if (cEnterThis <= 0L) continue;
                        fReenter = true;
                        atomicState.addAndGet(-cEnterThis);
                        continue;
                    }
                    if ((cMillis = this.doWait(cMillis)) == 0L) break;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (fReenter) {
                    atomicState.addAndGet(cEnterThis);
                }
                if (fReopen) {
                    this.setCloser(null);
                    this.updateStatus(0);
                    this.notifyAll();
                }
            }
        }
    }

    public void destroy() {
        this.destroyInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            this.destroyInternal(oContender);
        }
    }

    protected synchronized void destroyInternal(Object oContender) {
        switch (this.getStatus()) {
            case 2: {
                if (oContender != this.getCloser()) {
                    throw new IllegalStateException("ThreadGate.destroy: Gate was not closed by " + oContender + "; " + this);
                }
                this.updateStatus(3);
                this.setCloser(null);
                this.notifyAll();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("ThreadGate.destroy: Gate is not closed! " + this);
            }
        }
    }

    @Override
    public boolean enter(long cMillis) {
        if (this.adjustThreadLocalEnters(1) > 1) {
            return true;
        }
        AtomicLong atomicState = this.f_atomicState;
        long lStatus = atomicState.get();
        while (lStatus < 0xFFFFFFFFFFFFFFFL) {
            if (atomicState.compareAndSet(lStatus, lStatus + 1L)) {
                return true;
            }
            lStatus = atomicState.get();
        }
        this.adjustThreadLocalEnters(-1);
        return this.enterInternal(Thread.currentThread(), cMillis);
    }

    @Override
    public Sentry<R> enter() {
        this.enter(-1L);
        return this.f_exitSentry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enter(Object oContender, long cMillis) {
        Object object = oContender;
        synchronized (object) {
            return this.enterInternal(oContender, cMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean enterInternal(Object oContender, long cMillis) {
        AtomicLong atomicState = this.f_atomicState;
        if (this.incrementEnterCount(oContender) > 1L) {
            return true;
        }
        if (oContender == this.getCloser()) {
            if ((atomicState.get() & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
                this.decrementEnterCount(oContender);
                throw new IllegalStateException("The ThreadGate is full.");
            }
            atomicState.incrementAndGet();
            return true;
        }
        boolean fSuccess = false;
        try {
            block13: while (true) {
                long lStatus = atomicState.get();
                switch ((int)(lStatus >>> 60)) {
                    case 0: {
                        if ((lStatus & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
                            throw new IllegalStateException("The ThreadGate is full.");
                        }
                        if (!atomicState.compareAndSet(lStatus, lStatus + 1L)) continue block13;
                        fSuccess = true;
                        boolean bl = true;
                        return bl;
                    }
                    case 1: 
                    case 2: {
                        ThreadGate threadGate = this;
                        synchronized (threadGate) {
                            long nStatus = this.getStatus();
                            if ((nStatus == 1L || nStatus == 2L) && (cMillis = this.doWait(cMillis)) == 0L) {
                                boolean bl = false;
                                return bl;
                            }
                            continue block13;
                        }
                    }
                    case 3: {
                        throw new IllegalStateException("ThreadGate.enter: ThreadGate has been destroyed.");
                    }
                }
                throw new IllegalStateException("ThreadGate.enter: ThreadGate has an invalid status. " + this);
            }
        }
        finally {
            if (!fSuccess) {
                this.decrementEnterCount(oContender);
            }
        }
    }

    @Override
    public void exit() {
        this.exitInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            this.exitInternal(oContender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitInternal(Object oContender) {
        long cEnterThis = this.decrementEnterCount(oContender);
        if (cEnterThis == 0L) {
            if (this.f_atomicState.decrementAndGet() == 0x1000000000000000L) {
                ThreadGate threadGate = this;
                synchronized (threadGate) {
                    this.notifyAll();
                }
            }
        } else if (cEnterThis < 0L) {
            throw new IllegalMonitorStateException("ThreadGate.exit: (" + oContender + ") has already exited! " + this);
        }
    }

    @Override
    public void open() {
        this.openInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            this.openInternal(oContender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openInternal(Object oContender) {
        int cClosed;
        if (oContender == this.getCloser() && (cClosed = this.getCloseCount() - 1) >= 0) {
            this.setCloseCount(cClosed);
            if (cClosed == 0) {
                ThreadGate threadGate = this;
                synchronized (threadGate) {
                    this.updateStatus(0);
                    this.setCloser(null);
                    this.notifyAll();
                }
            }
            return;
        }
        throw new IllegalMonitorStateException("ThreadGate.open: Gate was not closed by " + oContender + ";" + this);
    }

    @Override
    public boolean isClosedByCurrentThread() {
        return this.isClosedByInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedBy(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            return this.isClosedByInternal(oContender);
        }
    }

    protected boolean isClosedByInternal(Object oContender) {
        return oContender == this.getCloser() && this.getStatus() == 2;
    }

    @Override
    public boolean isEnteredByCurrentThread() {
        return this.isEnteredByInternal(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnteredBy(Object oContender) {
        Object object = oContender;
        synchronized (object) {
            return this.isClosedByInternal(oContender);
        }
    }

    protected boolean isEnteredByInternal(Object oContender) {
        return this.getEnterCount(oContender) > 0L;
    }

    @Override
    public boolean isClosed() {
        return this.getStatus() == 2;
    }

    protected long doWait(long cMillis) {
        if (cMillis == 0L) {
            return 0L;
        }
        long lTime = SafeClock.INSTANCE.getSafeTimeMillis();
        try {
            Blocking.wait(this, Math.max(0L, cMillis));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.onInterruptedException(e);
        }
        return cMillis < 0L ? cMillis : Math.max(0L, cMillis - (SafeClock.INSTANCE.getSafeTimeMillis() - lTime));
    }

    public int getActiveCount() {
        return (int)(this.f_atomicState.get() & 0xFFFFFFFFFFFFFFFL);
    }

    public int getCloseCount() {
        return this.m_cClose;
    }

    protected void setCloseCount(int cClose) {
        this.m_cClose = cClose;
    }

    protected Object getCloser() {
        return this.m_closer;
    }

    protected void setCloser(Object oCloser) {
        this.m_closer = oCloser;
    }

    public int getStatus() {
        return (int)(this.f_atomicState.get() >>> 60);
    }

    protected int updateStatus(int nStatus) {
        long lNew;
        long lCurr;
        AtomicLong atomicState = this.f_atomicState;
        long lStatus = (long)nStatus << 60;
        while (!atomicState.compareAndSet(lCurr = atomicState.get(), lNew = lStatus | lCurr & 0xFFFFFFFFFFFFFFFL)) {
        }
        return (int)(lCurr >>> 60);
    }

    public synchronized String toString() {
        String sState;
        switch (this.getStatus()) {
            case 0: {
                sState = "GATE_OPEN";
                break;
            }
            case 1: {
                sState = "GATE_CLOSING";
                break;
            }
            case 2: {
                sState = "GATE_CLOSED";
                break;
            }
            case 3: {
                sState = "GATE_DESTROYED";
                break;
            }
            default: {
                sState = "INVALID";
            }
        }
        return "ThreadGate{State=" + sState + ", ActiveCount=" + this.getActiveCount() + ", CloseCount=" + this.getCloseCount() + ", Closer= " + this.getCloser() + '}';
    }

    protected void onInterruptedException(InterruptedException e) {
        throw new RuntimeException(this.toString(), e);
    }

    protected static MutableLong makeCounterFromHolder(IdentityHolder<Object> oHolder) {
        return ThreadGate.makeCounter(oHolder.get());
    }

    protected static MutableLong makeCounter(Object oContender) {
        if (oContender instanceof Thread) {
            throw new IllegalArgumentException("thread based contenders may only be the current thread");
        }
        return new MutableLong();
    }

    protected long getEnterCount(Object oContender) {
        return oContender == Thread.currentThread() ? (long)this.adjustThreadLocalEnters(0) : (oContender instanceof LiteContender ? ((LiteContender)oContender).getCount(this) : (oContender == this.f_atomicState ? 0L : this.ensureEnterCountMap().getOrDefault(new IdentityHolder<Object>(oContender), ThreadGate.makeCounter(oContender)).get()));
    }

    protected long incrementEnterCount(Object oContender) {
        return oContender == Thread.currentThread() ? (long)this.adjustThreadLocalEnters(1) : (oContender instanceof LiteContender ? ((LiteContender)oContender).incrementAndGet(this) : (oContender == this.f_atomicState ? 0L : this.ensureEnterCountMap().computeIfAbsent(new IdentityHolder<Object>(oContender), ThreadGate::makeCounterFromHolder).incrementAndGet()));
    }

    protected long decrementEnterCount(Object oContender) {
        return oContender == Thread.currentThread() ? (long)this.adjustThreadLocalEnters(-1) : (oContender instanceof LiteContender ? ((LiteContender)oContender).decrementAndGet(this) : (oContender == this.f_atomicState ? 0L : this.decrementEnterCountComplex(oContender)));
    }

    protected long decrementEnterCountComplex(Object oContender) {
        IdentityHolder<Object> oHolder;
        ConcurrentHashMap<IdentityHolder<Object>, MutableLong> map = this.ensureEnterCountMap();
        MutableLong cEnter = (MutableLong)map.get(oHolder = new IdentityHolder<Object>(oContender));
        if (cEnter == null) {
            if (oContender instanceof Thread) {
                throw new IllegalArgumentException("thread-based contenders may only be the current thread");
            }
            return -1L;
        }
        long c = cEnter.decrementAndGet();
        if (c <= 0L) {
            map.remove(oHolder, cEnter);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrentHashMap<IdentityHolder<Object>, MutableLong> ensureEnterCountMap() {
        ConcurrentHashMap<IdentityHolder<Object>, MutableLong> map = this.m_mapContenderEnters;
        if (map == null) {
            ThreadGate threadGate = this;
            synchronized (threadGate) {
                map = this.m_mapContenderEnters;
                if (map == null) {
                    map = this.m_mapContenderEnters = new ConcurrentHashMap();
                }
            }
        }
        return map;
    }

    protected int adjustThreadLocalEnters(int c) {
        int i;
        int[] ai = this.f_tlcEnters.get();
        if (ai == null) {
            ai = new int[1];
            this.f_tlcEnters.set(ai);
        }
        if ((i = ai[0] + c) >= 0) {
            ai[0] = i;
        }
        return i;
    }

    public static class NonReentrant<R>
    extends ThreadGate<R> {
        public NonReentrant() {
            this(null);
        }

        public NonReentrant(R resource) {
            super(resource);
        }

        @Override
        public boolean enter(long cMillis) {
            AtomicLong atomicState = this.f_atomicState;
            long lStatus = atomicState.get();
            while (lStatus < 0xFFFFFFFFFFFFFFFL) {
                if (atomicState.compareAndSet(lStatus, lStatus + 1L)) {
                    return true;
                }
                lStatus = atomicState.get();
            }
            return this.enterInternal(this.f_atomicState, cMillis);
        }

        @Override
        public boolean enter(Object oContender, long cMillis) {
            return this.enter(cMillis);
        }

        @Override
        public void exit() {
            this.exitInternal(this.f_atomicState);
        }

        @Override
        public void exit(Object oContender) {
            this.exitInternal(this.f_atomicState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void exitInternal(Object oContender) {
            long lStatus = this.f_atomicState.decrementAndGet();
            if (lStatus == 0x1000000000000000L) {
                NonReentrant nonReentrant = this;
                synchronized (nonReentrant) {
                    this.notifyAll();
                }
            } else if (lStatus < 0L) {
                throw new IllegalStateException();
            }
        }
    }

    public static class LiteContender
    extends InflatableMap<ThreadGate, MutableLong> {
        private ThreadGate m_gatePrimary;
        private long m_cEntersPrimary;

        protected long incrementAndGet(ThreadGate gate) {
            return gate == this.m_gatePrimary ? (this.m_cEntersPrimary = this.m_cEntersPrimary + 1L) : this.incrementComplex(gate);
        }

        protected long incrementComplex(ThreadGate gate) {
            MutableLong cEnters = (MutableLong)this.get(gate);
            if (cEnters == null) {
                if (this.m_gatePrimary == null) {
                    this.m_gatePrimary = gate;
                    this.m_cEntersPrimary = 1L;
                    return 1L;
                }
                cEnters = new MutableLong();
                this.put(gate, cEnters);
            }
            return cEnters.incrementAndGet();
        }

        protected long decrementAndGet(ThreadGate gate) {
            if (gate == this.m_gatePrimary) {
                long cEnters;
                if ((cEnters = --this.m_cEntersPrimary) <= 0L) {
                    this.m_gatePrimary = null;
                    this.m_cEntersPrimary = 0L;
                }
                return cEnters;
            }
            MutableLong cEnters = (MutableLong)this.get(gate);
            return cEnters == null ? -1L : cEnters.decrementAndGet();
        }

        protected long getCount(ThreadGate gate) {
            if (gate == this.m_gatePrimary) {
                return this.m_cEntersPrimary;
            }
            MutableLong cEnters = (MutableLong)this.get(gate);
            return cEnters == null ? 0L : cEnters.get();
        }
    }
}

