/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.inject;

import com.oracle.coherence.inject.Injector;
import java.util.ServiceLoader;
import javax.annotation.Priority;

class InjectorProvider {
    private static final Injector INSTANCE = target -> {};

    private InjectorProvider() {
    }

    public static Injector getInstance() {
        return LazyHolder.SINGLETON;
    }

    static Injector getInjector() {
        Injector injector = INSTANCE;
        int nPriority = Integer.MIN_VALUE;
        for (Injector instance : ServiceLoader.load(Injector.class)) {
            Priority priority = instance.getClass().getAnnotation(Priority.class);
            if (priority != null && priority.value() > nPriority) {
                injector = instance;
                nPriority = priority.value();
                continue;
            }
            if (nPriority != Integer.MIN_VALUE) continue;
            injector = instance;
        }
        return injector;
    }

    private static class LazyHolder {
        static final Injector SINGLETON = InjectorProvider.getInjector();

        private LazyHolder() {
        }
    }
}

