/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.persistence;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PersistenceStatistics
implements Iterable<String> {
    private final Map<String, CachePersistenceStatistics> f_mapStats = new LinkedHashMap<String, CachePersistenceStatistics>();

    public String toString() {
        StringBuilder sb = new StringBuilder("Cache Statistics\n\n");
        this.f_mapStats.values().forEach(sb::append);
        return sb.toString();
    }

    @Override
    public Iterator<String> iterator() {
        return this.f_mapStats.keySet().iterator();
    }

    public void incrementSize(String sCacheName) {
        this.ensureCacheStats(sCacheName).incrementSize();
    }

    public void addToBytes(String sCacheName, long cBytes) {
        this.ensureCacheStats(sCacheName).addToBytes(cBytes);
    }

    public void incrementIndexes(String sCacheName) {
        this.ensureCacheStats(sCacheName).incrementIndexes();
    }

    public void incrementTriggers(String sCacheName) {
        this.ensureCacheStats(sCacheName).incrementTriggers();
    }

    public void incrementLocks(String sCacheName) {
        this.ensureCacheStats(sCacheName).incrementTriggers();
    }

    public void incrementListeners(String sCacheName) {
        this.ensureCacheStats(sCacheName).incrementListeners();
    }

    public long getCacheSize(String sCacheName) {
        CachePersistenceStatistics stats = this.f_mapStats.get(sCacheName);
        return stats == null ? -1L : stats.getSize();
    }

    public long getCacheBytes(String sCacheName) {
        CachePersistenceStatistics stats = this.f_mapStats.get(sCacheName);
        return stats == null ? -1L : stats.getBytes();
    }

    public int getIndexCount(String sCacheName) {
        CachePersistenceStatistics stats = this.f_mapStats.get(sCacheName);
        return stats == null ? -1 : stats.getIndexCount();
    }

    public int getTriggerCount(String sCacheName) {
        CachePersistenceStatistics stats = this.f_mapStats.get(sCacheName);
        return stats == null ? -1 : stats.getTriggerCount();
    }

    public int getLockCount(String sCacheName) {
        CachePersistenceStatistics stats = this.f_mapStats.get(sCacheName);
        return stats == null ? -1 : stats.getLockCount();
    }

    public int getListenerCount(String sCacheName) {
        CachePersistenceStatistics stats = this.f_mapStats.get(sCacheName);
        return stats == null ? -1 : stats.getListenerCount();
    }

    protected CachePersistenceStatistics ensureCacheStats(String sCacheName) {
        CachePersistenceStatistics stats = this.f_mapStats.get(sCacheName);
        if (stats == null) {
            stats = new CachePersistenceStatistics(sCacheName);
            this.f_mapStats.put(sCacheName, stats);
        }
        return stats;
    }

    protected class CachePersistenceStatistics {
        private final String f_sCacheName;
        protected long m_cSize = 0L;
        protected long m_cBytes = 0L;
        protected int m_cTriggers = 0;
        protected int m_cIndexes = 0;
        protected int m_cLocks = 0;
        protected int m_cListeners = 0;

        protected CachePersistenceStatistics(String sCacheName) {
            this.f_sCacheName = sCacheName;
        }

        public void incrementSize() {
            ++this.m_cSize;
        }

        public void addToBytes(long cBytes) {
            this.m_cBytes += cBytes;
        }

        public void incrementTriggers() {
            ++this.m_cTriggers;
        }

        public void incrementIndexes() {
            ++this.m_cIndexes;
        }

        public void incrementLocks() {
            ++this.m_cLocks;
        }

        public void incrementListeners() {
            ++this.m_cListeners;
        }

        public String getCacheName() {
            return this.f_sCacheName;
        }

        public long getSize() {
            return this.m_cSize;
        }

        public long getBytes() {
            return this.m_cBytes;
        }

        public int getIndexCount() {
            return this.m_cIndexes;
        }

        public int getTriggerCount() {
            return this.m_cTriggers;
        }

        public int getLockCount() {
            return this.m_cLocks;
        }

        public int getListenerCount() {
            return this.m_cListeners;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PersistenceStatistics(cacheName=");
            sb.append(this.f_sCacheName).append(", size=").append(this.m_cSize).append(", bytes=").append(this.m_cBytes).append(", indexes=").append(this.m_cIndexes).append(", triggers=").append(this.m_cTriggers).append(", locks=").append(this.m_cLocks).append(", listeners=").append(this.m_cListeners).append(")");
            return sb.toString();
        }
    }
}

