/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$PacketListenerBU$Queue;
import com.tangosol.coherence.component.net.Cluster$SocketManager$BroadcastUdpSocket;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketListener;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;

public class Cluster$PacketListenerBU
extends PacketListener {
    private boolean __m_InGroup;
    private boolean __m_SuspectBinding;
    private long __m_SuspectGroupTimestamp;
    private static ListMap __mapChildren;

    static {
        Cluster$PacketListenerBU.__initStatic();
    }

    public Cluster$PacketListenerBU() {
        this(null, null, true);
    }

    public Cluster$PacketListenerBU(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Queue", Cluster$PacketListenerBU$Queue.get_CLASS());
    }

    public void ensureBinding() {
        boolean fRebound = false;
        if (this.isSuspectBinding()) {
            ((Cluster$SocketManager$BroadcastUdpSocket)this.getUdpSocket()).rebind();
            this.setSuspectBinding(false);
            fRebound = true;
        } else if (((Cluster)this.get_Module()).getTcpBroadcastListener().isStarted()) {
            this.setSuspectBinding(true);
            ByteBuffer bufTest = ByteBuffer.allocate(4);
            ((Buffer)bufTest.putInt(Packet.TYPE_TEST_MULTICAST)).flip();
            DatagramSocket socket = this.getUdpSocket().getDatagramSocket();
            InetAddress addrLocal = socket.getLocalAddress();
            if (addrLocal == null ? true : addrLocal.isAnyLocalAddress()) {
                addrLocal = InetAddress.getLoopbackAddress();
            }
            try {
                socket.send(new DatagramPacket(bufTest.array(), bufTest.limit(), addrLocal, socket.getLocalPort()));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.isInGroup() && (fRebound ? true : Base.getSafeTimeMillis() > this.getSuspectGroupTimestamp())) {
            if (fRebound ^ true) {
                Component._trace("Scheduled senior member heartbeat is overdue; rejoining multicast group.", 9);
            }
            try {
                this.leaveGroup();
            }
            finally {
                Object var3_4 = null;
                this.joinGroup();
            }
        }
    }

    public long getSuspectGroupTimestamp() {
        return this.__m_SuspectGroupTimestamp;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster$PacketListenerBU".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Cluster$PacketListenerBU();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isInGroup() {
        return this.__m_InGroup;
    }

    public boolean isSuspectBinding() {
        return this.__m_SuspectBinding;
    }

    public void joinGroup() {
        block3: {
            MulticastSocket socket = (MulticastSocket)this.getUdpSocket().getDatagramSocket();
            try {
                if (this.isInGroup() ^ true) {
                    this.setInGroup(true);
                    Cluster cluster = (Cluster)this.get_Module();
                    socket.joinGroup(new InetSocketAddress(cluster.getDependencies().getGroupAddress(), cluster.getDependencies().getGroupPort()), null);
                    this.resetSuspectGroupTimestamp();
                }
            }
            catch (IOException e) {
                if (!(socket.isClosed() ^ true)) break block3;
                this.getUdpSocket().onException(e);
            }
        }
    }

    public void leaveGroup() {
        block2: {
            MulticastSocket socket = (MulticastSocket)this.getUdpSocket().getDatagramSocket();
            if (!this.isInGroup()) break block2;
            try {
                this.setInGroup(false);
                Cluster cluster = (Cluster)this.get_Module();
                socket.leaveGroup(new InetSocketAddress(cluster.getDependencies().getGroupAddress(), cluster.getDependencies().getGroupPort()), null);
            }
            catch (IOException e) {
                if (!(socket.isClosed() ^ true)) break block2;
                this.getUdpSocket().onException(e);
            }
        }
    }

    protected void onEnter() {
        super.onEnter();
        DatagramSocket socket = this.getUdpSocket().getDatagramSocket();
        int cbPacket = this.getPacketLength();
        int cMillis = 0;
        try {
            try {
                cMillis = socket.getSoTimeout();
                socket.setSoTimeout(1);
                DatagramPacket p = new DatagramPacket(new byte[cbPacket], cbPacket);
                while (true) {
                    socket.receive(p);
                }
            }
            catch (IOException e) {
                Object var5_7 = null;
                try {
                    socket.setSoTimeout(cMillis);
                }
                catch (IOException e2) {
                    this.onException(e2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                socket.setSoTimeout(cMillis);
            }
            catch (IOException e2) {
                this.onException(e2);
            }
            throw throwable;
        }
        this.setWaitMillis(cMillis);
    }

    protected void onException(Throwable e) {
        Cluster cluster = (Cluster)this.get_Module();
        int nState = cluster.getState();
        if (nState < Cluster.STATE_LEAVING) {
            block3: {
                try {
                    if (!(nState < Cluster.STATE_RUNNING)) break block3;
                    super.onException(e);
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    cluster.onException(e);
                    throw throwable;
                }
            }
            Object var5_4 = null;
            cluster.onException(e);
        }
    }

    protected void onInterval() {
        super.onInterval();
        this.ensureBinding();
    }

    protected void onPacket(SocketAddress addrSource, ByteBuffer bufPacket) {
        Cluster cluster = (Cluster)this.get_Module();
        if (!this.isSuspectBinding() ? false : bufPacket.remaining() >= 4) {
            if (this.isInGroup()) {
                if (!(bufPacket.remaining() == 4) ? false : bufPacket.getInt(bufPacket.position()) == Packet.TYPE_TEST_MULTICAST) {
                    this.setSuspectBinding(false);
                }
            } else {
                this.setSuspectBinding(false);
            }
        }
        cluster.onPacket(this, addrSource, bufPacket);
    }

    public void resetSuspectGroupTimestamp() {
        this.setSuspectGroupTimestamp(Base.getSafeTimeMillis() + Math.max(1000L, (long)(((Cluster)this.get_Module()).getDependencies().getClusterHeartbeatDelayMillis() * 3)));
    }

    protected void setInGroup(boolean fGroup) {
        this.__m_InGroup = fGroup;
    }

    public void setSuspectBinding(boolean fBinding) {
        this.__m_SuspectBinding = fBinding;
    }

    public void setSuspectGroupTimestamp(long fBinding) {
        this.__m_SuspectGroupTimestamp = fBinding;
    }
}

