/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class Lease
extends Net
implements Cloneable {
    public static final int BY_MEMBER = 1;
    public static final int BY_THREAD = 0;
    public static final int LEASE_AVAILABLE = 2;
    public static final int LEASE_DIRTY = 4;
    public static final int LEASE_LOCKED = 3;
    public static final int LEASE_UNISSUED = 1;
    public static final int LEASE_UNKNOWN = 0;
    private int __m_CacheIndex;
    private transient ClassLoader __m_ClassLoader;
    private long __m_EffectiveTime;
    private long __m_ExpirationTime;
    private transient int __m_HolderId;
    private long __m_HolderThreadId;
    private transient int __m_IssuerId;
    private int __m_LeaseVersion;
    private Object __m_ResourceKey;
    private int __m_ResourceSize;
    private int __m_ResourceVersion;
    private transient Grid __m_Service;
    private static transient AtomicLong __s_ThreadIdCounter;
    private static transient ThreadLocal __s_ThreadIdHolder;

    static {
        Lease._initStatic();
    }

    public Lease() {
        this(null, null, true);
    }

    public Lease(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCacheIndex(-1);
            this.setResourceSize(-1);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        try {
            __s_ThreadIdHolder = new ThreadLocal();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void _initStatic$Default() {
        Lease.__initStatic();
    }

    protected static void _initStatic() {
        Lease._initStatic$Default();
        Lease.setThreadIdCounter(new AtomicLong());
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WrapperException(e);
        }
    }

    public int compareTo(Object o) {
        int nVersionThat;
        if (o == this) {
            return 0;
        }
        Lease leaseThis = this;
        Lease leaseThat = (Lease)o;
        int nVersionThis = leaseThis.getLeaseVersion();
        if (nVersionThis == (nVersionThat = leaseThat.getLeaseVersion()) && (nVersionThis = leaseThis.getResourceVersion()) == (nVersionThat = leaseThat.getResourceVersion())) {
            long lTimeThat;
            long lTimeThis = leaseThis.getEffectiveTime();
            return lTimeThis == (lTimeThat = leaseThat.getEffectiveTime()) ? 0 : (lTimeThis > lTimeThat ? 1 : -1);
        }
        if (nVersionThis > nVersionThat) {
            return (nVersionThat == 0 ? true : nVersionThis - nVersionThat < 128) ? 1 : -1;
        }
        return (nVersionThis == 0 ? true : nVersionThat - nVersionThis < 128) ? -1 : 1;
    }

    public synchronized void copyFrom(Lease lease) {
        if (lease != this) {
            Component._assert(Base.equals(this.getResourceKey(), lease.getResourceKey()));
            Component._assert(this.getCacheIndex() == lease.getCacheIndex());
            this.setIssuerId(lease.getIssuerId());
            this.setHolderId(lease.getHolderId());
            this.setHolderThreadId(lease.getHolderThreadId());
            this.setEffectiveTime(lease.getEffectiveTime());
            this.setExpirationTime(lease.getExpirationTime());
            int cbSize = lease.getResourceSize();
            if (cbSize >= 0) {
                this.setResourceSize(cbSize);
            }
            this.copyVersion(lease);
        }
        this.notifyAll();
    }

    public void copyVersion(Lease lease) {
        int nVersion = lease.getLeaseVersion();
        if (nVersion > 0) {
            this.setLeaseVersion(nVersion);
        }
        if ((nVersion = lease.getResourceVersion()) > 0) {
            this.setResourceVersion(nVersion);
        }
    }

    public static String formatCacheName(int iCache, Grid service) {
        NamedCache cache = null;
        if (service instanceof ReplicatedCache) {
            cache = ((ReplicatedCache)service).getCacheHandler(iCache);
        } else if (service instanceof NamedCache) {
            cache = (NamedCache)((Object)service);
        }
        return cache == null ? new StringBuilder(String.valueOf(service.getServiceName())).append("[").append(iCache).append("]").toString() : cache.getCacheName();
    }

    public static String formatStatusName(int nStatus) {
        switch (nStatus) {
            case 0: {
                return "LEASE_UNKNOWN";
            }
            case 1: {
                return "LEASE_UNISSUED";
            }
            case 2: {
                return "LEASE_AVAILABLE";
            }
            case 3: {
                return "LEASE_LOCKED";
            }
            case 4: {
                return "LEASE_DIRTY";
            }
        }
        return "<invalid>";
    }

    public int getCacheIndex() {
        return this.__m_CacheIndex;
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    public static long getCurrentThreadId() {
        ThreadLocal tlo = Lease.getThreadIdHolder();
        Long Id = (Long)tlo.get();
        if (Id == null) {
            long lId = Lease.getThreadIdCounter().incrementAndGet();
            tlo.set(Base.makeLong(lId));
            return lId;
        }
        return Id;
    }

    public long getEffectiveTime() {
        return this.__m_EffectiveTime;
    }

    public long getExpirationTime() {
        return this.__m_ExpirationTime;
    }

    public int getHolderId() {
        return this.__m_HolderId;
    }

    public long getHolderThreadId() {
        return this.__m_HolderThreadId;
    }

    public int getIssuerId() {
        return this.__m_IssuerId;
    }

    public int getLeaseVersion() {
        return this.__m_LeaseVersion;
    }

    public Object getResourceKey() {
        return this.__m_ResourceKey;
    }

    public int getResourceSize() {
        return this.__m_ResourceSize;
    }

    public int getResourceVersion() {
        return this.__m_ResourceVersion;
    }

    public Grid getService() {
        return this.__m_Service;
    }

    public int getStatus() {
        boolean fAvailable;
        Grid service = this.getService();
        ServiceMemberSet setMember = service.getServiceMemberSet();
        int nThisId = service.getThisMember().getId();
        int nHolderId = this.getHolderId();
        boolean bl = nHolderId == 0 ? true : (fAvailable = ((MemberSet)setMember).getMember(nHolderId) == null);
        if (fAvailable ^ true) {
            long lExpirationTime = this.getExpirationTime();
            if (nThisId == nHolderId) {
                lExpirationTime -= (long)10;
            }
            boolean bl2 = fAvailable = lExpirationTime <= service.getClusterTime();
        }
        if (fAvailable) {
            int nIssuerId = this.getIssuerId();
            return (nIssuerId == 0 ? true : ((MemberSet)setMember).getMember(nIssuerId) == null) ? LEASE_UNISSUED : LEASE_AVAILABLE;
        }
        return nHolderId == nThisId ? LEASE_LOCKED : LEASE_DIRTY;
    }

    private static AtomicLong getThreadIdCounter() {
        return __s_ThreadIdCounter;
    }

    private static ThreadLocal getThreadIdHolder() {
        return __s_ThreadIdHolder;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Lease".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Lease();
    }

    private final Component get_Module() {
        return this;
    }

    public synchronized void incrementLeaseVersion() {
        int nVersion = this.getLeaseVersion();
        if (++nVersion > 255) {
            nVersion = 2;
        }
        this.setLeaseVersion(nVersion);
    }

    public synchronized void incrementResourceVersion() {
        int nVersion = this.getResourceVersion();
        if (++nVersion > 255) {
            nVersion = 2;
        }
        this.setResourceVersion(nVersion);
    }

    public static Lease instantiate(int iCache, Object oKey, Grid service) {
        Lease lease = new Lease();
        lease.setCacheIndex(iCache);
        lease.setResourceKey(oKey);
        lease.setService(service);
        return lease;
    }

    public void read(DataInput stream) throws IOException {
        this.setIssuerId(stream.readUnsignedShort());
        this.setHolderId(stream.readUnsignedShort());
        this.setHolderThreadId(ExternalizableHelper.readLong(stream));
        this.setEffectiveTime(ExternalizableHelper.readLong(stream));
        this.setExpirationTime(ExternalizableHelper.readLong(stream));
        int nVersion = stream.readUnsignedShort();
        this.setLeaseVersion(nVersion & 0xFF);
        this.setResourceVersion((nVersion & 0xFF00) >>> 8);
    }

    public void setCacheIndex(int iCache) {
        this.__m_CacheIndex = iCache;
    }

    public void setClassLoader(ClassLoader loader) {
        this.__m_ClassLoader = loader;
    }

    public void setEffectiveTime(long lDatetime) {
        this.__m_EffectiveTime = lDatetime;
    }

    public void setExpirationTime(long lDatetime) {
        this.__m_ExpirationTime = lDatetime;
    }

    public void setHolderId(int nId) {
        this.__m_HolderId = nId;
    }

    public void setHolderThreadId(long lThreadId) {
        this.__m_HolderThreadId = lThreadId;
    }

    public void setIssuerId(int nId) {
        this.__m_IssuerId = nId;
    }

    protected void setLeaseVersion(int nVersion) {
        this.__m_LeaseVersion = nVersion;
    }

    protected void setResourceKey(Object oKey) {
        this.__m_ResourceKey = oKey;
    }

    public void setResourceSize(int cbSize) {
        this.__m_ResourceSize = cbSize;
    }

    protected void setResourceVersion(int nVersion) {
        this.__m_ResourceVersion = nVersion;
    }

    protected void setService(Grid service) {
        this.__m_Service = service;
    }

    private static void setThreadIdCounter(AtomicLong counter) {
        __s_ThreadIdCounter = counter;
    }

    private static void setThreadIdHolder(ThreadLocal tlo) {
        __s_ThreadIdHolder = tlo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Grid service = this.getService();
        int nIssuerId = this.getIssuerId();
        int nHolderId = this.getHolderId();
        long lThreadId = this.getHolderThreadId();
        int cbSize = this.getResourceSize();
        int nStatus = this.getStatus();
        sb.append("Lease: ").append(this.getResourceKey()).append(" (Cache=").append(Lease.formatCacheName(this.getCacheIndex(), service)).append(", Size=").append(cbSize == -1 ? "Unknown" : String.valueOf(cbSize)).append(", Version=").append(this.getLeaseVersion()).append('/').append(this.getResourceVersion()).append(", IssuerId=").append(nIssuerId).append(", HolderId=").append(nHolderId).append(", Status=").append(Lease.formatStatusName(nStatus));
        if (nStatus == LEASE_LOCKED ? true : nStatus == LEASE_DIRTY) {
            if (nHolderId == service.getThisMember().getId()) {
                sb.append(", Held by threadId=").append(lThreadId);
            }
            sb.append(", Locked at ").append(new Date(this.getEffectiveTime())).append(", Expires in ").append(this.getExpirationTime() - service.getClusterTime()).append(" millis");
        } else if (nHolderId == 0) {
            sb.append(", Last locked at ").append(new Date(this.getEffectiveTime()));
        } else {
            sb.append(", Last held by member ").append(nHolderId).append(" from ").append(new Date(this.getEffectiveTime())).append(" to ").append(new Date(this.getExpirationTime()));
        }
        sb.append(')');
        return sb.toString();
    }

    public synchronized void unlock() {
        this.setHolderId(0);
        this.setHolderThreadId(0L);
        this.setExpirationTime(this.getService().getClusterTime());
        this.notifyAll();
    }

    public synchronized void validate() {
        int nIssuerId;
        ServiceMemberSet setMember = this.getService().getServiceMemberSet();
        int nHolderId = this.getHolderId();
        if (!(nHolderId != 0) ? false : ((MemberSet)setMember).getMember(nHolderId) == null) {
            this.unlock();
        }
        if (!(nHolderId != 0) ? false : this.getExpirationTime() <= this.getService().getClusterTime()) {
            this.unlock();
        }
        if (!((nIssuerId = this.getIssuerId()) != 0) ? false : ((MemberSet)setMember).getMember(nIssuerId) == null) {
            this.setIssuerId(0);
            this.notifyAll();
        }
    }

    public void write(DataOutput stream) throws IOException {
        stream.writeShort(this.getIssuerId());
        stream.writeShort(this.getHolderId());
        ExternalizableHelper.writeLong(stream, this.getHolderThreadId());
        ExternalizableHelper.writeLong(stream, this.getEffectiveTime());
        ExternalizableHelper.writeLong(stream, this.getExpirationTime());
        stream.writeShort(this.getLeaseVersion() | this.getResourceVersion() << 8);
    }
}

