/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.connection;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.util.JmsUtil;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;

public class JmsConnection
extends Connection
implements MessageListener {
    private int __m_MessageDeliveryMode;
    private long __m_MessageExpiration;
    private int __m_MessagePriority;
    private Queue __m_QueueIn;
    private Queue __m_QueueOut;
    private QueueReceiver __m_QueueReceiver;
    private QueueSender __m_QueueSender;
    private QueueSession __m_QueueSession;

    public JmsConnection() {
        this(null, null, true);
    }

    public JmsConnection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setChannelArray(new SparseArray());
            this.setChannelPendingArray(new SparseArray());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
        if (super.closeInternal(fNotify, e, cMillis)) {
            JmsUtil.close((MessageConsumer)this.getQueueReceiver());
            JmsUtil.close((MessageProducer)this.getQueueSender());
            JmsUtil.close((Session)this.getQueueSession());
            JmsUtil.delete((Destination)this.getQueueIn());
            return true;
        }
        return false;
    }

    protected String getDescription() {
        return new StringBuilder(String.valueOf(super.getDescription())).append(", In=").append(this.getQueueIn()).append(", Out=").append(this.getQueueOut()).toString();
    }

    public int getMessageDeliveryMode() {
        return this.__m_MessageDeliveryMode;
    }

    public long getMessageExpiration() {
        return this.__m_MessageExpiration;
    }

    public int getMessagePriority() {
        return this.__m_MessagePriority;
    }

    public Queue getQueueIn() {
        return this.__m_QueueIn;
    }

    public Queue getQueueOut() {
        return this.__m_QueueOut;
    }

    public QueueReceiver getQueueReceiver() {
        return this.__m_QueueReceiver;
    }

    public QueueSender getQueueSender() {
        return this.__m_QueueSender;
    }

    public QueueSession getQueueSession() {
        return this.__m_QueueSession;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/connection/JmsConnection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new JmsConnection();
    }

    private final Component get_Module() {
        return this;
    }

    public void onMessage(Message message) {
        Peer manager = (Peer)this.getConnectionManager();
        Component._assert(manager != null);
        if (message instanceof BytesMessage) {
            BytesMessage bMessage = (BytesMessage)message;
            try {
                int cb = JmsUtil.readPackedInt(bMessage);
                manager.enforceMaxIncomingMessageSize(cb);
                if (cb < 0) {
                    throw new JMSException("Received a message with a negative length");
                }
                if (cb == 0) {
                    throw new JMSException("Received a message with a length of zero");
                }
                byte[] ab = new byte[cb];
                int cbRead = bMessage.readBytes(ab);
                if (!(cbRead == cb)) {
                    throw new JMSException(new StringBuilder(String.valueOf("Error reading a message; expected ")).append(cb).append(" bytes, read ").append(cbRead).append(" bytes instead").toString());
                }
                this.setStatsBytesReceived(this.getStatsBytesReceived() + (long)cbRead);
                this.setStatsReceived(this.getStatsReceived() + (long)1);
                manager.receive(new ByteArrayReadBuffer(ab), this);
            }
            catch (JMSException e) {
                this.close(true, e);
            }
            catch (IOException e) {
                this.close(true, e);
            }
        } else {
            this.close(true, new JMSException(new StringBuilder(String.valueOf("Received an unexpected message: ")).append(message).toString()));
        }
    }

    public void openInternal() {
        super.openInternal();
        QueueSession session = this.getQueueSession();
        Component._assert(session != null);
        Queue queueIn = this.getQueueIn();
        Component._assert(queueIn != null);
        Queue queueOut = this.getQueueOut();
        Component._assert(queueOut != null);
        try {
            QueueReceiver receiver = session.createReceiver(queueIn);
            QueueSender sender = session.createSender(queueOut);
            this.setQueueReceiver(receiver);
            this.setQueueSender(sender);
            receiver.setMessageListener((MessageListener)this);
            sender.setDisableMessageID(true);
            sender.setDisableMessageTimestamp(true);
        }
        catch (JMSException e) {
            this.closeInternal(false, e, -1L);
            throw Extend.ensureRuntimeException(e, "error opening connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(WriteBuffer wb) throws ConnectionException {
        QueueSession session;
        int cb = wb.length();
        Peer manager = (Peer)this.getConnectionManager();
        try {
            manager.enforceMaxOutgoingMessageSize(cb);
        }
        catch (IOException e) {
            throw new ConnectionException("error creating a JMS Message", e, this);
        }
        super.send(wb);
        byte[] ab = ((ByteArrayWriteBuffer)wb).getRawByteArray();
        QueueSession queueSession = session = this.getQueueSession();
        synchronized (queueSession) {
            BytesMessage message;
            try {
                message = session.createBytesMessage();
                message.setJMSDeliveryMode(this.getMessageDeliveryMode());
                message.setJMSExpiration(this.getMessageExpiration());
                message.setJMSPriority(this.getMessagePriority());
                message.setJMSReplyTo((Destination)this.getQueueReceiver().getQueue());
                JmsUtil.writePackedInt(message, cb);
                message.writeBytes(ab, 0, cb);
            }
            catch (JMSException e) {
                throw new ConnectionException("error creating a JMS Message", e, this);
            }
            try {
                this.getQueueSender().send((Message)message);
            }
            catch (JMSException e) {
                throw new ConnectionException("error sending a JMS Message", e, this);
            }
        }
    }

    public void setMessageDeliveryMode(int nMode) {
        this.__m_MessageDeliveryMode = nMode;
    }

    public void setMessageExpiration(long cMillis) {
        this.__m_MessageExpiration = cMillis;
    }

    public void setMessagePriority(int nPriority) {
        this.__m_MessagePriority = nPriority;
    }

    public void setQueueIn(Queue queue) {
        Component._assert(this.isOpen() ^ true);
        this.__m_QueueIn = queue;
    }

    public void setQueueOut(Queue queue) {
        Component._assert(this.isOpen() ^ true);
        this.__m_QueueOut = queue;
    }

    public void setQueueReceiver(QueueReceiver receiver) {
        this.__m_QueueReceiver = receiver;
    }

    public void setQueueSender(QueueSender sender) {
        this.__m_QueueSender = sender;
    }

    public void setQueueSession(QueueSession session) {
        Component._assert(this.isOpen() ^ true);
        this.__m_QueueSession = session;
    }
}

