/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Util;
import com.tangosol.net.internal.SocketAddressHelper;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

public abstract class TcpUtil
extends Util {
    public TcpUtil(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static boolean cancel(SelectionKey key) {
        if (key == null) {
            return false;
        }
        key.cancel();
        return true;
    }

    public static boolean close(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public static boolean close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public static boolean close(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public static boolean close(Selector selector) {
        if (selector != null) {
            try {
                selector.close();
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/util/TcpUtil".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public static void setBlockingMode(SelectableChannel channel, boolean fBlocking) {
        try {
            if (channel.isBlocking() ^ fBlocking) {
                channel.configureBlocking(fBlocking);
            }
        }
        catch (Exception e) {
            throw Extend.ensureRuntimeException(e, new StringBuilder(String.valueOf("error configuring blocking mode for: ")).append(channel).toString());
        }
    }

    public static void setKeepAlive(Socket socket, boolean fKeepAlive) throws SocketException {
        if (socket.getKeepAlive() ^ fKeepAlive) {
            socket.setKeepAlive(fKeepAlive);
        }
    }

    public static void setReceiveBufferSize(ServerSocket socket, int cb) throws SocketException {
        if (!(cb > 0) ? false : socket.getReceiveBufferSize() != cb) {
            socket.setReceiveBufferSize(cb);
            TcpUtil.validateBufferSize(socket, cb);
        }
    }

    public static void setReceiveBufferSize(Socket socket, int cb) throws SocketException {
        if (!(cb > 0) ? false : socket.getReceiveBufferSize() != cb) {
            socket.setReceiveBufferSize(cb);
            TcpUtil.validateBufferSize(socket, true, cb);
        }
    }

    public static void setReuseAddress(ServerSocket socket, boolean fReuseAddress) throws SocketException {
        if (!(socket.isBound() ^ true) ? false : socket.getReuseAddress() ^ fReuseAddress) {
            socket.setReuseAddress(fReuseAddress);
        }
    }

    public static void setReuseAddress(Socket socket, boolean fReuseAddress) throws SocketException {
        if (!(socket.isBound() ^ true) ? false : socket.getReuseAddress() ^ fReuseAddress) {
            socket.setReuseAddress(fReuseAddress);
        }
    }

    public static void setSendBufferSize(Socket socket, int cb) throws SocketException {
        if (!(cb > 0) ? false : socket.getSendBufferSize() != cb) {
            socket.setSendBufferSize(cb);
            TcpUtil.validateBufferSize(socket, false, cb);
        }
    }

    public static void setSoLinger(Socket socket, int cSecs) throws SocketException {
        if ((cSecs = Math.max(cSecs, -1)) == 0) {
            return;
        }
        if (socket.getSoLinger() != cSecs) {
            if (cSecs > 0) {
                socket.setSoLinger(true, cSecs);
            } else {
                socket.setSoLinger(false, 0);
            }
            if (socket.getSoLinger() != cSecs) {
                if (cSecs > 0) {
                    Component._trace(new StringBuilder(String.valueOf("Failed to set a TCP Socket linger time to ")).append(cSecs).append(" seconds; actual value is ").append(socket.getSoLinger()).append(" seconds").toString(), 2);
                } else {
                    Component._trace("Failed to disabled a TCP Socket linger time");
                }
            }
        }
    }

    public static void setTcpNoDelay(Socket socket, boolean fTcpNoDelay) throws SocketException {
        if (socket.getTcpNoDelay() ^ fTcpNoDelay) {
            socket.setTcpNoDelay(fTcpNoDelay);
        }
    }

    public static String toString(SocketAddress addr) {
        return SocketAddressHelper.toString(addr);
    }

    protected static void validateBufferSize(ServerSocket socket, int cbRequested) throws SocketException {
        TcpUtil.validateBufferSize(true, socket.getReceiveBufferSize(), cbRequested);
    }

    protected static void validateBufferSize(Socket socket, boolean fReceiveBuffer, int cbRequested) throws SocketException {
        int cbActual = fReceiveBuffer ? socket.getReceiveBufferSize() : socket.getSendBufferSize();
        TcpUtil.validateBufferSize(fReceiveBuffer, cbActual, cbRequested);
    }

    protected static void validateBufferSize(boolean fReceiveBuffer, int cbActual, int cbRequested) throws SocketException {
        String sName = fReceiveBuffer ? "receive" : "send";
        if (cbActual < cbRequested) {
            Component._trace(new StringBuilder(String.valueOf("Failed to set a TCP Socket ")).append(sName).append(" buffer size to ").append(cbRequested).append(" bytes; actual size is ").append(cbActual).append(" bytes. ").append("Consult your OS documentation regarding increasing the maximum ").append("TCP Socket ").append(sName).append(" buffer size. Proceeding with the ").append("actual value may cause sub-optimal performance.").toString(), 2);
        }
    }
}

