/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.internal.net.service.grid.PersistenceDependencies;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableQuorumPolicy;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Service;
import com.tangosol.net.events.internal.ServiceDispatcher;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.persistence.PersistenceEnvironmentInfo;
import com.tangosol.persistence.SafePersistenceWrappers;
import com.tangosol.persistence.SnapshotArchiver;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServiceModel
extends LocalModel {
    public static final int THREAD_COUNT_LIMIT = 512;
    private transient long __m_RequestTimeoutMillis;
    private transient long __m_TaskHungThresholdMillis;
    private transient long __m_TaskTimeoutMillis;
    private int __m_ThreadCount;
    private transient int __m_ThreadCountMax;
    private transient int __m_ThreadCountMin;
    private transient Service __m__Service;
    private transient WeakReference __m__ServiceImplRef;
    private String __m__ServiceName;
    private transient WeakReference __m__ServiceRef;

    public ServiceModel() {
        this(null, null, true);
    }

    public ServiceModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getBackupCount() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof PartitionedService) {
            return ((PartitionedService)serviceImpl).getBackupCount();
        }
        if (serviceImpl instanceof CacheService) {
            return serviceImpl.getServiceMemberSet().size() - 1;
        }
        return -1;
    }

    public int getBackupCountAfterWritebehind() {
        PartitionedCache serviceDist = this.getPartitionedCache();
        return serviceDist == null ? -1 : serviceDist.getBackupCountOpt();
    }

    public String getDescription() {
        SafeService serviceSafe = (SafeService)this.get_Service();
        return serviceSafe == null ? Model.canonicalString(null) : serviceSafe.getServiceName();
    }

    public int getEventBacklog() {
        Grid service = this.get_ServiceImpl();
        Service$EventDispatcher dispatcher = service == null ? null : service.getEventDispatcher();
        return dispatcher == null ? -1 : dispatcher.getQueue().size();
    }

    public long getEventCount() {
        Grid service = this.get_ServiceImpl();
        Service$EventDispatcher dispatcher = service == null ? null : service.getEventDispatcher();
        return dispatcher == null ? -1L : dispatcher.getEventCount();
    }

    public String[] getEventInterceptorInfo() {
        PartitionedCache serviceDist = this.getPartitionedCache();
        ServiceDispatcher dispatcher = serviceDist == null ? null : serviceDist.getEventsHelper().getServiceDispatcher();
        return dispatcher == null ? new String[]{} : dispatcher.getStats().toStringArray();
    }

    public Date getJoinTime() {
        Grid serviceImpl = this.get_ServiceImpl();
        return serviceImpl != null ? new Date(serviceImpl.getServiceMemberSet().getServiceJoinTime(serviceImpl.getThisMember().getId())) : new Date(0);
    }

    public int getMemberCount() {
        Grid svc = this.get_ServiceImpl();
        return svc == null ? -1 : svc.getServiceMemberSet().size();
    }

    public long getMessagesLocal() {
        Grid svc = this.get_ServiceImpl();
        return svc == null ? -1L : svc.getStatsSentLocal();
    }

    public long getMessagesReceived() {
        Grid svc = this.get_ServiceImpl();
        return svc == null ? -1L : svc.getStatsReceived();
    }

    public long getMessagesSent() {
        Grid svc = this.get_ServiceImpl();
        return svc == null ? -1L : svc.getStatsSent();
    }

    public int getOutgoingTransferCount() {
        PartitionedCache serviceDist = this.getPartitionedCache();
        return (serviceDist == null ? true : serviceDist.isOwnershipEnabled() ^ true) ? -1 : serviceDist.getTransferControl().getTransferCount();
    }

    public int getOwnedPartitionsBackup() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof CacheService) {
            if (serviceImpl instanceof PartitionedService) {
                PartitionedService serviceDist = (PartitionedService)serviceImpl;
                if (serviceDist.isOwnershipEnabled()) {
                    return serviceDist.calculateThisOwnership(false);
                }
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public int getOwnedPartitionsPrimary() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof CacheService) {
            if (serviceImpl instanceof PartitionedService) {
                PartitionedService serviceDist = (PartitionedService)serviceImpl;
                if (serviceDist.isOwnershipEnabled()) {
                    return serviceDist.calculateThisOwnership(true);
                }
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public PartitionedCache getPartitionedCache() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof PartitionedCache) {
            return (PartitionedCache)serviceImpl;
        }
        return null;
    }

    public int getPartitionsAll() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof PartitionedService) {
            return ((PartitionedService)serviceImpl).getPartitionCount();
        }
        return serviceImpl instanceof CacheService ? 1 : -1;
    }

    public int getPartitionsEndangered() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof CacheService) {
            if (serviceImpl instanceof PartitionedService) {
                PartitionedService serviceDist = (PartitionedService)serviceImpl;
                return serviceDist.getBackupCount() == 0 ? -1 : serviceDist.calculateEndangered();
            }
            return serviceImpl.getServiceMemberSet().size() > 1 ? 0 : 1;
        }
        return -1;
    }

    public int getPartitionsUnbalanced() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof CacheService) {
            if (serviceImpl instanceof PartitionedService) {
                PartitionedService serviceDist = (PartitionedService)serviceImpl;
                return serviceDist.calculateUnbalanced();
            }
            return 0;
        }
        return -1;
    }

    public int getPartitionsVulnerable() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof CacheService) {
            if (serviceImpl instanceof PartitionedService) {
                PartitionedService serviceDist = (PartitionedService)serviceImpl;
                return serviceDist.getBackupCount() == 0 ? -1 : serviceDist.calculateVulnerable();
            }
            return serviceImpl.getServiceMemberSet().getDistantMembers(serviceImpl.getThisMember()).size() > 0 ? 0 : 1;
        }
        return -1;
    }

    public long getPersistenceActiveSpaceAvailable() {
        PersistenceEnvironmentInfo envInfo = this.getPersistenceEnvironmentInfo();
        if (envInfo != null) {
            File fileDir = envInfo.getPersistenceActiveDirectory();
            return fileDir == null ? -1L : fileDir.getUsableSpace();
        }
        return -1L;
    }

    public long getPersistenceActiveSpaceTotal() {
        PersistenceEnvironmentInfo envInfo = this.getPersistenceEnvironmentInfo();
        if (envInfo != null) {
            File fileDir = envInfo.getPersistenceActiveDirectory();
            return fileDir == null ? -1L : fileDir.getTotalSpace();
        }
        return -1L;
    }

    public long getPersistenceActiveSpaceUsed() {
        PersistenceEnvironmentInfo envInfo = this.getPersistenceEnvironmentInfo();
        if (!(envInfo != null) ? false : envInfo.getPersistenceActiveDirectory() != null) {
            return envInfo.getPersistenceActiveSpaceUsed();
        }
        return -1L;
    }

    protected PartitionedService$PersistenceControl getPersistenceControl() {
        PartitionedCache serviceDist = this.getPartitionedCache();
        return serviceDist == null ? null : serviceDist.getPersistenceControl();
    }

    protected PersistenceEnvironment getPersistenceEnv() {
        PartitionedService$PersistenceControl ctrl = this.getPersistenceControl();
        return ctrl == null ? null : ctrl.getPersistenceEnvironment();
    }

    public String getPersistenceEnvironment() {
        PersistenceEnvironment env = this.getPersistenceEnv();
        return env == null ? Model.canonicalString(null) : env.toString();
    }

    protected PersistenceEnvironmentInfo getPersistenceEnvironmentInfo() {
        PersistenceEnvironment env = SafePersistenceWrappers.unwrap(this.getPersistenceEnv());
        return env instanceof PersistenceEnvironmentInfo ? (PersistenceEnvironmentInfo)((Object)env) : null;
    }

    public float getPersistenceLatencyAverage() {
        PartitionedService$PersistenceControl ctrl = this.getPersistenceControl();
        if (ctrl != null) {
            long cStatsLatency = ctrl.getStatsLatencyCount();
            return cStatsLatency == (long)0 ? 0.0f : (float)ctrl.getStatsLatencyTotal() / (float)cStatsLatency;
        }
        return -1.0f;
    }

    public long getPersistenceLatencyMax() {
        PartitionedService$PersistenceControl ctrl = this.getPersistenceControl();
        return ctrl == null ? -1L : ctrl.getStatsLatencyMax();
    }

    public String getPersistenceMode() {
        PartitionedService$PersistenceControl ctrl = this.getPersistenceControl();
        PartitionedCache serviceDist = this.getPartitionedCache();
        PersistenceDependencies depsPersist = serviceDist == null ? null : serviceDist.getPersistenceDependencies();
        String sMode = depsPersist == null ? "n/a" : depsPersist.getPersistenceMode();
        return (!(ctrl != null) ? false : ctrl.isDisabled()) ? "disabled" : sMode;
    }

    public String getPersistenceSnapshotArchiver() {
        PartitionedService$PersistenceControl ctrl = this.getPersistenceControl();
        if (ctrl == null) {
            return Model.canonicalString(null);
        }
        SnapshotArchiver archiver = ctrl.getSnapshotArchiver();
        return archiver == null ? Model.canonicalString(null) : archiver.toString();
    }

    public long getPersistenceSnapshotSpaceAvailable() {
        PersistenceEnvironmentInfo envInfo = this.getPersistenceEnvironmentInfo();
        if (envInfo != null) {
            File fileDir = envInfo.getPersistenceSnapshotDirectory();
            return fileDir == null ? -1L : fileDir.getUsableSpace();
        }
        return -1L;
    }

    public long getPersistenceSnapshotSpaceTotal() {
        PersistenceEnvironmentInfo envInfo = this.getPersistenceEnvironmentInfo();
        if (envInfo != null) {
            File fileDir = envInfo.getPersistenceSnapshotDirectory();
            return fileDir == null ? -1L : fileDir.getTotalSpace();
        }
        return -1L;
    }

    public String getQuorumStatus() {
        Grid serviceImpl = this.get_ServiceImpl();
        ActionPolicy policy = serviceImpl == null ? null : serviceImpl.getActionPolicy();
        String sQuorum = null;
        if (!(serviceImpl != null) ? false : serviceImpl.isSuspended()) {
            sQuorum = "Suspended";
        } else if (policy instanceof NullImplementation.NullActionPolicy) {
            sQuorum = "Not configured";
        } else if (policy instanceof ConfigurableQuorumPolicy) {
            sQuorum = ((ConfigurableQuorumPolicy)policy).getStatusDescription();
        } else if (policy != null) {
            sQuorum = policy.toString();
        }
        return Model.canonicalString(sQuorum);
    }

    public float getRequestAverageDuration() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            long cMillisTotal = serviceImpl.getStatsPollDuration();
            long cRequests = serviceImpl.getStatsPollCount();
            return cRequests == 0L ? 0.0f : (float)((double)cMillisTotal / (double)cRequests);
        }
        return -1.0f;
    }

    public long getRequestMaxDuration() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            return serviceImpl.getStatsPollMaxDuration();
        }
        return -1L;
    }

    public long getRequestPendingCount() {
        Grid$PollArray waPoll;
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null && (waPoll = serviceImpl.getPollArray()) != null) {
            long cPolls = 0;
            try {
                long i = ((WindowedArray)waPoll).getFirstIndex();
                long j = ((WindowedArray)waPoll).getLastIndex();
                while (i <= j) {
                    if (((WindowedArray)waPoll).get(i) != null) {
                        ++cPolls;
                    }
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            return cPolls;
        }
        return -1L;
    }

    public long getRequestPendingDuration() {
        Grid$PollArray waPoll;
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null && (waPoll = serviceImpl.getPollArray()) != null) {
            long cTimeMillis = Base.getSafeTimeMillis();
            long cMaxMillis = 0L;
            try {
                long i = ((WindowedArray)waPoll).getFirstIndex();
                long j = ((WindowedArray)waPoll).getLastIndex();
                while (i <= j) {
                    long cMillis;
                    Poll poll = (Poll)((WindowedArray)waPoll).get(i);
                    if (poll != null && (cMillis = cTimeMillis - poll.getInitTimeMillis()) > cMaxMillis) {
                        cMaxMillis = cMillis;
                    }
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            return cMaxMillis;
        }
        return -1L;
    }

    public long getRequestTimeoutCount() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            return serviceImpl.getStatsTimeoutCount();
        }
        return -1L;
    }

    public long getRequestTimeoutMillis() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            return serviceImpl.getRequestTimeout();
        }
        return -1L;
    }

    public long getRequestTotalCount() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            return serviceImpl.getStatsPollCount();
        }
        return -1L;
    }

    public int getSeniorMemberId() {
        try {
            return this.isRunning() ? this.get_ServiceImpl().getServiceMemberSet().getOldestMember().getId() : -1;
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    public String getStatistics() {
        Grid serviceImpl = this.get_ServiceImpl();
        return serviceImpl == null ? Model.canonicalString(null) : serviceImpl.formatStats();
    }

    public String getStatusHA() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof CacheService) {
            if (serviceImpl instanceof PartitionedService) {
                return Model.canonicalString(((PartitionedService)serviceImpl).getBackupStrengthName());
            }
            int nEndangered = this.getPartitionsEndangered();
            if (nEndangered == -1) {
                return Model.canonicalString(null);
            }
            if (nEndangered > 0) {
                return "ENDANGERED";
            }
            return this.getPartitionsVulnerable() == 0 ? "MACHINE-SAFE" : "NODE-SAFE";
        }
        return Model.canonicalString(null);
    }

    public int getStorageEnabledCount() {
        if (this.isRunning()) {
            Service service = this.get_Service();
            if (service instanceof DistributedCacheService) {
                return ((DistributedCacheService)service).getStorageEnabledMembers().size();
            }
            if (service instanceof CacheService) {
                return service.getInfo().getServiceMembers().size();
            }
        }
        return -1;
    }

    public float getTaskAverageDuration() {
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            long cPoolTotal = pool.getStatsActiveMillis();
            long cTasks = pool.getStatsTaskCount();
            return cTasks == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTasks);
        }
        return -1.0f;
    }

    public int getTaskBacklog() {
        Grid serviceImpl;
        int cTask = 0;
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            cTask += pool.getBacklog();
        }
        if ((serviceImpl = this.get_ServiceImpl()) != null) {
            cTask += serviceImpl.getQueue().size();
        }
        return cTask;
    }

    public long getTaskCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsTaskCount() : (long)-1;
    }

    public int getTaskHungCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsHungCount() : -1;
    }

    public long getTaskHungDuration() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsHungDuration() : -1L;
    }

    public String getTaskHungTaskId() {
        DaemonPool pool = this.get_DaemonPool();
        return Model.canonicalString((!(pool != null) ? false : pool.isStarted()) ? pool.getStatsHungTaskId() : null);
    }

    public long getTaskHungThresholdMillis() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getHungThreshold() : -1L;
    }

    public int getTaskMaxBacklog() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsMaxBacklog() : -1;
    }

    public int getTaskTimeoutCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsTimeoutCount() : 0;
    }

    public long getTaskTimeoutMillis() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getTaskTimeout() : 0L;
    }

    public int getThreadAbandonedCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsAbandonedCount() : 0;
    }

    public float getThreadAverageActiveCount() {
        DaemonPool pool;
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null && (pool = this.get_DaemonPool()).isStarted()) {
            long cTotal = Base.getSafeTimeMillis() - serviceImpl.getStatsReset();
            long cPoolTotal = pool.getStatsActiveMillis();
            return cTotal == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTotal);
        }
        return -1.0f;
    }

    public int getThreadCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getDaemonCount() : 0;
    }

    public int getThreadCountMax() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isDynamic()) ? pool.getDaemonCountMax() : -1;
    }

    public int getThreadCountMin() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isDynamic()) ? pool.getDaemonCountMin() : -1;
    }

    public Date getThreadCountUpdateTime() {
        DaemonPool pool = this.get_DaemonPool();
        long ldt = pool == null ? 0L : pool.getStatsLastResizeMillis();
        return new Date(ldt);
    }

    public int getThreadIdleCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getDaemonCount() - pool.getActiveDaemonCount() : -1;
    }

    public String getTransportAddress() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? Model.canonicalString(null) : handler.getMessageBus().getLocalEndPoint().getCanonicalName();
    }

    public String[] getTransportBackloggedConnectionList() {
        ArrayList<String> listBacklog = new ArrayList<String>();
        Grid service = this.get_ServiceImpl();
        MessageHandler handler = this.get_MessageHandler();
        if (!(service != null) ? false : handler != null) {
            if (handler.isLocalBacklog()) {
                listBacklog.add(service.getThisMember().toString());
            }
            boolean fGlobal = handler.isGlobalBacklog();
            ServiceMemberSet setMembers = service.getServiceMemberSet();
            Iterator iter = setMembers.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                int nId = member.getId();
                if (!((!fGlobal ? false : setMembers.getServiceEndPoint(nId) != null) ? true : setMembers.isServiceBacklogged(nId))) continue;
                listBacklog.add(member.toString());
            }
        }
        return listBacklog.toArray(new String[listBacklog.size()]);
    }

    public int getTransportBackloggedConnections() {
        MessageHandler handler = this.get_MessageHandler();
        if (handler == null) {
            return -1;
        }
        if (handler.isGlobalBacklog()) {
            return this.getTransportConnections();
        }
        int cBacklog = 0;
        if (handler.isLocalBacklog()) {
            ++cBacklog;
        }
        ServiceMemberSet setMembers = this.get_ServiceImpl().getServiceMemberSet();
        int[] anMember = setMembers.toIdArray();
        int i = 0;
        int c = anMember.length;
        while (i < c) {
            if (setMembers.isServiceBacklogged(anMember[i])) {
                ++cBacklog;
            }
            ++i;
        }
        return cBacklog;
    }

    public int getTransportConnections() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1 : handler.getConnectionMap().size();
    }

    public long getTransportReceivedBytes() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusBytesIn();
    }

    public long getTransportReceivedMessages() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusReceives();
    }

    public long getTransportRetainedBytes() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusBytesOutBuffered().get();
    }

    public long getTransportSentBytes() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusBytesOut();
    }

    public long getTransportSentMessages() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusSends();
    }

    public String getTransportStatus() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? Model.canonicalString(null) : handler.getMessageBus().toString();
    }

    public String getType() {
        String sType = null;
        try {
            sType = this.get_ServiceImpl().getInfo().getServiceType();
        }
        catch (Exception exception) {}
        return Model.canonicalString(sType);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/ServiceModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected DaemonPool get_DaemonPool() {
        com.tangosol.coherence.component.util.daemon.queueProcessor.Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof ProxyService) {
            ConnectionAcceptor acceptor = ((ProxyService)serviceImpl).getAcceptor();
            serviceImpl = acceptor instanceof com.tangosol.coherence.component.util.daemon.queueProcessor.Service ? (com.tangosol.coherence.component.util.daemon.queueProcessor.Service)((Object)acceptor) : null;
        }
        return serviceImpl == null ? null : serviceImpl.getDaemonPool();
    }

    public static Component get_Instance() {
        return new ServiceModel();
    }

    protected MessageHandler get_MessageHandler() {
        Grid svc = this.get_ServiceImpl();
        return svc == null ? null : svc.getMessageHandler();
    }

    private final Component get_Module() {
        return this;
    }

    public Service get_Service() {
        WeakReference wr = this.get_ServiceRef();
        return wr == null ? null : (Service)wr.get();
    }

    protected Grid get_ServiceImpl() {
        WeakReference wr = this.get_ServiceImplRef();
        return (!(wr != null) ? false : this.isRunning()) ? (Grid)wr.get() : null;
    }

    protected WeakReference get_ServiceImplRef() {
        return this.__m__ServiceImplRef;
    }

    public String get_ServiceName() {
        return this.__m__ServiceName;
    }

    protected WeakReference get_ServiceRef() {
        return this.__m__ServiceRef;
    }

    public boolean isRunning() {
        Service service = this.get_Service();
        return !(service != null) ? false : service.isRunning();
    }

    public boolean isStorageEnabled() {
        Service service = this.get_Service();
        return !this.isRunning() ? false : (service instanceof DistributedCacheService ? ((DistributedCacheService)service).isLocalStorageEnabled() : service instanceof CacheService);
    }

    public boolean isThreadPoolSizingEnabled() {
        DaemonPool pool = this.get_DaemonPool();
        return !(pool != null) ? false : pool.isDynamic();
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("BackupCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("BackupCountAfterWritebehind", ExternalizableHelper.readInt(in));
        mapSnapshot.put("EventBacklog", ExternalizableHelper.readInt(in));
        mapSnapshot.put("EventCount", ExternalizableHelper.readLong(in));
        mapSnapshot.put("EventInterceptorInfo", ExternalizableHelper.readStringArray(in));
        mapSnapshot.put("JoinTime", new Date(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("MemberCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("MessagesLocal", ExternalizableHelper.readLong(in));
        mapSnapshot.put("MessagesReceived", ExternalizableHelper.readLong(in));
        mapSnapshot.put("MessagesSent", ExternalizableHelper.readLong(in));
        mapSnapshot.put("OutgoingTransferCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("OwnedPartitionsBackup", ExternalizableHelper.readInt(in));
        mapSnapshot.put("OwnedPartitionsPrimary", ExternalizableHelper.readInt(in));
        mapSnapshot.put("PartitionsAll", ExternalizableHelper.readInt(in));
        mapSnapshot.put("PartitionsEndangered", ExternalizableHelper.readInt(in));
        mapSnapshot.put("PartitionsUnbalanced", ExternalizableHelper.readInt(in));
        mapSnapshot.put("PartitionsVulnerable", ExternalizableHelper.readInt(in));
        mapSnapshot.put("QuorumStatus", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("RequestAverageDuration", new Float(in.readFloat()));
        mapSnapshot.put("RequestMaxDuration", ExternalizableHelper.readLong(in));
        mapSnapshot.put("RequestPendingCount", ExternalizableHelper.readLong(in));
        mapSnapshot.put("RequestPendingDuration", ExternalizableHelper.readLong(in));
        mapSnapshot.put("RequestTimeoutCount", ExternalizableHelper.readLong(in));
        mapSnapshot.put("RequestTimeoutMillis", ExternalizableHelper.readLong(in));
        mapSnapshot.put("RequestTotalCount", ExternalizableHelper.readLong(in));
        mapSnapshot.put("Running", in.readBoolean() ? Boolean.TRUE : Boolean.FALSE);
        mapSnapshot.put("SeniorMemberId", ExternalizableHelper.readInt(in));
        mapSnapshot.put("Statistics", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("StatusHA", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("StorageEnabled", in.readBoolean() ? Boolean.TRUE : Boolean.FALSE);
        mapSnapshot.put("StorageEnabledCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("TaskAverageDuration", new Float(in.readFloat()));
        mapSnapshot.put("TaskBacklog", ExternalizableHelper.readInt(in));
        mapSnapshot.put("TaskCount", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TaskHungCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("TaskHungDuration", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TaskHungTaskId", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("TaskHungThresholdMillis", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TaskMaxBacklog", ExternalizableHelper.readInt(in));
        mapSnapshot.put("TaskTimeoutCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("TaskTimeoutMillis", ExternalizableHelper.readLong(in));
        mapSnapshot.put("ThreadAbandonedCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("ThreadAverageActiveCount", new Float(in.readFloat()));
        mapSnapshot.put("ThreadCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("ThreadCountMax", ExternalizableHelper.readInt(in));
        mapSnapshot.put("ThreadCountMin", ExternalizableHelper.readInt(in));
        mapSnapshot.put("ThreadCountUpdateTime", new Date(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("ThreadIdleCount", ExternalizableHelper.readInt(in));
        mapSnapshot.put("ThreadPoolSizingEnabled", in.readBoolean() ? Boolean.TRUE : Boolean.FALSE);
        mapSnapshot.put("TransportAddress", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("TransportBackloggedConnectionList", (String[])ExternalizableHelper.readObject(in));
        mapSnapshot.put("TransportBackloggedConnections", ExternalizableHelper.readInt(in));
        mapSnapshot.put("TransportConnections", ExternalizableHelper.readInt(in));
        mapSnapshot.put("TransportReceivedBytes", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TransportReceivedMessages", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TransportRetainedBytes", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TransportSentBytes", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TransportSentMessages", ExternalizableHelper.readLong(in));
        mapSnapshot.put("TransportStatus", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("Type", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("PersistenceEnvironment", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("PersistenceLatencyAverage", new Float(in.readFloat()));
        mapSnapshot.put("PersistenceLatencyMax", ExternalizableHelper.readLong(in));
        mapSnapshot.put("PersistenceMode", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("PersistenceActiveSpaceAvailable", ExternalizableHelper.readLong(in));
        mapSnapshot.put("PersistenceSnapshotSpaceAvailable", ExternalizableHelper.readLong(in));
        mapSnapshot.put("PersistenceActiveSpaceTotal", ExternalizableHelper.readLong(in));
        mapSnapshot.put("PersistenceSnapshotSpaceTotal", ExternalizableHelper.readLong(in));
        mapSnapshot.put("PersistenceActiveSpaceUsed", ExternalizableHelper.readLong(in));
        mapSnapshot.put("PersistenceSnapshotArchiver", ExternalizableHelper.readSafeUTF(in));
    }

    public String reportDistributionState(boolean fVerbose) {
        PartitionedCache serviceDist = this.getPartitionedCache();
        return (serviceDist == null ? true : serviceDist.isOwnershipEnabled() ^ true) ? Model.canonicalString(null) : serviceDist.getDistributionStrategy().reportLocalDistributionState(fVerbose);
    }

    public String reportOwnership(boolean fVerbose) {
        PartitionedCache serviceDist = this.getPartitionedCache();
        return serviceDist == null ? Model.canonicalString(null) : Base.replace(serviceDist.reportOwnership(fVerbose), "\n", "<br/>");
    }

    public void resetStatistics() {
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            serviceImpl.resetStats();
        }
    }

    public void setRequestTimeoutMillis(long cMillis) {
        this.checkReadOnly("setRequestTimeoutMillis");
        Grid serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            serviceImpl.setRequestTimeout(Math.max(0L, cMillis));
        }
    }

    public void setTaskHungThresholdMillis(long cMillis) {
        this.checkReadOnly("setTaskHungThresholdMillis");
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            this.checkReadOnly("setTaskHungThresholdMillis");
            pool.setHungThreshold(cMillis);
        } else if (cMillis > (long)0) {
            throw new IllegalArgumentException("ThreadPool is not configured");
        }
    }

    public void setTaskTimeoutMillis(long cMillis) {
        this.checkReadOnly("setTaskTimeoutMillis");
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            this.checkReadOnly("setTaskTimeoutMillis");
            pool.setTaskTimeout(cMillis);
        } else if (cMillis > (long)0) {
            throw new IllegalArgumentException("ThreadPool is not configured");
        }
    }

    public void setThreadCount(int cThreads) {
        this.checkReadOnly("setThreadCount");
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            this.checkRange("setThreadCount", cThreads, 1, Integer.MAX_VALUE);
            pool.setDaemonCount(cThreads);
        } else if (cThreads > 0) {
            throw new IllegalArgumentException("ThreadPool cannot be started dynamically");
        }
    }

    public void setThreadCountMax(int nMax) {
        this.checkReadOnly("setThreadCountMax");
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isDynamic()) {
            this.checkRange("setThreadCountMax", nMax, this.getThreadCountMin() + 1, Integer.MAX_VALUE);
            pool.setDaemonCountMax(nMax);
        } else if (nMax > 0) {
            throw new IllegalArgumentException("Dynamic thread pool sizing is not available or enabled");
        }
    }

    public void setThreadCountMin(int nMin) {
        this.checkReadOnly("setThreadCountMin");
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isDynamic()) {
            this.checkRange("setThreadCountMin", nMin, 1, this.getThreadCountMax() - 1);
            pool.setDaemonCountMin(nMin);
        } else if (nMin > 0) {
            throw new IllegalArgumentException("Dynamic thread pool sizing is not available or enabled");
        }
    }

    public void set_Service(Service service) {
        Service impl;
        this.set_ServiceRef(new WeakReference<Service>(service));
        this.set_ServiceName(service.getInfo().getServiceName());
        if (service instanceof SafeService && (impl = ((SafeService)service).getService()) instanceof Grid) {
            this.set_ServiceImplRef(new WeakReference<Service>(impl));
        }
    }

    protected void set_ServiceImplRef(WeakReference refServiceImpl) {
        this.__m__ServiceImplRef = refServiceImpl;
    }

    public void set_ServiceName(String sName) {
        this.__m__ServiceName = sName;
    }

    protected void set_ServiceRef(WeakReference refService) {
        this.__m__ServiceRef = refService;
    }

    public void shutdown() {
        this.checkReadOnly("shutdown");
        Service service = this.get_Service();
        if (service != null) {
            service.shutdown();
        }
    }

    public void start() {
        this.checkReadOnly("start");
        CacheFactory.getConfigurableCacheFactory().ensureService(this.get_ServiceName());
    }

    public void stop() {
        this.checkReadOnly("stop");
        Service service = this.get_Service();
        if (service != null) {
            service.stop();
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeInt(out, this.getBackupCount());
        ExternalizableHelper.writeInt(out, this.getBackupCountAfterWritebehind());
        ExternalizableHelper.writeInt(out, this.getEventBacklog());
        ExternalizableHelper.writeLong(out, this.getEventCount());
        ExternalizableHelper.writeStringArray(out, this.getEventInterceptorInfo());
        ExternalizableHelper.writeLong(out, this.getJoinTime().getTime());
        ExternalizableHelper.writeInt(out, this.getMemberCount());
        ExternalizableHelper.writeLong(out, this.getMessagesLocal());
        ExternalizableHelper.writeLong(out, this.getMessagesReceived());
        ExternalizableHelper.writeLong(out, this.getMessagesSent());
        ExternalizableHelper.writeInt(out, this.getOutgoingTransferCount());
        ExternalizableHelper.writeInt(out, this.getOwnedPartitionsBackup());
        ExternalizableHelper.writeInt(out, this.getOwnedPartitionsPrimary());
        ExternalizableHelper.writeInt(out, this.getPartitionsAll());
        ExternalizableHelper.writeInt(out, this.getPartitionsEndangered());
        ExternalizableHelper.writeInt(out, this.getPartitionsUnbalanced());
        ExternalizableHelper.writeInt(out, this.getPartitionsVulnerable());
        ExternalizableHelper.writeSafeUTF(out, this.getQuorumStatus());
        out.writeFloat(this.getRequestAverageDuration());
        ExternalizableHelper.writeLong(out, this.getRequestMaxDuration());
        ExternalizableHelper.writeLong(out, this.getRequestPendingCount());
        ExternalizableHelper.writeLong(out, this.getRequestPendingDuration());
        ExternalizableHelper.writeLong(out, this.getRequestTimeoutCount());
        ExternalizableHelper.writeLong(out, this.getRequestTimeoutMillis());
        ExternalizableHelper.writeLong(out, this.getRequestTotalCount());
        out.writeBoolean(this.isRunning());
        ExternalizableHelper.writeInt(out, this.getSeniorMemberId());
        ExternalizableHelper.writeSafeUTF(out, this.getStatistics());
        ExternalizableHelper.writeSafeUTF(out, this.getStatusHA());
        out.writeBoolean(this.isStorageEnabled());
        ExternalizableHelper.writeInt(out, this.getStorageEnabledCount());
        out.writeFloat(this.getTaskAverageDuration());
        ExternalizableHelper.writeInt(out, this.getTaskBacklog());
        ExternalizableHelper.writeLong(out, this.getTaskCount());
        ExternalizableHelper.writeInt(out, this.getTaskHungCount());
        ExternalizableHelper.writeLong(out, this.getTaskHungDuration());
        ExternalizableHelper.writeSafeUTF(out, this.getTaskHungTaskId());
        ExternalizableHelper.writeLong(out, this.getTaskHungThresholdMillis());
        ExternalizableHelper.writeInt(out, this.getTaskMaxBacklog());
        ExternalizableHelper.writeInt(out, this.getTaskTimeoutCount());
        ExternalizableHelper.writeLong(out, this.getTaskTimeoutMillis());
        ExternalizableHelper.writeInt(out, this.getThreadAbandonedCount());
        out.writeFloat(this.getThreadAverageActiveCount());
        ExternalizableHelper.writeInt(out, this.getThreadCount());
        ExternalizableHelper.writeInt(out, this.getThreadCountMax());
        ExternalizableHelper.writeInt(out, this.getThreadCountMin());
        ExternalizableHelper.writeLong(out, this.getThreadCountUpdateTime().getTime());
        ExternalizableHelper.writeInt(out, this.getThreadIdleCount());
        out.writeBoolean(this.isThreadPoolSizingEnabled());
        ExternalizableHelper.writeSafeUTF(out, this.getTransportAddress());
        ExternalizableHelper.writeObject(out, this.getTransportBackloggedConnectionList());
        ExternalizableHelper.writeInt(out, this.getTransportBackloggedConnections());
        ExternalizableHelper.writeInt(out, this.getTransportConnections());
        ExternalizableHelper.writeLong(out, this.getTransportReceivedBytes());
        ExternalizableHelper.writeLong(out, this.getTransportReceivedMessages());
        ExternalizableHelper.writeLong(out, this.getTransportRetainedBytes());
        ExternalizableHelper.writeLong(out, this.getTransportSentBytes());
        ExternalizableHelper.writeLong(out, this.getTransportSentMessages());
        ExternalizableHelper.writeSafeUTF(out, this.getTransportStatus());
        ExternalizableHelper.writeSafeUTF(out, this.getType());
        ExternalizableHelper.writeSafeUTF(out, this.getPersistenceEnvironment());
        out.writeFloat(this.getPersistenceLatencyAverage());
        ExternalizableHelper.writeLong(out, this.getPersistenceLatencyMax());
        ExternalizableHelper.writeSafeUTF(out, this.getPersistenceMode());
        ExternalizableHelper.writeLong(out, this.getPersistenceActiveSpaceAvailable());
        ExternalizableHelper.writeLong(out, this.getPersistenceSnapshotSpaceAvailable());
        ExternalizableHelper.writeLong(out, this.getPersistenceActiveSpaceTotal());
        ExternalizableHelper.writeLong(out, this.getPersistenceSnapshotSpaceTotal());
        ExternalizableHelper.writeLong(out, this.getPersistenceActiveSpaceUsed());
        ExternalizableHelper.writeSafeUTF(out, this.getPersistenceSnapshotArchiver());
    }
}

