/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.BackupRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupMultiRequest$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionControl;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.PrimitiveSparseArray;
import java.io.IOException;
import java.util.Map;

public abstract class BackupMultiRequest
extends BackupRequest
implements Continuation {
    private PrimitiveSparseArray __m_PartitionVersions;
    private transient PartitionSet __m_SkipPartitions;
    private static ListMap __mapChildren;

    static {
        BackupMultiRequest.__initStatic();
    }

    public BackupMultiRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Poll", BackupMultiRequest$Poll.get_CLASS());
    }

    public Message cloneMessage() {
        BackupMultiRequest msg = (BackupMultiRequest)super.cloneMessage();
        msg.setPartitionVersions(new PrimitiveSparseArray(this.getPartitionVersions()));
        msg.setSyncMsg(this.isSyncMsg());
        return msg;
    }

    public void doBackup(PartitionSet partsSkip) {
    }

    public String getDescription() {
        PartitionSet partsSkip = this.getSkipPartitions();
        return new StringBuilder(String.valueOf(super.getDescription())).append("\nPartitionVersions=").append(this.getPartitionVersions()).append(partsSkip == null ? "" : new StringBuilder(String.valueOf("\nSkip=")).append(partsSkip).toString()).append("\nSyncMsg=").append(this.isSyncMsg()).append("; Confirmed=").append(this.isConfirmed()).toString();
    }

    public PartitionSet getPartitionSet() {
        PartitionSet parts = new PartitionSet(((PartitionedService)this.getService()).getPartitionCount());
        PrimitiveSparseArray.Iterator iter = (PrimitiveSparseArray.Iterator)this.getPartitionVersions().iterator();
        while (iter.hasNext()) {
            iter.nextPrimitive();
            parts.add((int)iter.getIndex());
        }
        PartitionSet partsSkip = this.getSkipPartitions();
        if (partsSkip != null) {
            parts.remove(partsSkip);
        }
        return parts;
    }

    public PrimitiveSparseArray getPartitionVersions() {
        return this.__m_PartitionVersions;
    }

    public PartitionSet getSkipPartitions() {
        return this.__m_SkipPartitions;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/message/requestMessage/chainedRequest/backupRequest/BackupMultiRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public void onReceived() {
        PartitionedService service = (PartitionedService)this.getService();
        PartitionSet partsReject = null;
        PrimitiveSparseArray paVersions = this.getPartitionVersions();
        PrimitiveSparseArray.Iterator iter = (PrimitiveSparseArray.Iterator)paVersions.iterator();
        while (iter.hasNext()) {
            iter.nextPrimitive();
            int nPartition = (int)iter.getIndex();
            PartitionedService$PartitionControl control = service.getPartitionControl(nPartition);
            if (!(control == null ? true : (!(service.isBackupOwner(nPartition) ^ true) ? false : control.isTransferringOut() ^ true))) continue;
            if (partsReject == null) {
                partsReject = new PartitionSet(service.getPartitionCount());
            }
            partsReject.add(nPartition);
        }
        if (partsReject == null) {
            service.processBackupMulti(this);
        } else {
            int nMemberOriginator = this.getOriginatingMemberId();
            Member memberOriginator = service.getServiceMemberSet().getMember(nMemberOriginator);
            if (this.isConfirmed() ? true : memberOriginator == null) {
                Component._trace(new StringBuilder(String.valueOf("Discarding ")).append(this.get_Name()).append(" for unowned ").append(partsReject).append(" originating from member ").append(nMemberOriginator).toString(), 5);
                this.skipPartitions(partsReject);
                if (this.getPartitionSet().isEmpty()) {
                    this.forwardOrReply(this);
                } else {
                    service.processBackupMulti(this);
                }
            } else {
                service.sendPingRequest(memberOriginator, this);
            }
        }
    }

    public void proceed(Object oResult) {
        this.setConfirmed(true);
        this.onReceived();
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        PrimitiveSparseArray paVersions = this.getPartitionVersions();
        int cPartitions = ExternalizableHelper.readInt(input);
        int i = 0;
        while (i < cPartitions) {
            int nPartition = ExternalizableHelper.readInt(input);
            long lVersion = ExternalizableHelper.readLong(input);
            paVersions.setPrimitive(nPartition, lVersion);
            ++i;
        }
    }

    public void setPartitionVersions(PrimitiveSparseArray arrayVersions) {
        this.__m_PartitionVersions = arrayVersions;
    }

    protected void setSkipPartitions(PartitionSet parts) {
        this.__m_SkipPartitions = parts;
    }

    public void skipPartition(int nPartition) {
        PartitionSet partsSkip = this.getSkipPartitions();
        if (partsSkip == null) {
            partsSkip = new PartitionSet(((PartitionedService)this.getService()).getPartitionCount());
            this.setSkipPartitions(partsSkip);
        }
        partsSkip.add(nPartition);
    }

    public void skipPartitions(PartitionSet partsSkip) {
        PartitionSet partsSkipped = this.getSkipPartitions();
        if (partsSkipped == null) {
            this.setSkipPartitions(new PartitionSet(partsSkip));
        } else {
            partsSkipped.add(partsSkip);
        }
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        PrimitiveSparseArray paVersions = this.getPartitionVersions();
        int cPartitions = paVersions.getSize();
        ExternalizableHelper.writeInt(output, cPartitions);
        PrimitiveSparseArray.Iterator iter = (PrimitiveSparseArray.Iterator)paVersions.iterator();
        while (iter.hasNext()) {
            long lVersion = iter.nextPrimitive();
            int nPartition = (int)iter.getIndex();
            ExternalizableHelper.writeInt(output, nPartition);
            ExternalizableHelper.writeLong(output, lVersion);
        }
    }
}

