/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.Base;

public class DaemonPool$ResizeTask
extends Util
implements Runnable {
    public static final int ADJUST_FASTER = 1;
    public static final int ADJUST_SLOWER = 2;
    public static final boolean DEBUG = false;
    public static final double IDLE_FRACTION = 0.333;
    public static final int IDLE_LIMIT = 20;
    public static final long PERIOD_ADJUST = 1000L;
    public static final long PERIOD_MAX = 10000L;
    public static final long PERIOD_MIN = 1000L;
    public static final long PERIOD_SHAKE = 600000L;
    public static final double RESIZE_GROW = 0.1;
    public static final double RESIZE_JITTER = 0.05;
    public static final double RESIZE_SHAKE = 0.15;
    public static final double RESIZE_SHRINK = 0.05;
    private transient double __m_ActiveCountAverage;
    private long __m_LastActiveMillis;
    private int __m_LastResize;
    private long __m_LastResizeMillis;
    private long __m_LastRunMillis;
    private long __m_LastShakeMillis;
    private long __m_LastTaskCount;
    private int __m_LastThreadCount;
    private double __m_LastThroughput;
    private long __m_PeriodMillis;

    static {
        DaemonPool$ResizeTask._initStatic();
    }

    public DaemonPool$ResizeTask() {
        this(null, null, true);
    }

    public DaemonPool$ResizeTask(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void _initStatic$Default() {
    }

    protected static void _initStatic() {
        DEBUG = Config.getBoolean("coherence.daemonpool.debug");
        IDLE_FRACTION = DaemonPool$ResizeTask.getDoubleProperty("coherence.daemonpool.idle.fraction", IDLE_FRACTION);
        IDLE_LIMIT = DaemonPool$ResizeTask.getIntegerProperty("coherence.daemonpool.idle.threshold", IDLE_LIMIT);
        PERIOD_ADJUST = DaemonPool$ResizeTask.getLongProperty("coherence.daemonpool.adjust.period", PERIOD_ADJUST);
        PERIOD_MAX = DaemonPool$ResizeTask.getLongProperty("coherence.daemonpool.max.period", PERIOD_MAX);
        PERIOD_MIN = DaemonPool$ResizeTask.getLongProperty("coherence.daemonpool.min.period", PERIOD_MIN);
        PERIOD_SHAKE = DaemonPool$ResizeTask.getLongProperty("coherence.daemonpool.shake.period", PERIOD_SHAKE);
        RESIZE_GROW = DaemonPool$ResizeTask.getDoubleProperty("coherence.daemonpool.grow.percentage", RESIZE_GROW);
        RESIZE_JITTER = DaemonPool$ResizeTask.getDoubleProperty("coherence.daemonpool.jitter.percentage", RESIZE_JITTER);
        RESIZE_SHAKE = DaemonPool$ResizeTask.getDoubleProperty("coherence.daemonpool.shake.percentage", RESIZE_SHAKE);
        RESIZE_SHRINK = DaemonPool$ResizeTask.getDoubleProperty("coherence.daemonpool.shrink.percentage", RESIZE_SHRINK);
        if (DEBUG) {
            Object[] ao = new Object[]{IDLE_FRACTION, IDLE_LIMIT, PERIOD_ADJUST, PERIOD_MAX, PERIOD_MIN, PERIOD_SHAKE, RESIZE_GROW, RESIZE_JITTER, RESIZE_SHAKE, RESIZE_SHRINK};
            Component._trace(String.format("ResizeTask[IdleFraction=%.2f, IdleLimit=%d, PeriodAdjust=%d, PeriodMax=%d, PeriodMin=%d, PeriodShake=%d, ResizeGrow=%.3f, ResizeJitter=%.3f, ResizeShake=%.3f, ResizeShrink=%.3f]", ao), 3);
        }
        DaemonPool$ResizeTask._initStatic$Default();
    }

    protected long adjustPeriod(int nAdjust, int cThreadsOld, int cThreadsNew) {
        long cMillis = this.getPeriodMillis();
        switch (nAdjust) {
            case 1: {
                if (!(cThreadsOld != cThreadsNew)) break;
                this.setPeriodMillis(Math.max(PERIOD_MIN, cMillis - PERIOD_ADJUST));
                cMillis = PERIOD_MIN;
                break;
            }
            case 2: {
                cMillis = Math.min(PERIOD_MAX, cMillis + PERIOD_ADJUST);
                this.setPeriodMillis(cMillis);
                break;
            }
        }
        return cMillis;
    }

    public synchronized void cancel() {
        this.get_Parent()._unlinkChild(this);
    }

    private static String format2f(double dfl) {
        return String.format("%.2f", dfl);
    }

    public double getActiveCountAverage() {
        return this.__m_ActiveCountAverage;
    }

    public int getDaemonCount() {
        return this.getDaemonPool().getDaemonCount();
    }

    public DaemonPool getDaemonPool() {
        return (DaemonPool)this.get_Module();
    }

    protected static double getDoubleProperty(String sName, double dflDefault) {
        try {
            return Double.parseDouble(Config.getProperty(sName));
        }
        catch (RuntimeException e) {
            return dflDefault;
        }
    }

    protected static int getIntegerProperty(String sName, int nDefault) {
        try {
            return Config.getInteger(sName, nDefault);
        }
        catch (RuntimeException e) {
            return nDefault;
        }
    }

    public long getLastActiveMillis() {
        return this.__m_LastActiveMillis;
    }

    public int getLastResize() {
        return this.__m_LastResize;
    }

    public long getLastResizeMillis() {
        return this.__m_LastResizeMillis;
    }

    public long getLastRunMillis() {
        return this.__m_LastRunMillis;
    }

    public long getLastShakeMillis() {
        return this.__m_LastShakeMillis;
    }

    public long getLastTaskCount() {
        return this.__m_LastTaskCount;
    }

    public int getLastThreadCount() {
        return this.__m_LastThreadCount;
    }

    public double getLastThroughput() {
        return this.__m_LastThroughput;
    }

    protected static long getLongProperty(String sName, long nDefault) {
        try {
            return Config.getLong(sName, nDefault);
        }
        catch (RuntimeException e) {
            return nDefault;
        }
    }

    public long getPeriodMillis() {
        return this.__m_PeriodMillis;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DaemonPool$ResizeTask".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DaemonPool$ResizeTask();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected int growDaemonPool(String sReason) {
        int cThreads = this.getDaemonCount();
        return this.isDaemonPoolUnderutilized() ? cThreads : this.resizeDaemonPool(Math.max(1, (int)((double)cThreads * RESIZE_GROW)), sReason);
    }

    protected boolean isDaemonPoolOverutilized() {
        int cThreads = this.getDaemonCount();
        double dflActive = this.getActiveCountAverage();
        int cIdle = (int)((double)cThreads - dflActive);
        return !(!(!(cThreads < this.getDaemonPool().getDaemonCountMax()) ? false : dflActive > (double)cThreads * (1.0 - IDLE_FRACTION)) ? false : cIdle < IDLE_LIMIT) ? false : this.getLastThroughput() > 0.0;
    }

    protected boolean isDaemonPoolUnderutilized() {
        int cThreads = this.getDaemonCount();
        return !(cThreads > this.getDaemonPool().getDaemonCountMin()) ? false : (this.getActiveCountAverage() < (double)cThreads * IDLE_FRACTION ? true : this.getLastThroughput() == 0.0);
    }

    protected static boolean isStatisticsSuspect(long ldtLastRun, long ldtLastResize, long ldtResizeEnd, long ldtReset) {
        return ldtLastRun <= ldtReset ? true : (!(ldtLastRun == ldtLastResize) ? false : ldtResizeEnd - ldtLastResize > PERIOD_MIN / (long)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInit() {
        long ldtNow = Base.getSafeTimeMillis();
        this.setLastRunMillis(ldtNow);
        this.setLastShakeMillis(ldtNow);
        this.setPeriodMillis(PERIOD_MIN);
        DaemonPool pool = this.getDaemonPool();
        Object object = pool.STATS_MONITOR;
        synchronized (object) {
            this.setLastActiveMillis(pool.getStatsActiveMillis());
            this.setLastTaskCount(pool.getStatsTaskCount());
        }
        this.setLastThreadCount(pool.getDaemonCount());
        super.onInit();
    }

    protected static String reasonToString(String sReason) {
        if (sReason == null ? true : sReason.isEmpty()) {
            return "";
        }
        return new StringBuilder(String.valueOf(" due to ")).append(sReason).toString();
    }

    protected int resizeDaemonPool(int cDelta, String sReason) {
        DaemonPool pool = this.getDaemonPool();
        int cCurrent = pool.getDaemonCount();
        int cNew = cCurrent + cDelta;
        if ((cDelta == 0 ? true : cNew < pool.getDaemonCountMin()) ? true : cNew > pool.getDaemonCountMax()) {
            return cCurrent;
        }
        Component._trace(new StringBuilder(String.valueOf("DaemonPool \"")).append(pool.getName()).append("\" ").append(cDelta > 0 ? "increasing" : "decreasing").append(" the pool size from ").append(cCurrent).append(" to ").append(cNew).append(" thread(s)").append(DaemonPool$ResizeTask.reasonToString(sReason)).toString(), 3);
        pool.setDaemonCount(cNew);
        return cNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        int cNew;
        int cThreads;
        long cActiveMillis;
        long cTasks;
        long cPeriod;
        long ldtNow;
        DaemonPool pool;
        block34: {
            block32: {
                block31: {
                    boolean bl;
                    block30: {
                        pool = this.getDaemonPool();
                        if (pool == null) return;
                        boolean bl2 = false;
                        if (bl2) {
                            return;
                        }
                        pool.flushStats();
                        ldtNow = Base.getSafeTimeMillis();
                        cPeriod = this.getPeriodMillis();
                        cTasks = 0L;
                        cActiveMillis = 0L;
                        cNew = cThreads = pool.getDaemonCount();
                        if (pool.isInTransition()) {
                            pool.schedule(this, PERIOD_MIN);
                            if (!DEBUG) return;
                            Component._trace(new StringBuilder(String.valueOf("DaemonPool \"")).append(pool.getName()).append("\": skipping analysis due to the pool resize in progress").toString(), 3);
                            return;
                        }
                        try {
                            block33: {
                                long ldtLastResize;
                                block35: {
                                    double dflTPDelta;
                                    block37: {
                                        int cLast;
                                        block36: {
                                            long ldtResizeEnd;
                                            long ldtReset;
                                            Object object = pool.STATS_MONITOR;
                                            synchronized (object) {
                                                cActiveMillis = pool.getStatsActiveMillis();
                                                cTasks = pool.getStatsTaskCount();
                                                ldtReset = pool.getStatsLastResetMillis();
                                                ldtResizeEnd = pool.getStatsLastResizeMillis();
                                            }
                                            long ldtLastRun = this.getLastRunMillis();
                                            ldtLastResize = this.getLastResizeMillis();
                                            if (cThreads != this.getLastThreadCount()) {
                                                if (DEBUG) {
                                                    Component._trace(new StringBuilder(String.valueOf("DaemonPool \"")).append(pool.getName()).append("\": skipping analysis because the pool was resized externally (expected=").append(this.getLastThreadCount()).append(", current=").append(cThreads).append(")").toString(), 3);
                                                }
                                                this.setLastResize(cThreads - this.getLastThreadCount());
                                                Object var35_14 = null;
                                                bl = cNew != cThreads;
                                                break block30;
                                            }
                                            if (DaemonPool$ResizeTask.isStatisticsSuspect(ldtLastRun, ldtLastResize, ldtResizeEnd, ldtReset)) {
                                                if (DEBUG) {
                                                    Component._trace(new StringBuilder(String.valueOf("DaemonPool \"")).append(pool.getName()).append("\": skipping analysis to gather new statistics after a resize or reset").toString(), 3);
                                                }
                                                cPeriod = PERIOD_MIN;
                                                break block31;
                                            }
                                            long cTasksDelta = cTasks - this.getLastTaskCount();
                                            long cMillisDelta = ldtNow - ldtLastRun;
                                            double dflTP = (cTasksDelta <= (long)0 ? true : cMillisDelta <= 0L) ? 0.0 : (double)cTasksDelta * 1000.0 / (double)cMillisDelta;
                                            double dflActive = (this.getActiveCountAverage() + (double)pool.getActiveDaemonCount()) / (double)2;
                                            cLast = this.getLastResize();
                                            double dflTPLast = this.getLastThroughput();
                                            dflTPDelta = dflTP - dflTPLast;
                                            double dflTPJitter = dflTP * RESIZE_JITTER;
                                            if (!DEBUG ? false : cTasksDelta > (long)0) {
                                                double dflUtilization = cMillisDelta <= 0L ? 0.0 : (double)(cActiveMillis - this.getLastActiveMillis()) / (double)cMillisDelta;
                                                Object[] ao = new Object[]{cThreads, dflActive, cTasksDelta, cMillisDelta, dflTP, dflUtilization};
                                                Component._trace(String.format(new StringBuilder(String.valueOf("DaemonPool \"")).append(pool.getName()).append("\": [Size=%d, Active=%.2f, DeltaTasks=%d, DeltaMills=%d, Throughput=%.1f, Utilization=%.2f]").toString(), ao), 3);
                                            }
                                            this.setLastThroughput(dflTP);
                                            this.setActiveCountAverage(dflActive);
                                            if (ldtNow >= this.getLastShakeMillis() + PERIOD_SHAKE) {
                                                this.setLastShakeMillis(ldtNow);
                                                if (dflTP > 0.0) {
                                                    cNew = this.shakeDaemonPool();
                                                    this.setLastResize(cNew - cThreads);
                                                    break block32;
                                                }
                                            }
                                            if (!(Math.abs(dflTPDelta) > dflTPJitter)) break block35;
                                            if (!(cLast > 0)) break block36;
                                            if (dflTPDelta > 0.0) {
                                                cNew = this.growDaemonPool(new StringBuilder(String.valueOf("an increase in throughput of ")).append(DaemonPool$ResizeTask.format2f(dflTPDelta)).append("op/sec").toString());
                                                cPeriod = this.adjustPeriod(ADJUST_FASTER, cThreads, cNew);
                                                break block33;
                                            } else {
                                                cNew = this.shrinkDaemonPool(new StringBuilder(String.valueOf("a decrease in throughput of ")).append(DaemonPool$ResizeTask.format2f(-dflTPDelta)).append("op/sec").toString());
                                                cPeriod = this.adjustPeriod(ADJUST_SLOWER, cThreads, cNew);
                                            }
                                            break block33;
                                        }
                                        if (!(cLast < 0)) break block37;
                                        if (dflTPDelta > 0.0) {
                                            cNew = this.shrinkDaemonPool(new StringBuilder(String.valueOf("an increase in throughput of ")).append(DaemonPool$ResizeTask.format2f(dflTPDelta)).append("op/sec").toString());
                                            cPeriod = this.adjustPeriod(ADJUST_FASTER, cThreads, cNew);
                                            break block33;
                                        } else {
                                            cNew = this.growDaemonPool(new StringBuilder(String.valueOf("a decrease in throughput of ")).append(DaemonPool$ResizeTask.format2f(-dflTPDelta)).append("op/sec").toString());
                                            cPeriod = this.adjustPeriod(ADJUST_SLOWER, cThreads, cNew);
                                        }
                                        break block33;
                                    }
                                    if (dflTPDelta > 0.0) break block33;
                                    if (this.isDaemonPoolUnderutilized()) {
                                        cNew = this.shrinkDaemonPool("a decrease in throughput and the pool been underutilized");
                                        cPeriod = this.adjustPeriod(ADJUST_FASTER, cThreads, cNew);
                                        break block33;
                                    } else if (this.isDaemonPoolOverutilized()) {
                                        cNew = this.growDaemonPool("an decrease in throughput and the pool being overutilized");
                                        cPeriod = this.adjustPeriod(ADJUST_FASTER, cThreads, cNew);
                                    }
                                    break block33;
                                }
                                if (ldtNow > ldtLastResize + cPeriod) {
                                    if (this.isDaemonPoolOverutilized()) {
                                        cNew = this.growDaemonPool("the pool being overutilized");
                                        cPeriod = this.adjustPeriod(ADJUST_FASTER, cThreads, cNew);
                                    } else if (this.isDaemonPoolUnderutilized()) {
                                        cNew = this.shrinkDaemonPool("the pool being underutilized");
                                        cPeriod = this.adjustPeriod(ADJUST_FASTER, cThreads, cNew);
                                    } else {
                                        cPeriod = this.adjustPeriod(ADJUST_SLOWER, cThreads, cNew);
                                    }
                                }
                            }
                            this.setLastResize(cNew - cThreads);
                            break block34;
                        }
                        catch (Throwable throwable) {
                            Object var35_19 = null;
                            if (cNew != cThreads) {
                                this.setLastResizeMillis(ldtNow);
                            }
                            this.setLastRunMillis(ldtNow);
                            this.setLastTaskCount(cTasks);
                            this.setLastThreadCount(cNew);
                            this.setLastActiveMillis(cActiveMillis);
                            pool.schedule(this, cPeriod);
                            throw throwable;
                        }
                    }
                    if (bl) {
                        this.setLastResizeMillis(ldtNow);
                    }
                    this.setLastRunMillis(ldtNow);
                    this.setLastTaskCount(cTasks);
                    this.setLastThreadCount(cNew);
                    this.setLastActiveMillis(cActiveMillis);
                    pool.schedule(this, cPeriod);
                    return;
                }
                Object var35_15 = null;
                if (cNew != cThreads) {
                    this.setLastResizeMillis(ldtNow);
                }
                this.setLastRunMillis(ldtNow);
                this.setLastTaskCount(cTasks);
                this.setLastThreadCount(cNew);
                this.setLastActiveMillis(cActiveMillis);
                pool.schedule(this, cPeriod);
                return;
            }
            Object var35_17 = null;
            if (cNew != cThreads) {
                this.setLastResizeMillis(ldtNow);
            }
            this.setLastRunMillis(ldtNow);
            this.setLastTaskCount(cTasks);
            this.setLastThreadCount(cNew);
            this.setLastActiveMillis(cActiveMillis);
            pool.schedule(this, cPeriod);
            return;
        }
        Object var35_18 = null;
        if (cNew != cThreads) {
            this.setLastResizeMillis(ldtNow);
        }
        this.setLastRunMillis(ldtNow);
        this.setLastTaskCount(cTasks);
        this.setLastThreadCount(cNew);
        this.setLastActiveMillis(cActiveMillis);
        pool.schedule(this, cPeriod);
    }

    protected void setActiveCountAverage(double dflAverage) {
        this.__m_ActiveCountAverage = dflAverage;
    }

    protected void setLastActiveMillis(long cMillis) {
        this.__m_LastActiveMillis = cMillis;
    }

    protected void setLastResize(int cThreads) {
        this.__m_LastResize = cThreads;
    }

    protected void setLastResizeMillis(long ldtResize) {
        this.__m_LastResizeMillis = ldtResize;
    }

    protected void setLastRunMillis(long ldtRun) {
        this.__m_LastRunMillis = ldtRun;
    }

    protected void setLastShakeMillis(long ldtDown) {
        this.__m_LastShakeMillis = ldtDown;
    }

    protected void setLastTaskCount(long cTasks) {
        this.__m_LastTaskCount = cTasks;
    }

    protected void setLastThreadCount(int cThreads) {
        this.__m_LastThreadCount = cThreads;
    }

    protected void setLastThroughput(double dflTP) {
        this.__m_LastThroughput = dflTP;
    }

    protected void setPeriodMillis(long cMillis) {
        this.__m_PeriodMillis = cMillis;
    }

    protected int shakeDaemonPool() {
        int cDelta = Math.max(1, (int)((double)this.getDaemonCount() * RESIZE_SHAKE));
        int cRange = 2 * cDelta + 1;
        return this.resizeDaemonPool(Base.getRandom().nextInt(cRange) - cDelta, "the pool being shaken");
    }

    protected int shrinkDaemonPool(String sReason) {
        return this.resizeDaemonPool(-Math.max(1, (int)((double)this.getDaemonCount() * RESIZE_SHRINK)), sReason);
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.get_Name())).append(" for ").append(this.getDaemonPool()).toString();
    }
}

