/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.deltaMap.TransactionMap;
import com.tangosol.coherence.component.util.deltaMap.transactionMap.Optimistic;
import com.tangosol.coherence.component.util.deltaMap.transactionMap.optimistic.Commited;
import com.tangosol.coherence.component.util.deltaMap.transactionMap.optimistic.Serializable;
import com.tangosol.coherence.component.util.deltaMap.transactionMap.pessimistic.Repeatable;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.Status;

public class TransactionCache
extends Util
implements NamedCache,
ConcurrentMap,
com.tangosol.util.TransactionMap {
    private transient int __m_Concurrency;
    private transient ConcurrentMap __m_Map;
    private transient NamedCache __m_NamedCache;
    private transient int __m_Status;
    private transient int __m_TransactionIsolation;
    private transient int __m_TransactionTimeout;
    private TransactionMap.Validator __m_Validator;
    private boolean __m_ValuesImmutable;

    public TransactionCache() {
        this(null, null, true);
    }

    public TransactionCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setStatus(6);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    public void addMapListener(MapListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        throw new UnsupportedOperationException();
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        throw new UnsupportedOperationException();
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        throw new UnsupportedOperationException();
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        throw new UnsupportedOperationException();
    }

    public void begin() {
        int nStatus = this.getStatus();
        if ((nStatus == Status.STATUS_NO_TRANSACTION ? true : nStatus == Status.STATUS_ROLLEDBACK) ? true : nStatus == Status.STATUS_COMMITTED) {
            ConcurrentMap map = this.getMap();
            if (map instanceof com.tangosol.util.TransactionMap) {
                com.tangosol.util.TransactionMap mapTx = (com.tangosol.util.TransactionMap)map;
                mapTx.setTransactionTimeout(this.getTransactionTimeout());
                mapTx.setValidator(this.getValidator());
                mapTx.begin();
            }
        } else {
            throw this.invalidStatus("begin");
        }
        this.setStatus(Status.STATUS_ACTIVE);
    }

    public void clear() {
        this.getMap().clear();
    }

    public void commit() {
        if (this.getStatus() == Status.STATUS_PREPARED) {
            try {
                this.setStatus(Status.STATUS_COMMITTING);
                ConcurrentMap map = this.getMap();
                if (map instanceof com.tangosol.util.TransactionMap) {
                    ((com.tangosol.util.TransactionMap)map).commit();
                }
                this.setStatus(Status.STATUS_COMMITTED);
            }
            catch (RuntimeException e) {
                this.setStatus(Status.STATUS_UNKNOWN);
                throw e;
            }
        } else {
            throw this.invalidStatus("commit");
        }
    }

    public boolean containsKey(Object oKey) {
        return this.getMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.getMap().containsValue(oValue);
    }

    public void destroy() {
        this.rollback();
        this.getNamedCache().destroy();
    }

    public Set entrySet() {
        return this.getMap().entrySet();
    }

    public Set entrySet(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransactionCache) {
            return this.getMap().equals(((TransactionCache)obj).getMap());
        }
        return false;
    }

    public static String formatStatus(int nStatus) {
        switch (nStatus) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_ROLLEDBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNWON";
            }
        }
        throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid status: ")).append(nStatus).toString());
    }

    public Object get(Object oKey) {
        return this.getMap().get(oKey);
    }

    public Map getAll(Collection colKeys) {
        HashMap mapResult = new HashMap(colKeys.size());
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            if (!this.containsKey(oKey)) continue;
            mapResult.put(oKey, this.get(oKey));
        }
        return mapResult;
    }

    public ConcurrentMap getBaseMap() {
        return this.getNamedCache();
    }

    public String getCacheName() {
        return this.getNamedCache().getCacheName();
    }

    public CacheService getCacheService() {
        return this.getNamedCache().getCacheService();
    }

    public int getConcurrency() {
        return this.__m_Concurrency;
    }

    public ConcurrentMap getMap() {
        return this.__m_Map;
    }

    public NamedCache getNamedCache() {
        return this.__m_NamedCache;
    }

    public int getStatus() {
        return this.__m_Status;
    }

    public int getTransactionIsolation() {
        return this.__m_TransactionIsolation;
    }

    public int getTransactionTimeout() {
        return this.__m_TransactionTimeout;
    }

    public TransactionMap.Validator getValidator() {
        return this.__m_Validator;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/TransactionCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new TransactionCache();
    }

    private final Component get_Module() {
        return this;
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public void initialize(NamedCache cache) {
        Component._assert(!(cache != null) ? false : this.getNamedCache() == null, "NamedCache is not resettable");
        Component._assert(cache.getCacheService().getInfo().getServiceType() != CacheService.TYPE_REMOTE, "RemoteNamedCache does not support local transactions");
        this.setNamedCache(cache);
        this.setMap(cache);
    }

    protected TransactionMap instantiateTransactionMap() {
        int nConcur = this.getConcurrency();
        int nIsolation = this.getTransactionIsolation();
        TransactionMap mapTx = TransactionCache.instantiateTransactionMap(nConcur, nIsolation);
        return mapTx;
    }

    public static TransactionMap instantiateTransactionMap(int nConcur, int nIsolation) {
        TransactionMap mapTx;
        boolean fExternal = false;
        if (nConcur == TransactionMap.CONCUR_EXTERNAL) {
            nConcur = TransactionMap.CONCUR_OPTIMISTIC;
            fExternal = true;
        }
        switch (nConcur * 8 + nIsolation) {
            case 9: {
                mapTx = new com.tangosol.coherence.component.util.deltaMap.transactionMap.pessimistic.Commited();
                break;
            }
            case 10: {
                mapTx = new Repeatable();
                break;
            }
            case 11: {
                mapTx = new com.tangosol.coherence.component.util.deltaMap.transactionMap.pessimistic.Serializable();
                break;
            }
            case 17: {
                mapTx = new Commited();
                break;
            }
            case 18: {
                mapTx = new com.tangosol.coherence.component.util.deltaMap.transactionMap.optimistic.Repeatable();
                break;
            }
            case 19: {
                mapTx = new Serializable();
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid concurrency or isolation level: ")).append(nConcur).append(", ").append(nIsolation).toString());
            }
        }
        if (fExternal) {
            ((Optimistic)mapTx).setLockExternal(true);
        }
        return mapTx;
    }

    protected RuntimeException invalidStatus(String sMethod) {
        return new IllegalStateException(new StringBuilder(String.valueOf(sMethod)).append("-- invalid transaction status: ").append(this).toString());
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    public boolean isActive() {
        return this.getNamedCache().isActive();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public boolean isValuesImmutable() {
        return this.__m_ValuesImmutable;
    }

    public Set keySet() {
        return this.getMap().keySet();
    }

    public Set keySet(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public boolean lock(Object oKey) {
        return this.getMap().lock(oKey);
    }

    public boolean lock(Object oKey, long cWait) {
        return this.getMap().lock(oKey, cWait);
    }

    public void prepare() {
        if (this.getStatus() == Status.STATUS_ACTIVE) {
            try {
                this.setStatus(Status.STATUS_PREPARING);
                ConcurrentMap map = this.getMap();
                if (map instanceof com.tangosol.util.TransactionMap) {
                    ((com.tangosol.util.TransactionMap)map).prepare();
                }
                this.setStatus(Status.STATUS_PREPARED);
            }
            catch (RuntimeException e) {
                this.setStatus(Status.STATUS_MARKED_ROLLBACK);
                throw e;
            }
        } else {
            throw this.invalidStatus("prepare");
        }
    }

    public Object put(Object oKey, Object oValue) {
        return this.getMap().put(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        if (cMillis == (long)0) {
            return this.put(oKey, oValue);
        }
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        this.getMap().putAll(map);
    }

    public void release() {
        this.rollback();
        this.getNamedCache().release();
    }

    public Object remove(Object oKey) {
        return this.getMap().remove(oKey);
    }

    public void removeIndex(ValueExtractor extractor) {
        throw new UnsupportedOperationException();
    }

    public void removeMapListener(MapListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        throw new UnsupportedOperationException();
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        throw new UnsupportedOperationException();
    }

    public void rollback() {
        block2: {
            try {
                this.setStatus(Status.STATUS_ROLLING_BACK);
                ConcurrentMap map = this.getMap();
                if (!(map instanceof com.tangosol.util.TransactionMap)) break block2;
                ((com.tangosol.util.TransactionMap)map).rollback();
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.setStatus(Status.STATUS_ROLLEDBACK);
                throw throwable;
            }
        }
        Object var2_3 = null;
        this.setStatus(Status.STATUS_ROLLEDBACK);
    }

    public void setConcurrency(int nConcurrency) {
        this.__m_Concurrency = nConcurrency;
    }

    protected void setMap(ConcurrentMap map) {
        this.__m_Map = map;
    }

    protected void setNamedCache(NamedCache cache) {
        this.__m_NamedCache = cache;
    }

    public void setStatus(int pStatus) {
        this.__m_Status = pStatus;
    }

    public void setTransactionIsolation(int nIsolation) {
        this.__m_TransactionIsolation = nIsolation;
    }

    public void setTransactionTimeout(int nTimeout) {
        this.__m_TransactionTimeout = nTimeout;
    }

    public void setValidator(TransactionMap.Validator validator) {
        this.__m_Validator = validator;
    }

    public void setValuesImmutable(boolean fImmutable) {
        this.__m_ValuesImmutable = fImmutable;
    }

    public int size() {
        return this.getMap().size();
    }

    public String toString() {
        return new StringBuilder(String.valueOf("TransactionalCache: ")).append(TransactionCache.formatStatus(this.getStatus())).append("\n  BaseMap=").append(this.getNamedCache()).append("\n  DeltaMap=").append(Base.indentString(this.getMap().toString(), "    ", false)).toString();
    }

    public boolean unlock(Object oKey) {
        return this.getMap().unlock(oKey);
    }

    public Collection values() {
        return this.getMap().values();
    }
}

