/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray$PlaceHolder;
import com.tangosol.coherence.component.util.windowedArray.ConcurrentWindowedArray;
import com.tangosol.net.Guardian;
import com.tangosol.util.Base;
import com.tangosol.util.InflatableSet;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeSortedMap;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Grid$PollArray
extends ConcurrentWindowedArray {
    public static final long POLL_EXPIRY_RESOLUTION = 256L;
    private SafeSortedMap __m_ExpiryMap;
    private transient long __m_LastNullPollId;
    private transient long __m_LastNullPollIdTimeout;
    private static ListMap __mapChildren;

    static {
        Grid$PollArray.__initStatic();
    }

    public Grid$PollArray() {
        this(null, null, true);
    }

    public Grid$PollArray(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setExpiryMap(new SafeSortedMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("PlaceHolder", Grid$PollArray$PlaceHolder.get_CLASS());
    }

    public long add(Object o) {
        Poll poll = (Poll)o;
        Component._assert(!(!(poll.getService() == null) ? false : poll.getPollId() == 0L) ? false : poll.isClosed() ^ true);
        Grid service = (Grid)this.get_Module();
        poll.setService(service);
        poll.setTracingSpan(service.newTracingSpan("request", poll).startSpan());
        Set setExpiry = this.getExpirySet(poll);
        if (setExpiry != null) {
            Set setExpiryPost = setExpiry;
            do {
                setExpiry = setExpiryPost;
                setExpiry.add(poll);
            } while (setExpiry != (setExpiryPost = this.getExpirySet(poll)));
        }
        return super.add(o);
    }

    protected void assignIndexToValue(long lVirtual, Object o) {
        ((Poll)o).setPollId(lVirtual);
    }

    public void checkPolls() {
        long ldtNow = Base.getSafeTimeMillis();
        this.validatePolls(ldtNow);
        this.expirePolls(ldtNow);
    }

    protected void expirePolls(long ldt) {
        SafeSortedMap map = this.getExpiryMap();
        try {
            if (map.isEmpty() ? true : (Long)map.firstKey() > ldt) {
                return;
            }
        }
        catch (NoSuchElementException e) {
            return;
        }
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            long ldtExpiry = (Long)entry.getKey();
            if (ldtExpiry > ldt) {
                return;
            }
            iter.remove();
            Iterator iterPoll = ((Set)entry.getValue()).iterator();
            while (iterPoll.hasNext()) {
                ((Poll)iterPoll.next()).close();
            }
        }
    }

    public Object get(long lVirtual) {
        if (lVirtual == 0L) {
            return null;
        }
        Object o = this.optimisticGet(lVirtual);
        return o == null ? super.get(lVirtual) : o;
    }

    public SafeSortedMap getExpiryMap() {
        return this.__m_ExpiryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getExpirySet(Poll poll) {
        Long LdtGroup;
        long ldtExpiry = poll.getExpiryTimeMillis();
        if (ldtExpiry <= (long)0 ? true : ldtExpiry >= Long.MAX_VALUE - POLL_EXPIRY_RESOLUTION) {
            return null;
        }
        SafeSortedMap mapExpiry = this.getExpiryMap();
        Set setPoll = (Set)mapExpiry.get(LdtGroup = new Long(ldtExpiry + POLL_EXPIRY_RESOLUTION - (long)1 & (POLL_EXPIRY_RESOLUTION - (long)1 ^ 0xFFFFFFFFFFFFFFFFL)));
        if (setPoll == null) {
            SafeSortedMap safeSortedMap = mapExpiry;
            synchronized (safeSortedMap) {
                setPoll = (Set)mapExpiry.get(LdtGroup);
                if (setPoll == null) {
                    setPoll = new InflatableSet();
                }
                mapExpiry.put(LdtGroup, setPoll);
            }
        }
        return setPoll;
    }

    public long getLastNullPollId() {
        return this.__m_LastNullPollId;
    }

    public long getLastNullPollIdTimeout() {
        return this.__m_LastNullPollIdTimeout;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/Grid$PollArray".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Grid$PollArray();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public Object remove(long lVirtual) {
        Set setExpiry;
        Poll poll = (Poll)super.remove(lVirtual);
        if (poll != null && (setExpiry = this.getExpirySet(poll)) != null) {
            setExpiry.remove(poll);
        }
        return poll;
    }

    protected long retrieveIndexFromValue(Object o) {
        return ((Poll)o).getPollId();
    }

    protected void setExpiryMap(SafeSortedMap mapExpiry) {
        this.__m_ExpiryMap = mapExpiry;
    }

    public void setLastNullPollId(long pLastNullPollId) {
        this.__m_LastNullPollId = pLastNullPollId;
    }

    protected void setLastNullPollIdTimeout(long ldtTimeout) {
        this.__m_LastNullPollIdTimeout = ldtTimeout;
    }

    protected void validatePolls(long ldtNow) {
        try {
            boolean fEmpty;
            long lFirst = this.getFirstIndex();
            long lLast = this.getLastIndex();
            boolean bl = fEmpty = lFirst > lLast;
            if (fEmpty) {
                return;
            }
            Poll poll = (Poll)this.get(lFirst);
            if (poll == null) {
                long lLastNullPollId = this.getLastNullPollId();
                if (lLastNullPollId == lFirst) {
                    if (this.getLastNullPollIdTimeout() < ldtNow) {
                        this.remove(lFirst);
                        Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Removed empty poll element #").append(lFirst).append(" from array ").append(this.formatStats()).toString(), 1);
                    }
                } else {
                    this.setLastNullPollId(lFirst);
                    Guardian.GuardContext ctx = ((Grid)this.get_Module()).getGuardable().getContext();
                    this.setLastNullPollIdTimeout(ldtNow + (ctx == null ? 1000L : ctx.getSoftTimeoutMillis()));
                }
                return;
            }
            Grid service = (Grid)this.get_Module();
            long cMillisAge = ldtNow - poll.getInitTimeMillis();
            if (cMillisAge < service.getStartupTimeout() >>> 1) {
                return;
            }
            if (poll.getPollId() > service.getSuspendPollLimit().get()) {
                return;
            }
            this.validatePollsExtra(poll, lFirst, lLast, cMillisAge, ldtNow);
        }
        catch (Throwable e) {
            Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Non-fatal exception detected during processing:").toString(), 1);
            Component._trace(e);
            Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Exception has been logged; continuing processing.").toString(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void validatePollsExtra(Poll poll, long lFirst, long lLast, long cMillisAge, long ldtNow) {
        String sPoll = poll.getClass().getName();
        try {
            sPoll = poll.toString();
            if (poll.get_Parent() != null) {
                sPoll = new StringBuilder(String.valueOf(sPoll)).append(new StringBuilder(String.valueOf("\nRequest=")).append(poll.get_Parent().toString()).toString()).toString();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Poll poll2 = poll;
        // MONITORENTER : poll2
        if (lFirst != this.getFirstIndex()) {
            Object var17_9 = null;
            // MONITOREXIT : poll2
            return;
        }
        if (poll.isClosed()) {
            this.remove(lFirst);
            Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Removed closed poll: ").append(sPoll).append(" from array ").append(this.formatStats()).toString(), 1);
            Object var17_10 = null;
            // MONITOREXIT : poll2
            return;
        }
        MemberSet setRemain = poll.getRemainingMemberSet();
        if (setRemain == null ? true : setRemain.isEmpty()) {
            poll.close();
            Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Closed poll that had no remaining members: ").append(sPoll).append(" within array ").append(this.formatStats()).toString(), 1);
            Object var17_11 = null;
            // MONITOREXIT : poll2
            return;
        }
        Grid service = (Grid)this.get_Module();
        ServiceMemberSet setService = service.getServiceMemberSet();
        MasterMemberSet setMaster = service.getClusterMemberSet();
        boolean fClose = false;
        int nMember = setRemain.getFirstId();
        while (nMember > 0) {
            if (setService.contains(nMember) ^ true) {
                MasterMemberSet masterMemberSet = setMaster;
                // MONITORENTER : masterMemberSet
                Member member = setMaster.getMember(nMember);
                // MONITOREXIT : masterMemberSet
                if (member == null) {
                    member = setMaster.getRecycleSet().getMember(nMember);
                    if (member == null) {
                        fClose = setRemain.size() == 1 ? true : cMillisAge > 60000L;
                    } else if (ldtNow > member.getTimestamp() + 30000L) {
                        poll.onLeft(member);
                        Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Removed missing member ").append(member).append(" from poll: ").append(sPoll).append(" within array ").append(this.formatStats()).toString(), 1);
                    }
                }
            }
            nMember = setRemain.getNextId(nMember);
        }
        if (poll.isClosed()) {
            Object var17_13 = null;
            // MONITOREXIT : poll2
            return;
        }
        if (fClose) {
            poll.close();
            Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Closed poll that had missing member: ").append(sPoll).append(" within array ").append(this.formatStats()).toString(), 1);
            Object var17_14 = null;
            // MONITOREXIT : poll2
            return;
        }
        StringBuilder sbRemain = new StringBuilder("\nRemaining members info:\n  {");
        int nMember2 = setRemain.getFirstId();
        while (nMember2 > 0) {
            Member member = setMaster.getMember(nMember2);
            if (member != null) {
                sbRemain.append("\n  ").append(service.collectTransportStats(member));
            }
            nMember2 = setRemain.getNextId(nMember2);
        }
        sbRemain.append("\n  }");
        long cGap = lLast - lFirst;
        if (cGap > (long)(Packet.TRINT_MAX_VARIANCE >>> 1)) {
            poll.close();
            Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Manual intervention is required to stop ").append("this node or ").append("the members that have not responded to this ").append("poll (gap size=").append(cGap).append("): ").append(sPoll).append((Object)sbRemain).append(" within array ").append(this.formatStats()).toString(), 1);
            return;
        }
        if (!(service.getServiceState() == Service.SERVICE_STOPPED) ? false : service.isAcceptingClients() ^ true) {
            Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("This service timed-out due to unanswered handshake request. ").append("Manual intervention is required to stop ").append("the members that have not responded to this ").append(sPoll).append((Object)sbRemain).append("\n").append(service.formatStats(true)).toString(), 1);
        }
        // MONITOREXIT : poll2
    }
}

