/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberWelcomeRequest;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;

public class ClusterService$NewMemberInduct
extends Message {
    private Member[] __m_Member;
    private transient int __m_MemberCount;
    private transient int __m_ServiceCount;
    private int[] __m_ServiceId;
    private String[] __m_ServiceName;
    private boolean[] __m_ServiceSuspended;
    private String[] __m_ServiceType;
    private String[] __m_ServiceVersion;

    public ClusterService$NewMemberInduct() {
        this(null, null, true);
    }

    public ClusterService$NewMemberInduct(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(6);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        int cMembers = this.getMemberCount();
        int cServices = this.getServiceCount();
        sb.append("MemberCount=").append(cMembers).append("\nMember/ServiceVersion=[");
        int i = 0;
        while (i < cMembers) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getMember(i)).append('/').append(this.getServiceVersion(i));
            ++i;
        }
        sb.append("]\nServiceCount=").append(cServices).append("\nServiceId/ServiceName=[");
        i = 0;
        while (i < cServices) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getServiceId(i)).append('/').append(this.getServiceName(i));
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public Member[] getMember() {
        return this.__m_Member;
    }

    public Member getMember(int i) {
        return this.getMember()[i];
    }

    public int getMemberCount() {
        Member[] ao = this.getMember();
        return ao == null ? 0 : ao.length;
    }

    public int getServiceCount() {
        int[] anId = this.getServiceId();
        return anId == null ? 0 : anId.length;
    }

    public int[] getServiceId() {
        return this.__m_ServiceId;
    }

    public int getServiceId(int i) {
        return this.getServiceId()[i];
    }

    public String[] getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceName(int i) {
        return this.getServiceName()[i];
    }

    public String[] getServiceType() {
        return this.__m_ServiceType;
    }

    public String getServiceType(int i) {
        return this.getServiceType()[i];
    }

    public String[] getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public String getServiceVersion(int i) {
        return this.getServiceVersion()[i];
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberInduct".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberInduct();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean[] isServiceSuspended() {
        return this.__m_ServiceSuspended;
    }

    public boolean isServiceSuspended(int i) {
        return this.isServiceSuspended()[i];
    }

    public void onReceived() {
        int cServices;
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        String sVersionThis = service.getServiceVersion();
        int cMembers = this.getMemberCount();
        if (cMembers > 0) {
            Member[] aMember = this.getMember();
            String[] asVersion = this.getServiceVersion();
            int i = 0;
            while (i < cMembers) {
                Member member = aMember[i];
                String sVersion = asVersion[i];
                if (service.isVersionCompatible(sVersion) ^ true) {
                    service.onMemberRejected(ClusterService.REJECT_VERSION, this.getFromMember());
                    throw new EventDeathException("Version mismatch");
                }
                service.ensureMember(member, sVersion);
                ++i;
            }
        }
        if ((cServices = this.getServiceCount()) > 0) {
            int[] anId = this.getServiceId();
            String[] asName = this.getServiceName();
            String[] asType = this.getServiceType();
            boolean[] afSuspended = this.isServiceSuspended();
            int i = 0;
            while (i < cServices) {
                service.ensureServiceInfo(anId[i], asName[i], asType[i]).setSuspended(afSuspended[i]);
                ++i;
            }
        }
        service.setState(ClusterService.STATE_JOINED);
        service.getTcpRing().onJoined();
        service.ensureMemberLeft(null, null, true);
        Member memberThis = service.getThisMember();
        service.getClusterMemberSet().setServiceJoined(memberThis.getId());
        ClusterService$NewMemberWelcomeRequest msg = (ClusterService$NewMemberWelcomeRequest)service.instantiateMessage("NewMemberWelcomeRequest");
        msg.setToMemberSet(service.getOthersMemberSet());
        msg.setPreferredPacketLength(memberThis.getPreferredPacketLength());
        msg.setPreferredPort(memberThis.getPreferredPort());
        msg.setServiceVersion(sVersionThis);
        service.send(msg);
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        int cServices;
        ClusterService service = (ClusterService)this.getService();
        int cMembers = input.readUnsignedShort();
        if (cMembers > 0) {
            Member[] aMember = new Member[cMembers];
            String[] asVersion = new String[cMembers];
            int i = 0;
            while (i < cMembers) {
                Member member = service.instantiateMember();
                member.readExternal(input);
                member.setTcpRingPort(ExternalizableHelper.readInt(input));
                aMember[i] = member;
                asVersion[i] = ExternalizableHelper.readUTF(input);
                ++i;
            }
            this.setMember(aMember);
            this.setServiceVersion(asVersion);
        }
        if ((cServices = input.readUnsignedShort()) > 0) {
            int[] anServiceId = new int[cServices];
            String[] asServiceName = new String[cServices];
            String[] asServiceType = new String[cServices];
            boolean[] afServiceSuspended = new boolean[cServices];
            int i = 0;
            while (i < cServices) {
                anServiceId[i] = input.readUnsignedShort();
                asServiceName[i] = input.readUTF();
                asServiceType[i] = input.readUTF();
                afServiceSuspended[i] = input.readBoolean();
                ++i;
            }
            this.setServiceId(anServiceId);
            this.setServiceName(asServiceName);
            this.setServiceType(asServiceType);
            this.setServiceSuspended(afServiceSuspended);
        }
    }

    public void setMember(int i, Member nId) {
        this.getMember()[i] = nId;
    }

    public void setMember(Member[] anId) {
        this.__m_Member = anId;
    }

    public void setMemberCount(int c) {
        String[] asOldVer;
        int cOldVers;
        Member[] aOldMbr = this.getMember();
        int cOldMbrs = aOldMbr == null ? 0 : aOldMbr.length;
        if (c != cOldMbrs) {
            Member[] aNewMbr = new Member[c];
            if (cOldMbrs > 0) {
                System.arraycopy(aOldMbr, 0, aNewMbr, 0, Math.min(c, cOldMbrs));
            }
            this.setMember(aNewMbr);
        }
        if (c != (cOldVers = (asOldVer = this.getServiceVersion()) == null ? 0 : asOldVer.length)) {
            String[] asNewVer = new String[c];
            if (cOldVers > 0) {
                System.arraycopy(asOldVer, 0, asNewVer, 0, Math.min(c, cOldVers));
            }
            this.setServiceVersion(asNewVer);
        }
    }

    public void setServiceCount(int c) {
        boolean[] afOldSuspended;
        int cOldSuspended;
        String[] asOldType;
        int cOldTypes;
        String[] asOldName;
        int cOldNames;
        int[] anOldId = this.getServiceId();
        int cOldIds = anOldId == null ? 0 : anOldId.length;
        if (c != cOldIds) {
            int[] anNewId = new int[c];
            if (cOldIds > 0) {
                System.arraycopy(anOldId, 0, anNewId, 0, Math.min(c, cOldIds));
            }
            this.setServiceId(anNewId);
        }
        if (c != (cOldNames = (asOldName = this.getServiceName()) == null ? 0 : asOldName.length)) {
            String[] asNewName = new String[c];
            if (cOldNames > 0) {
                System.arraycopy(asOldName, 0, asNewName, 0, Math.min(c, cOldNames));
            }
            this.setServiceName(asNewName);
        }
        if (c != (cOldTypes = (asOldType = this.getServiceType()) == null ? 0 : asOldType.length)) {
            String[] asNewType = new String[c];
            if (cOldTypes > 0) {
                System.arraycopy(asOldType, 0, asNewType, 0, Math.min(c, cOldTypes));
            }
            this.setServiceType(asNewType);
        }
        if (c != (cOldSuspended = (afOldSuspended = this.isServiceSuspended()) == null ? 0 : afOldSuspended.length)) {
            boolean[] afNewSuspended = new boolean[c];
            if (cOldSuspended > 0) {
                System.arraycopy(afOldSuspended, 0, afNewSuspended, 0, Math.min(c, cOldSuspended));
            }
            this.setServiceSuspended(afNewSuspended);
        }
    }

    public void setServiceId(int i, int nId) {
        this.getServiceId()[i] = nId;
    }

    public void setServiceId(int[] anId) {
        this.__m_ServiceId = anId;
    }

    public void setServiceName(int i, String sName) {
        this.getServiceName()[i] = sName;
    }

    public void setServiceName(String[] asName) {
        this.__m_ServiceName = asName;
    }

    public void setServiceSuspended(int i, boolean fSuspended) {
        this.isServiceSuspended()[i] = fSuspended;
    }

    public void setServiceSuspended(boolean[] afSuspended) {
        this.__m_ServiceSuspended = afSuspended;
    }

    public void setServiceType(int i, String sType) {
        this.getServiceType()[i] = sType;
    }

    public void setServiceType(String[] asType) {
        this.__m_ServiceType = asType;
    }

    public void setServiceVersion(int i, String sVersion) {
        this.getServiceVersion()[i] = sVersion;
    }

    public void setServiceVersion(String[] asVersion) {
        this.__m_ServiceVersion = asVersion;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        int cMembers = this.getMemberCount();
        output.writeShort(cMembers);
        if (cMembers > 0) {
            Member[] aMember = this.getMember();
            String[] asVersion = this.getServiceVersion();
            int i = 0;
            while (i < cMembers) {
                Member member = aMember[i];
                member.writeExternal(output);
                ExternalizableHelper.writeInt(output, member.getTcpRingPort());
                ExternalizableHelper.writeUTF(output, asVersion[i]);
                ++i;
            }
        }
        int cServices = this.getServiceCount();
        output.writeShort(cServices);
        if (cServices > 0) {
            int[] anServiceId = this.getServiceId();
            String[] asServiceName = this.getServiceName();
            String[] asServiceType = this.getServiceType();
            boolean[] afServiceSuspended = this.isServiceSuspended();
            int i = 0;
            while (i < cServices) {
                output.writeShort(anServiceId[i]);
                output.writeUTF(asServiceName[i]);
                output.writeUTF(asServiceType[i]);
                output.writeBoolean(afServiceSuspended[i]);
                ++i;
            }
        }
    }
}

