/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoinRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoining$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceUpdateResponse;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Map;

public class ClusterService$ServiceJoining
extends RequestMessage
implements Continuation {
    private transient ClusterService$ServiceJoinRequest __m_JoinRequest;
    private Map __m_MemberConfigMap;
    private int __m_MemberId;
    private PermissionInfo __m_PermissionInfo;
    private String __m_ServiceEndPointName;
    private int __m_ServiceId;
    private long __m_ServiceJoinTime;
    private String __m_ServiceName;
    private String __m_ServiceType;
    private String __m_ServiceVersion;
    private static ListMap __mapChildren;

    static {
        ClusterService$ServiceJoining.__initStatic();
    }

    public ClusterService$ServiceJoining() {
        this(null, null, true);
    }

    public ClusterService$ServiceJoining(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(43);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Poll", ClusterService$ServiceJoining$Poll.get_CLASS());
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("MemberId=")).append(this.getMemberId()).append("\nServiceId=").append(this.getServiceId()).append("\nServiceName=").append(this.getServiceName()).append("\nServiceVersion=").append(this.getServiceVersion()).append("\nServiceEndPoint=").append(this.getServiceEndPointName()).append("\nServiceJoinTime=").append(this.getServiceJoinTime()).append("\nMemberConfigMap=").append(this.getMemberConfigMap()).toString();
    }

    public ClusterService$ServiceJoinRequest getJoinRequest() {
        return this.__m_JoinRequest;
    }

    public Map getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public int getMemberId() {
        return this.__m_MemberId;
    }

    public PermissionInfo getPermissionInfo() {
        return this.__m_PermissionInfo;
    }

    public String getServiceEndPointName() {
        return this.__m_ServiceEndPointName;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public long getServiceJoinTime() {
        return this.__m_ServiceJoinTime;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return this.__m_ServiceType;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoining".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ClusterService$ServiceJoining();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    protected Poll instantiatePoll() {
        return (Poll)this._newChild("Poll");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceived() {
        ServiceMemberSet setMember;
        ServiceInfo info;
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        int nMember = this.getMemberId();
        Member member = service.getClusterMemberSet().getMember(nMember);
        if (member == null) {
            String sReason = new StringBuilder(String.valueOf("Member ")).append(nMember).append(service.getClusterMemberSet().getRecycleSet().getMember(nMember) == null ? " is unknown to" : " is detected as departed by").append(" member ").append(service.getThisMember().getId()).toString();
            this.proceed(sReason);
            return;
        }
        Member memberThis = service.getThisMember();
        long ldtJoined = this.getServiceJoinTime();
        if (member == memberThis) {
            int nServiceId = this.getServiceId();
            info = service.getServiceInfo(nServiceId);
            Component._assert(info != null);
            Poll pollJoinRequest = this.getPoll();
            if (pollJoinRequest == null ? true : pollJoinRequest.isClosed()) {
                Component._trace(new StringBuilder(String.valueOf("Ignoring delayed response to JoinRequest for ")).append(this.getServiceName()).append(" at ").append(ServiceMemberSet.formatJoinTime(ldtJoined)).toString(), 3);
                this.proceed((Object)null);
                return;
            }
        } else {
            info = service.ensureServiceInfo(this.getServiceId(), this.getServiceName(), this.getServiceType());
        }
        if ((setMember = info.getMemberSet()).contains(member)) {
            if (member == memberThis) {
                throw new IllegalStateException(new StringBuilder(String.valueOf("Service ")).append(this.getServiceName()).append(" joining request for this member is out of order").toString());
            }
            int nState = setMember.getState(nMember);
            setMember.remove(member);
            service.onServiceLeft(info, member, nState);
        }
        if (!setMember.contains(memberThis) ? false : ldtJoined < setMember.getServiceJoinTime(memberThis.getId())) {
            Component._trace(new StringBuilder(String.valueOf("Service ")).append(this.getServiceName()).append(" joining request for member ").append(member.getId()).append(" (joinTime=").append(ServiceMemberSet.formatJoinTime(ldtJoined)).append(") out of order:\n").append(setMember).toString(), 1);
            this.proceed(new StringBuilder(String.valueOf("New service member is older than member")).append(memberThis.getId()).toString());
            return;
        }
        ServiceMemberSet serviceMemberSet = setMember;
        synchronized (serviceMemberSet) {
            setMember.add(member);
            setMember.setServiceVersion(nMember, this.getServiceVersion());
            setMember.setServiceJoinTime(nMember, ldtJoined);
            setMember.setServiceJoining(nMember);
            setMember.setServiceEndPointName(nMember, this.getServiceEndPointName());
            setMember.updateMemberConfigMap(nMember, this.getMemberConfigMap());
        }
        service.onServiceJoining(info, member);
        service.validateNewService(info, member, this, this.getPermissionInfo());
    }

    public void proceed(Object oResult) {
        ClusterService service = (ClusterService)this.getService();
        ClusterService$ServiceUpdateResponse msgResponse = (ClusterService$ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
        msgResponse.respondTo(this);
        if (oResult instanceof String ? true : oResult instanceof Exception) {
            service.getServiceInfo(this.getServiceId()).getMemberSet().remove(this.getMemberId());
        }
        msgResponse.setResult(oResult);
        service.send(msgResponse);
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        try {
            this.setMemberId(input.readUnsignedShort());
            this.setServiceId(input.readUnsignedShort());
            this.setServiceName(input.readUTF());
            this.setServiceType(input.readUTF());
            this.setServiceVersion(input.readUTF());
            this.setServiceEndPointName(input.readUTF());
            this.setServiceJoinTime(input.readLong());
            this.setMemberConfigMap((Map)this.readObject(input));
            this.setPermissionInfo((PermissionInfo)this.readObject(input));
        }
        catch (IOException e) {
            this.getService().onConfigIOException(e, this.getFromMember());
        }
    }

    public void setJoinRequest(ClusterService$ServiceJoinRequest pJoinRequest) {
        this.__m_JoinRequest = pJoinRequest;
    }

    public void setMemberConfigMap(Map map) {
        this.__m_MemberConfigMap = map;
    }

    public void setMemberId(int pMemberId) {
        this.__m_MemberId = pMemberId;
    }

    public void setPermissionInfo(PermissionInfo infoPermission) {
        this.__m_PermissionInfo = infoPermission;
    }

    public void setServiceEndPointName(String sName) {
        this.__m_ServiceEndPointName = sName;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setServiceJoinTime(long lMillis) {
        this.__m_ServiceJoinTime = lMillis;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setServiceType(String pServiceType) {
        this.__m_ServiceType = pServiceType;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        output.writeShort(this.getMemberId());
        output.writeShort(this.getServiceId());
        output.writeUTF(this.getServiceName());
        output.writeUTF(this.getServiceType());
        output.writeUTF(this.getServiceVersion());
        output.writeUTF(this.getServiceEndPointName());
        output.writeLong(this.getServiceJoinTime());
        this.writeObject(output, this.getMemberConfigMap());
        this.writeObject(output, this.getPermissionInfo());
    }
}

