/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$CentralDistribution;
import com.tangosol.net.Member;
import com.tangosol.net.partition.DistributionManager;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.PartitionAssignmentStrategy;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionStatistics;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.WrapperException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PartitionedService$CentralDistribution$DistributionManager
extends Util
implements DistributionManager {
    private boolean __m_DeferredSuggestion;
    private PartitionSet __m_IgnoredAdvice;
    private Set __m_OwnershipLeavingMembers;
    private Set __m_OwnershipMembers;
    private String __m_StrategyName;
    private Map __m_SuggestionMap;
    private int __m_TargetStrength;

    public PartitionedService$CentralDistribution$DistributionManager() {
        this(null, null, true);
    }

    public PartitionedService$CentralDistribution$DistributionManager(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setTargetStrength(-1);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getBackupCount() {
        return ((PartitionedService)this.getService()).getBackupCount();
    }

    public PartitionSet getIgnoredAdvice() {
        return this.__m_IgnoredAdvice;
    }

    public Member getMember(int nMemberId) {
        return ((MemberSet)this.getOwnershipMembers()).getMember(nMemberId);
    }

    public PartitionSet getOwnedPartitions(Member member, int iStore) {
        int[][] aiOwners = this.getPartitionAssignments();
        int cPartitions = this.getPartitionCount();
        int nMemberId = member.getId();
        PartitionSet parts = new PartitionSet(cPartitions);
        int i = 0;
        while (i < cPartitions) {
            if (aiOwners[i][iStore] == nMemberId) {
                parts.add(i);
            }
            ++i;
        }
        return parts;
    }

    public Set getOwnershipLeavingMembers() {
        return this.__m_OwnershipLeavingMembers;
    }

    public Set getOwnershipMembers() {
        return this.__m_OwnershipMembers;
    }

    public int[][] getPartitionAssignments() {
        return ((PartitionedService)this.getService()).getPartitionAssignments();
    }

    public int getPartitionCount() {
        return ((PartitionedService)this.getService()).getPartitionCount();
    }

    public Ownership getPartitionOwnership(int nPartition) {
        return ((PartitionedService)this.get_Module()).getPartitionOwnership(nPartition);
    }

    public PartitionStatistics[] getPartitionStats() {
        return ((PartitionedService$CentralDistribution)this.get_Parent()).getPartitionStatistics();
    }

    public Map getSafeSuggestions() {
        Map.Entry entry;
        Map mapSuggest = this.getSuggestionMap();
        if (mapSuggest == null ? true : mapSuggest.isEmpty()) {
            return mapSuggest;
        }
        PartitionedService service = (PartitionedService)this.get_Module();
        int cBackups = this.getBackupCount();
        int nStrengthSvc = service.getBackupStrength(true);
        int nStrengthTarget = PartitionedService.BACKUP_STRENGTH_SITE;
        PartitionSet partsUnchanged = service.instantiatePartitionSet(true);
        int[] aiOwners = new int[cBackups + 1];
        PartitionedService$CentralDistribution dist = (PartitionedService$CentralDistribution)this.get_Parent();
        if (this.isDeferredSuggestion()) {
            nStrengthTarget = dist.getTargetStrength();
        } else {
            Iterator iter = mapSuggest.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry2 = iter.next();
                Ownership ownersNew = (Ownership)entry2.getKey();
                PartitionSet parts = (PartitionSet)entry2.getValue();
                nStrengthTarget = Math.min(nStrengthTarget, service.getBackupStrength(ownersNew.getOwners(aiOwners)));
                partsUnchanged.remove(parts);
            }
            int iPart = partsUnchanged.next(0);
            while (iPart >= 0) {
                nStrengthTarget = Math.min(nStrengthTarget, service.getBackupStrength(iPart, true));
                iPart = partsUnchanged.next(iPart + 1);
            }
            dist.setTargetStrength(nStrengthTarget);
        }
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        HashMap<Ownership, PartitionSet> mapDeferred = null;
        HashMap<Ownership, PartitionSet> mapSafe = null;
        Iterator iter = mapSuggest.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            Ownership ownersNew = (Ownership)entry.getKey();
            PartitionSet partsSuggest = (PartitionSet)entry.getValue();
            int iPart = partsSuggest.next(0);
            while (iPart >= 0) {
                Ownership ownersOld = this.getPartitionOwnership(iPart);
                Ownership ownersInterim = (Ownership)ownersOld.clone();
                if (!(setMembers.isServiceLeaving(ownersOld.getPrimaryOwner()) ? true : service.getBackupStrength(ownersOld.getOwners(aiOwners)) < nStrengthTarget)) {
                    int iStore = 0;
                    while (iStore <= cBackups) {
                        int nOwnerNew = ownersNew.getOwner(iStore);
                        int nOwnerOld = ownersInterim.getOwner(iStore);
                        if (nOwnerOld != nOwnerNew) {
                            this.simulateTransfer(ownersInterim, iStore, nOwnerNew, true);
                            if (service.getBackupStrength(ownersInterim.getOwners(aiOwners)) < nStrengthTarget) {
                                PartitionSet partsSafe;
                                PartitionSet partsDeferred;
                                Ownership ownersSafe = null;
                                int i = cBackups + 1;
                                while (i >= 0) {
                                    Ownership ownersStep = (Ownership)ownersOld.clone();
                                    if (ownersOld.getOwner(i) != ownersNew.getOwner(i)) {
                                        this.simulateTransfer(ownersStep, i, ownersNew.getOwner(i), false);
                                        if (service.getBackupStrength(ownersStep.getOwners(aiOwners)) >= nStrengthTarget) {
                                            ownersSafe = ownersStep;
                                            break;
                                        }
                                    }
                                    --i;
                                }
                                if (ownersSafe == null) {
                                    int iStore1 = -1;
                                    int iStore2 = -1;
                                    int i2 = cBackups + 1;
                                    while (i2 >= 0) {
                                        if (ownersOld.getOwner(i2) != ownersNew.getOwner(i2)) {
                                            if (iStore1 == -1) {
                                                iStore1 = i2;
                                            } else if (iStore2 == -1) {
                                                iStore2 = i2;
                                            }
                                        }
                                        --i2;
                                    }
                                    if (!(iStore1 == -1) ? false : iStore2 == -1) break;
                                    ownersSafe = (Ownership)ownersOld.clone();
                                    ownersSafe.setOwner(iStore1, ownersOld.getOwner(iStore2));
                                    ownersSafe.setOwner(iStore2, ownersOld.getOwner(iStore1));
                                }
                                if (setMembers.isServiceLeaving(ownersSafe.getPrimaryOwner())) break;
                                if (mapDeferred == null) {
                                    mapDeferred = new HashMap<Ownership, PartitionSet>();
                                    mapSafe = new HashMap<Ownership, PartitionSet>();
                                }
                                if ((partsDeferred = (PartitionSet)mapDeferred.get(ownersNew)) == null) {
                                    partsDeferred = service.instantiatePartitionSet(false);
                                    mapDeferred.put(ownersNew, partsDeferred);
                                }
                                if ((partsSafe = (PartitionSet)mapSafe.get(ownersSafe)) == null) {
                                    partsSafe = service.instantiatePartitionSet(false);
                                    mapSafe.put(ownersSafe, partsSafe);
                                }
                                partsSafe.add(iPart);
                                partsDeferred.add(iPart);
                                partsSuggest.remove(iPart);
                                if (!Component._isTraceEnabled(6)) break;
                                Component._trace(new StringBuilder(String.valueOf("Re-ordering the suggested transfer of partition ")).append(iPart).append(" from ").append(ownersOld).append(" to ").append(ownersNew).append(" to maintain the backup-strength by prioritizing the transfer to ").append(ownersSafe).toString(), 3);
                                break;
                            }
                        }
                        ++iStore;
                    }
                }
                iPart = partsSuggest.next(iPart + 1);
            }
            if (!partsSuggest.isEmpty()) continue;
            iter.remove();
        }
        if (mapDeferred == null) {
            this.setSuggestionMap(null);
        } else {
            this.setSuggestionMap(mapDeferred);
            this.setDeferredSuggestion(true);
            iter = mapSafe.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                Ownership ownersSafe = (Ownership)entry.getKey();
                PartitionSet partsSafe = (PartitionSet)entry.getValue();
                PartitionSet partsSuggest = (PartitionSet)mapSuggest.get(ownersSafe);
                if (partsSuggest == null) {
                    mapSuggest.put(ownersSafe, partsSafe);
                    continue;
                }
                partsSuggest.add(partsSafe);
            }
        }
        return mapSuggest;
    }

    public long getSamplingPeriod() {
        return ((PartitionedService$CentralDistribution)this.get_Parent()).getStatsSamplingInterval();
    }

    public com.tangosol.net.PartitionedService getService() {
        return (PartitionedService)this.get_Module();
    }

    public long getStatsSamplingInterval() {
        return 0L;
    }

    public String getStrategyName() {
        return this.__m_StrategyName;
    }

    public Map getSuggestionMap() {
        return this.__m_SuggestionMap;
    }

    public int getTargetStrength() {
        return this.__m_TargetStrength;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$CentralDistribution$DistributionManager".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedService$CentralDistribution$DistributionManager();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    public void initialize(PartitionAssignmentStrategy strategy) {
        strategy.init(this);
        this.setStrategyName(ClassHelper.getSimpleName(strategy.getClass()));
    }

    public boolean isDeferredSuggestion() {
        return this.__m_DeferredSuggestion;
    }

    public void reset() {
        this.setOwnershipLeavingMembers(null);
        this.setOwnershipMembers(null);
        Map mapSuggest = this.getSuggestionMap();
        this.setSuggestionMap(null);
        this.setDeferredSuggestion(false);
        if (!(mapSuggest != null) ? false : mapSuggest.isEmpty() ^ true) {
            PartitionSet partsIgnored = this.getIgnoredAdvice();
            Iterator iter = mapSuggest.values().iterator();
            while (iter.hasNext()) {
                PartitionSet parts = (PartitionSet)iter.next();
                if (partsIgnored == null) {
                    partsIgnored = new PartitionSet(parts);
                    continue;
                }
                partsIgnored.add(parts);
            }
            this.setIgnoredAdvice(partsIgnored);
        }
    }

    public void scheduleNextAnalysis(long cMillis) {
        PartitionedService$CentralDistribution dist = (PartitionedService$CentralDistribution)this.get_Parent();
        if (!dist.isCoordinator() ? false : cMillis >= 0L) {
            long ldtNow = Base.getSafeTimeMillis();
            dist.setAnalysisNextMillis(ldtNow + cMillis);
            PartitionedService service = (PartitionedService)this.getService();
            if (service.isDistributionStable() ^ true) {
                cMillis = Math.min(cMillis, (long)(service.getDistributionRepeatMillis() / service.getDistributionAggressiveness()));
            }
            service.setDistributionNextMillis(ldtNow + cMillis);
        }
    }

    protected void setDeferredSuggestion(boolean fSuggestion) {
        this.__m_DeferredSuggestion = fSuggestion;
    }

    protected void setIgnoredAdvice(PartitionSet parts) {
        this.__m_IgnoredAdvice = parts;
    }

    public void setOwnershipLeavingMembers(Set setLeaving) {
        this.__m_OwnershipLeavingMembers = setLeaving;
    }

    public void setOwnershipMembers(Set setOwners) {
        this.__m_OwnershipMembers = setOwners;
    }

    public void setStrategyName(String sName) {
        this.__m_StrategyName = sName;
    }

    protected void setSuggestionMap(Map partsUpdated) {
        this.__m_SuggestionMap = partsUpdated;
    }

    protected void setTargetStrength(int nStrength) {
        this.__m_TargetStrength = nStrength;
    }

    protected void simulateTransfer(Ownership owners, int iStore, int nOwnerNew, boolean fForward) {
        int nOwnerPrev = owners.getOwner(iStore);
        int cBackups = this.getBackupCount();
        owners.setOwner(iStore, nOwnerNew);
        if (fForward) {
            int i = iStore + 1;
            while (i <= cBackups) {
                if (owners.getOwner(i) == nOwnerNew) {
                    owners.setOwner(i, nOwnerPrev);
                }
                ++i;
            }
        } else {
            int i = iStore - 1;
            while (i >= 0) {
                if (owners.getOwner(i) == nOwnerNew) {
                    owners.setOwner(i, nOwnerPrev);
                }
                --i;
            }
        }
    }

    public void suggest(PartitionSet parts, Ownership owners) {
        PartitionSet partsSuggest;
        if (Component._isTraceEnabled(6)) {
            Component._trace(new StringBuilder(String.valueOf(this.getStrategyName())).append(" suggested the ownership of ").append(owners).append(" for ").append(parts).toString(), 3);
        }
        if (this.validateSuggestion(parts, owners) ^ true) {
            PartitionSet partsIgnored = this.getIgnoredAdvice();
            if (partsIgnored == null) {
                partsIgnored = new PartitionSet(parts);
            } else {
                partsIgnored.add(parts);
            }
            return;
        }
        this.setIgnoredAdvice(null);
        HashMap<Ownership, PartitionSet> mapSuggestions = this.getSuggestionMap();
        if (mapSuggestions == null) {
            mapSuggestions = new HashMap<Ownership, PartitionSet>();
            this.setSuggestionMap(mapSuggestions);
        }
        if ((partsSuggest = (PartitionSet)mapSuggestions.get(owners)) == null) {
            mapSuggestions.put(owners, new PartitionSet(parts));
        } else {
            partsSuggest.add(parts);
        }
    }

    protected boolean validateSuggestion(PartitionSet parts, Ownership owners) {
        MemberSet setSuggest = new MemberSet();
        MemberSet setOwners = (MemberSet)this.getOwnershipMembers();
        Set setLeaving = this.getOwnershipLeavingMembers();
        int cBackups = this.getBackupCount();
        int iStore = 0;
        while (iStore <= cBackups) {
            int nOwner = owners.getOwner(iStore);
            com.tangosol.coherence.component.net.Member member = setOwners.getMember(nOwner);
            if (member == null) {
                if (!(!(nOwner == 0) ? false : iStore > 0)) {
                    Component._trace(new StringBuilder(String.valueOf("Distribution suggestion (")).append(owners).append(") for ").append(parts).append(" contains unknown member ").append(nOwner).append("; ignoring suggested distribution").toString(), 1);
                    return false;
                }
            } else {
                if (setLeaving.contains(member)) {
                    Component._trace(new StringBuilder(String.valueOf("Distribution suggestion (")).append(owners).append(") for ").append(parts).append(" contains member ").append(nOwner).append(" which is leaving the service;").append(" ignoring suggested distribution").toString(), 1);
                    return false;
                }
                if (setSuggest.add(member) ^ true) {
                    Component._trace(new StringBuilder(String.valueOf("Distribution suggestion (")).append(owners).append(") for ").append(parts).append(" contains duplicate storage indices for ").append(nOwner).append(";").append(" ignoring suggested distribution").toString(), 1);
                    return false;
                }
            }
            ++iStore;
        }
        return true;
    }
}

