/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.MutableLong;
import com.oracle.coherence.persistence.PersistentStore;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.responseMessage.SimpleResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionControl$GuardContinuation;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionVersionSyncRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.internal.CopyOnWriteLongList;
import com.tangosol.net.partition.PartitionStatistics;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Gate;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ThreadGateLite;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PartitionedService$PartitionControl
extends Component
implements Guardable {
    public static final int LOCK_BACKUP_XFER_OUT = 1;
    public static final int LOCK_NONE = 0;
    public static final int LOCK_PENDING = 8;
    public static final int LOCK_PERSISTENCE = 4;
    public static final int LOCK_PRIMARY_XFER_IN = 2;
    public static final int LOCK_PRIMARY_XFER_OUT = 3;
    public static final int STATE_MASK_LOCK = 15;
    public static final int STATE_MASK_PIN = 64;
    public static final int STATE_MASK_SYNC = 128;
    public static final int STATE_MASK_XFER = 48;
    public static final int STATE_SHIFT_LOCK = 0;
    public static final int STATE_SHIFT_PIN = 6;
    public static final int STATE_SHIFT_SYNC = 7;
    public static final int STATE_SHIFT_XFER = 4;
    public static final int XFER_NONE = 0;
    public static final int XFER_SENT = 2;
    public static final int XFER_STARTED = 1;
    private transient AtomicInteger __m_BackupPolls;
    private List __m_BackupsCompletedActions;
    private Guardian.GuardContext __m_Context;
    private Message __m_DeferredBackup;
    private List __m_DeferredBackups;
    private int __m_PartitionId;
    private volatile int __m_PartitionState;
    private transient AtomicInteger __m_PersistenceTasks;
    private CopyOnWriteLongList __m_PersistentExtents;
    private volatile transient PersistentStore __m_PersistentStore;
    private boolean __m_Recovered;
    private PartitionStatistics __m_Statistics;
    private ThreadLocal __m_TLOEnterCounter;
    private long __m_VersionBackup;
    private AtomicLong __m_VersionCounter;
    private static ListMap __mapChildren;

    static {
        PartitionedService$PartitionControl.__initStatic();
    }

    public PartitionedService$PartitionControl(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("GuardContinuation", PartitionedService$PartitionControl$GuardContinuation.get_CLASS());
    }

    public synchronized void addBackupsCompletedAction(Continuation continuation) {
        Component._assert(this.isLocked());
        LinkedList<Continuation> list = this.getBackupsCompletedActions();
        if (list == null) {
            list = new LinkedList<Continuation>();
            this.setBackupsCompletedActions(list);
        }
        list.add(continuation);
    }

    public synchronized void addUnlockAction(Continuation continuation) {
        ConcurrentLinkedQueue<Continuation> queueActions = this.getUnlockActions();
        if (queueActions == null) {
            queueActions = new ConcurrentLinkedQueue<Continuation>();
            this.set_Sink(queueActions);
        }
        queueActions.offer(continuation);
    }

    public void checkDeferredBackups() {
        if (!(this.getContext() == null) ? false : this.getDeferredBackups().isEmpty() ^ true) {
            PartitionedService service = this.getService();
            service.guard(this, service.getDeferredBackupTimeoutMillis(), 0.9f);
        }
    }

    public void deferBackup(Message msgBackup, long lVersionNew) {
        List listDefer = this.getDeferredBackups();
        long lVersionNext = this.getVersionCounter().get() + (long)1;
        int iNew = (int)(lVersionNew - lVersionNext - (long)1);
        int iMax = listDefer.size();
        if (lVersionNew == lVersionNext) {
            this.setDeferredBackup(msgBackup);
        } else if (iNew >= iMax) {
            int i = iMax;
            while (i < iNew) {
                listDefer.add(null);
                ++i;
            }
            listDefer.add(msgBackup);
        } else {
            listDefer.set(iNew, msgBackup);
        }
    }

    public synchronized boolean deferResponse(Grid$Response msgResponse) {
        if (this.getLockType() == LOCK_NONE) {
            return false;
        }
        msgResponse.setResult(SimpleResponse.RESULT_RETRY);
        this.addUnlockAction(this.getService().getContinuations().instantiateMessagePost(msgResponse));
        return true;
    }

    public void deletePersistentExtent(long lExtentId, LongArray laCaches) {
    }

    public void deletePersistentStore() {
        PersistentStore store = this.getPersistentStore();
        if (store != null) {
            String sStoreId = store.getId();
            if (sStoreId != null) {
                this.getService().getPersistenceManager().delete(sStoreId, false);
                Component._trace(new StringBuilder(String.valueOf("Deleted persistent store ")).append(sStoreId).toString(), 7);
            }
            this.setPersistentStore(null);
        }
    }

    public void disablePersistentStore() {
        this.setPersistentStore(NullImplementation.getPersistentStore());
    }

    public void doSyncBackups() {
        this.flushDeferredBackups();
        PartitionedService service = (PartitionedService)this.get_Module();
        int nPartition = this.getPartitionId();
        List listBackups = service.getBackupOwners(nPartition, false);
        if (listBackups.isEmpty() ^ true) {
            this.markVersionInSync();
            PartitionedService$PartitionVersionSyncRequest msg = (PartitionedService$PartitionVersionSyncRequest)service.instantiateMessage("PartitionVersionSyncRequest");
            msg.setPartition(nPartition);
            msg.setPartitionVersion(this.getVersionCounter().get());
            msg.setMemberList(listBackups);
            service.post(msg);
        }
    }

    public void enableTransfer() {
        Gate gate = this.getGate();
        if (gate.isEnteredByCurrentThread()) {
            gate.exit();
            this.setPartitionState(this.getPartitionState() & ~STATE_MASK_PIN);
        } else if (this.getLockType() != LOCK_NONE) {
            Component._trace(new StringBuilder(String.valueOf("Unexpected enableTransfer() call for ")).append(this).append("\n").append(Component.get_StackTrace()).toString(), 2);
        }
    }

    public boolean ensurePersistentExtent(long lExtentId) {
        return false;
    }

    public PersistentStore ensurePersistentStore() {
        return this.ensurePersistentStore(null);
    }

    public PersistentStore ensurePersistentStore(PersistentStore storeFrom) {
        PersistentStore store = this.getPersistentStore();
        if (store == null ? true : storeFrom != null) {
            PartitionedService service = this.getService();
            int nPartition = this.getPartitionId();
            Member member = service.getThisMember();
            long ldtJoin = service.getServiceMemberSet().getServiceJoinTime(member.getId());
            String sGUID = GUIDHelper.generateGUID(nPartition, service.getOwnershipVersion(nPartition), ldtJoin, member);
            store = service.getPersistenceControl().openActiveStore(sGUID, storeFrom);
            this.setPersistentStore(store);
        }
        return store;
    }

    public boolean enter(long cWait) {
        ThreadLocal tlo = this.getTLOEnterCounter();
        MutableLong mlCounter = (MutableLong)tlo.get();
        if (mlCounter.get() > (long)0 ? true : this.getGate().enter(cWait)) {
            mlCounter.incrementAndGet();
            return true;
        }
        return false;
    }

    public void exit() {
        ThreadLocal tlo = this.getTLOEnterCounter();
        MutableLong mlCounter = (MutableLong)tlo.get();
        if (mlCounter.decrementAndGet() == (long)0) {
            this.getGate().exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBackup(long lVersion) {
        if (lVersion > this.getVersionBackup()) {
            this.setVersionBackup(lVersion);
        }
        if (!(this.getBackupPolls().decrementAndGet() == 0) ? false : this.isLocked()) {
            PartitionedService$PartitionControl partitionedService$PartitionControl = this;
            synchronized (partitionedService$PartitionControl) {
                List listActions = this.getBackupsCompletedActions();
                if (listActions != null) {
                    this.setBackupsCompletedActions(null);
                    Iterator iter = listActions.iterator();
                    while (iter.hasNext()) {
                        Continuation cont = (Continuation)iter.next();
                        cont.proceed(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishPersist() {
        AtomicInteger atomicTasks = this.getPersistenceTasks();
        int cTask = atomicTasks.decrementAndGet();
        if (cTask == 0) {
            AtomicInteger atomicInteger = atomicTasks;
            synchronized (atomicInteger) {
                atomicTasks.notifyAll();
            }
        }
    }

    public void flushDeferredBackups() {
        Message msgExpected = this.getDeferredBackup();
        if (msgExpected != null) {
            this.setDeferredBackup(null);
            msgExpected.onReceived();
        } else {
            List listDeferred = this.getDeferredBackups();
            if (listDeferred.isEmpty() ^ true) {
                Guardian.GuardContext ctx;
                Message msgDeferred = (Message)listDeferred.remove(0);
                if (msgDeferred != null) {
                    msgDeferred.onReceived();
                }
                if ((ctx = this.getContext()) != null) {
                    if (listDeferred.isEmpty()) {
                        ctx.release();
                    } else {
                        ctx.heartbeat();
                    }
                }
            }
        }
    }

    public AtomicInteger getBackupPolls() {
        return this.__m_BackupPolls;
    }

    public List getBackupsCompletedActions() {
        return this.__m_BackupsCompletedActions;
    }

    public Guardian.GuardContext getContext() {
        return this.__m_Context;
    }

    public Message getDeferredBackup() {
        return this.__m_DeferredBackup;
    }

    public List getDeferredBackups() {
        return this.__m_DeferredBackups;
    }

    public Gate getGate() {
        return (Gate)this.get_Feed();
    }

    public int getLockType() {
        return (this.getPartitionState() & STATE_MASK_LOCK) >> STATE_SHIFT_LOCK & ~LOCK_PENDING;
    }

    public int getPartitionId() {
        return this.__m_PartitionId;
    }

    public int getPartitionState() {
        return this.__m_PartitionState;
    }

    public AtomicInteger getPersistenceTasks() {
        return this.__m_PersistenceTasks;
    }

    public CopyOnWriteLongList getPersistentExtents() {
        return this.__m_PersistentExtents;
    }

    public PersistentStore getPersistentStore() {
        return this.__m_PersistentStore;
    }

    public PartitionedService getService() {
        return (PartitionedService)this.get_Module();
    }

    public PartitionStatistics getStatistics() {
        return this.__m_Statistics;
    }

    public ThreadLocal getTLOEnterCounter() {
        return this.__m_TLOEnterCounter;
    }

    public int getTransferState() {
        return (this.getPartitionState() & STATE_MASK_XFER) >> STATE_SHIFT_XFER;
    }

    public Queue getUnlockActions() {
        return (Queue)this.get_Sink();
    }

    public long getVersionBackup() {
        return this.__m_VersionBackup;
    }

    public AtomicLong getVersionCounter() {
        return this.__m_VersionCounter;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionControl".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean initiateBackup() {
        PartitionedService service = (PartitionedService)this.get_Module();
        return this.getBackupPolls().incrementAndGet() >= PartitionedService.MAX_PENDING_BACKUP_POLL ? true : service.isAsyncBackup() ^ true;
    }

    public boolean initiatePersist() {
        PartitionedService service = (PartitionedService)this.get_Module();
        PartitionedService$PersistenceControl ctlPersistence = service.getPersistenceControl();
        return this.getPersistenceTasks().incrementAndGet() >= PartitionedService.MAX_PENDING_BACKUP_POLL ? true : ctlPersistence.isAsync() ^ true;
    }

    public boolean isLocked() {
        int nState = (this.getPartitionState() & STATE_MASK_LOCK) >> STATE_SHIFT_LOCK;
        return !(nState != LOCK_NONE) ? false : (nState & LOCK_PENDING) == 0;
    }

    public boolean isRecovered() {
        return this.__m_Recovered;
    }

    public boolean isRecovering() {
        return !((this.getLockType() & LOCK_PERSISTENCE) != 0) ? false : this.isRecovered() ^ true;
    }

    public boolean isTransferDisallowed() {
        return (this.getPartitionState() & (STATE_MASK_PIN | STATE_MASK_SYNC)) != 0;
    }

    public boolean isTransferringOut() {
        return !this.isLocked() ? false : this.getLockType() == LOCK_PRIMARY_XFER_OUT;
    }

    public synchronized boolean lock(long cWait, int nLockType) {
        Gate gate = this.getGate();
        if (gate.isEnteredByCurrentThread() ? true : (!gate.isClosedByCurrentThread() ? false : nLockType != this.getLockType())) {
            return false;
        }
        int nLockTypeOld = this.getLockType();
        boolean fLocked = false;
        this.setLockType(nLockType | LOCK_PENDING);
        try {
            fLocked = this.getGate().close(cWait);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setLockType(fLocked ? nLockType : nLockTypeOld);
            throw throwable;
        }
        Object var8_6 = null;
        this.setLockType(fLocked ? nLockType : nLockTypeOld);
        return fLocked;
    }

    protected void markVersionInSync() {
        this.setPartitionState(this.getPartitionState() | 1 << STATE_SHIFT_SYNC);
    }

    public void onInit() {
        this.set_Feed(new ThreadGateLite());
        this.setBackupPolls(new AtomicInteger());
        this.setPersistenceTasks(new AtomicInteger());
    }

    public void preparePersistentExtent(long lExtentId, LongArray laCaches) {
    }

    public void preparePersistentExtents() {
    }

    public void preparePersistentExtents(LongArray laExtentsExclude) {
    }

    public void preventTransfer() {
        Gate gate = this.getGate();
        if (gate.isEnteredByCurrentThread() ^ true) {
            this.setPartitionState(this.getPartitionState() | 1 << STATE_SHIFT_PIN);
            gate.enter(0L);
        }
    }

    public void recover() {
        long lVersionMissing = this.getVersionCounter().get() + (long)1;
        Guardian.GuardContext ctx = this.getContext();
        if (!(ctx != null) ? false : ctx.getState() != Guardian.GuardContext.STATE_HEALTHY) {
            PartitionedService service = this.getService();
            PartitionedService$PartitionControl$GuardContinuation continuation = (PartitionedService$PartitionControl$GuardContinuation)this._newChild("GuardContinuation");
            continuation.setMissingVersion(lVersionMissing);
            service.sendPingRequest(service.getPrimaryOwner(this.getPartitionId()), continuation);
            ctx.heartbeat();
        }
    }

    protected void setBackupPolls(AtomicInteger integerPolls) {
        this.__m_BackupPolls = integerPolls;
    }

    public void setBackupsCompletedActions(List listActions) {
        this.__m_BackupsCompletedActions = listActions;
    }

    public void setContext(Guardian.GuardContext ctx) {
        this.__m_Context = ctx;
    }

    public void setDeferredBackup(Message msgBackup) {
        this.__m_DeferredBackup = msgBackup;
    }

    protected void setDeferredBackups(List listBackups) {
        this.__m_DeferredBackups = listBackups;
    }

    protected void setLockType(int nLockType) {
        this.setPartitionState(this.getPartitionState() & ~STATE_MASK_LOCK | nLockType << STATE_SHIFT_LOCK);
    }

    public void setPartitionId(int nId) {
        this.__m_PartitionId = nId;
    }

    protected void setPartitionState(int nLockType) {
        this.__m_PartitionState = nLockType;
    }

    protected void setPersistenceTasks(AtomicInteger integerTasks) {
        this.__m_PersistenceTasks = integerTasks;
    }

    public void setPersistentExtents(CopyOnWriteLongList listExtents) {
        this.__m_PersistentExtents = listExtents;
    }

    protected void setPersistentStore(PersistentStore store) {
        this.__m_PersistentStore = store;
    }

    public void setRecovered(boolean fRecovered) {
        this.__m_Recovered = fRecovered;
    }

    public void setStatistics(PartitionStatistics statistics) {
        this.__m_Statistics = statistics;
    }

    public void setTLOEnterCounter(ThreadLocal localCount) {
        this.__m_TLOEnterCounter = localCount;
    }

    public synchronized void setTransferState(int nState) {
        this.setPartitionState(this.getPartitionState() & ~STATE_MASK_XFER | nState << STATE_SHIFT_XFER);
    }

    public void setVersionBackup(long lVersion) {
        this.__m_VersionBackup = lVersion;
    }

    protected void setVersionCounter(AtomicLong atomic) {
        this.__m_VersionCounter = atomic;
    }

    public void terminate() {
    }

    public String toString() {
        long lVersion = this.getVersionCounter().get();
        int nLockType = this.getLockType();
        String sLockType = "";
        switch (nLockType) {
            case 1: {
                sLockType = "[Backup Transfer Snapshot]";
                break;
            }
            case 0: {
                sLockType = "NONE";
                break;
            }
            case 4: {
                sLockType = "[Persistence Operation]";
                break;
            }
            case 2: {
                sLockType = "[Incoming Partition Transfer]";
                break;
            }
            case 3: {
                sLockType = "[Outgoing Partition Transfer]";
                break;
            }
            default: {
                sLockType = "[unknown]";
                break;
            }
        }
        int nXferState = this.getTransferState();
        String sXferState = "";
        switch (nXferState) {
            case 0: {
                sXferState = "NONE";
                break;
            }
            case 1: {
                sXferState = "[Transfer Started]";
                break;
            }
            case 2: {
                sXferState = "[Transfer Sent]";
                break;
            }
            default: {
                sXferState = "[unknown]";
                break;
            }
        }
        String sXferPrevented = this.isTransferDisallowed() ? ", TransferDisallowed" : "";
        return new StringBuilder(String.valueOf("PartitionControl{Partition=")).append(this.getPartitionId()).append(", Version=").append(lVersion).append(", Lock=").append(sLockType).append(", TransferState=").append(sXferState).append(sXferPrevented).append("}").toString();
    }

    public void truncatePersistentExtent(long lExtentId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlock() {
        Queue queueActions = this.getUnlockActions();
        while (true) {
            Continuation cont = null;
            boolean fHeartbeat = false;
            while (!(queueActions != null) ? false : (cont = (Continuation)queueActions.poll()) != null) {
                try {
                    cont.proceed(null);
                    fHeartbeat = true;
                }
                catch (Throwable t) {
                    Component._trace(new StringBuilder(String.valueOf("Caught ")).append(t).append(" while running deferred event:\n").append(Base.getStackTrace(t)).toString(), 1);
                }
            }
            if (fHeartbeat) {
                this.getService().heartbeat();
            }
            PartitionedService$PartitionControl partitionedService$PartitionControl = this;
            synchronized (partitionedService$PartitionControl) {
                if (queueActions == null) {
                    queueActions = this.getUnlockActions();
                }
                if (queueActions == null ? true : queueActions.isEmpty()) {
                    this.setLockType(LOCK_NONE);
                    this.getGate().open();
                    return;
                }
            }
        }
    }

    public void unmarkVersionInSync() {
        this.setPartitionState(this.getPartitionState() & ~STATE_MASK_SYNC);
    }

    public PartitionStatistics updateDirectStorageSize() {
        return null;
    }

    public void updatePersistentStoreVersion() {
        PersistentStore store = this.getPersistentStore();
        if (store != null) {
            PartitionedService service = this.getService();
            String sStoreId = store.getId();
            PersistentStore storeNew = this.ensurePersistentStore(store);
            service.saveQuorum(-1, storeNew);
            CachePersistenceHelper.seal(storeNew, service, null);
            service.getPersistenceManager().delete(sStoreId, false);
        }
    }
}

