/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.message.responseMessage.SimpleResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$Continuations;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl$SnapshotBuilder;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl$SnapshotController;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$SnapshotArchiveRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$SnapshotRequest;
import com.tangosol.net.internal.PartitionVersionExclusionList;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.persistence.SafePersistenceWrappers;
import com.tangosol.persistence.Snapshot;
import com.tangosol.persistence.SnapshotArchiver;
import com.tangosol.util.Binary;
import com.tangosol.util.ListMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.WrapperException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class PartitionedService$PersistenceControl
extends Component {
    private Continuation __m_ActiveFailureHandler;
    private int __m_ActiveFailureMode;
    private PersistenceManager __m_ActiveManager;
    private transient AtomicInteger __m_ActiveRecoveryRequests;
    private boolean __m_Async;
    private volatile boolean __m_Disabled;
    private boolean __m_ForceRecovery;
    private PartitionVersionExclusionList __m_PartitionVersionExclusionList;
    private PersistenceEnvironment __m_PersistenceEnvironment;
    private volatile Binary __m_QuorumRaw;
    private boolean __m_ResumeOnFailover;
    private SnapshotArchiver __m_SnapshotArchiver;
    private PartitionedService$PersistenceControl$SnapshotController __m_SnapshotController;
    private long __m_StatsLatencyCount;
    private long __m_StatsLatencyMax;
    private long __m_StatsLatencyTotal;
    private static ListMap __mapChildren;

    static {
        PartitionedService$PersistenceControl.__initStatic();
    }

    public PartitionedService$PersistenceControl() {
        this(null, null, true);
    }

    public PartitionedService$PersistenceControl(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setActiveRecoveryRequests(new AtomicInteger());
            this.setPartitionVersionExclusionList(new PartitionVersionExclusionList());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("SnapshotBuilder", PartitionedService$PersistenceControl$SnapshotBuilder.get_CLASS());
        Class clazz2 = __mapChildren.put("SnapshotController", PartitionedService$PersistenceControl$SnapshotController.get_CLASS());
    }

    public void add(Object o) {
    }

    public void archiveOperation(PartitionedService$SnapshotArchiveRequest msgRequest, boolean fArchive) {
        String sDesc = fArchive ? "archive" : "retrieve";
        PartitionedService service = (PartitionedService)this.get_Module();
        Grid$Response msgResponse = (Grid$Response)service.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        msgResponse.setResult(SimpleResponse.RESULT_SUCCESS);
        if (this.isValid() ^ true) {
            Component._trace("Service is not configured for persistence", 2);
            msgResponse.setResult(SimpleResponse.RESULT_FAILURE);
            service.send(msgResponse);
            return;
        }
        String sSnapshot = msgRequest.getSnapshotName();
        Map mapStores = msgRequest.getStores();
        Object[] aoStores = (Object[])mapStores.get(service.getThisMember().getId());
        if (aoStores == null ? true : aoStores.length == 0) {
            throw new IllegalArgumentException("Did not receive any stores to archive");
        }
        String[] asStores = new String[aoStores.length];
        int i = 0;
        while (i < aoStores.length) {
            asStores[i] = aoStores[i].toString();
            ++i;
        }
        Component._trace(new StringBuilder(String.valueOf("Received request to ")).append(sDesc).append(" ").append(asStores.length).append(" stores for snapshot \"").append(sSnapshot).append("\"").toString(), 3);
        try {
            SnapshotArchiver archiver = this.getSnapshotArchiver();
            if (archiver == null) {
                throw new IllegalStateException("No archiver is defined for this service");
            }
            Snapshot snapshot = new Snapshot(sSnapshot, asStores);
            if (fArchive) {
                archiver.archive(snapshot, this.getPersistenceEnvironment());
            } else {
                archiver.retrieve(snapshot, this.getPersistenceEnvironment());
            }
        }
        catch (Exception e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to ")).append(sDesc).append(" persistent snapshot: ").append(Component.getStackTrace(e)).toString(), 2);
            msgResponse.setResult(SimpleResponse.RESULT_FAILURE);
        }
        service.send(msgResponse);
    }

    public void createSnapshot(PartitionedService$SnapshotRequest msgRequest) {
        PersistenceManager mgrSnapshot;
        PartitionedService service = (PartitionedService)this.get_Module();
        Grid$Response msgResponse = (Grid$Response)service.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        msgResponse.setResult(SimpleResponse.RESULT_SUCCESS);
        if (this.isValid() ^ true) {
            Component._trace("Service is not configured for persistent snapshot creation.", 2);
            msgResponse.setResult(SimpleResponse.RESULT_FAILURE);
            service.send(msgResponse);
            return;
        }
        PartitionSet parts = service.collectOwnedPartitions(true);
        PartitionSet partsMask = msgRequest.getRequestMask();
        if (partsMask != null) {
            parts.retain(partsMask);
        }
        if (parts.isEmpty()) {
            service.send(msgResponse);
            return;
        }
        String sSnapshot = msgRequest.getSnapshotName();
        try {
            mgrSnapshot = this.getPersistenceEnvironment().createSnapshot(sSnapshot);
        }
        catch (PersistenceException e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to create persistent snapshot: ")).append(Component.getStackTrace(e)).toString(), 2);
            msgResponse.setResult(SimpleResponse.RESULT_FAILURE);
            service.send(msgResponse);
            return;
        }
        Component._trace(new StringBuilder(String.valueOf("Creating snapshot \"")).append(sSnapshot).append("\" of partitions ").append(parts).append(" using ").append(mgrSnapshot).toString(), 3);
        PartitionedService$PersistenceControl$SnapshotBuilder builder = (PartitionedService$PersistenceControl$SnapshotBuilder)this._newChild("SnapshotBuilder");
        builder.setManager(mgrSnapshot);
        builder.setResponse(msgResponse);
        builder.setPartitions(parts);
        builder.build(0);
    }

    public Continuation getActiveFailureHandler() {
        return this.__m_ActiveFailureHandler;
    }

    public int getActiveFailureMode() {
        return this.__m_ActiveFailureMode;
    }

    public PersistenceManager getActiveManager() {
        return this.__m_ActiveManager;
    }

    public AtomicInteger getActiveRecoveryRequests() {
        return this.__m_ActiveRecoveryRequests;
    }

    public String getMBeanName() {
        return null;
    }

    protected PartitionVersionExclusionList getPartitionVersionExclusionList() {
        return this.__m_PartitionVersionExclusionList;
    }

    public PersistenceEnvironment getPersistenceEnvironment() {
        return this.__m_PersistenceEnvironment;
    }

    public Binary getQuorumRaw() {
        return this.__m_QuorumRaw;
    }

    public SnapshotArchiver getSnapshotArchiver() {
        return this.__m_SnapshotArchiver;
    }

    public PartitionedService$PersistenceControl$SnapshotController getSnapshotController() {
        return this.__m_SnapshotController;
    }

    public long getStatsLatencyCount() {
        return this.__m_StatsLatencyCount;
    }

    public long getStatsLatencyMax() {
        return this.__m_StatsLatencyMax;
    }

    public long getStatsLatencyTotal() {
        return this.__m_StatsLatencyTotal;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PersistenceControl".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PartitionedService$PersistenceControl();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isAllowed(String sGUID) {
        return this.getPartitionVersionExclusionList().isAllowed(GUIDHelper.getPartition(sGUID), (int)GUIDHelper.getVersion(sGUID));
    }

    public boolean isAsync() {
        return this.__m_Async;
    }

    public boolean isDisabled() {
        return this.__m_Disabled;
    }

    public boolean isForceRecovery() {
        return this.__m_ForceRecovery;
    }

    public boolean isResumeOnFailover() {
        return this.__m_ResumeOnFailover;
    }

    public boolean isValid() {
        return this.getPersistenceEnvironment() != null;
    }

    public void onActivePersistenceFailure(PersistenceException e) {
        if (this.isDisabled() ^ true) {
            PartitionedService service = (PartitionedService)this.get_Module();
            PersistentStore<?> store = e.getPersistentStore();
            int nPartition = GUIDHelper.getPartition(store.getId());
            PartitionedService$PartitionControl ctrl = service.getPartitionControl(nPartition);
            int nLockState = ctrl.getLockType();
            if (!ctrl.isLocked() ? false : nLockState == PartitionedService$PartitionControl.LOCK_PERSISTENCE) {
                throw e;
            }
            switch (this.getActiveFailureMode()) {
                case 0: {
                    Component._trace(new StringBuilder(String.valueOf("Stopping service due to an unexpected persistence exception: ")).append(Component.getStackTrace(e)).toString(), 1);
                    service.stop();
                    break;
                }
                case 1: {
                    Component._trace(new StringBuilder(String.valueOf("Disabling active persistence due to an unexpected persistence exception: ")).append(Component.getStackTrace(e)).toString(), 1);
                    this.setActiveManager(NullImplementation.getPersistenceManager());
                    PartitionSet parts = service.collectOwnedPartitions(true);
                    int iPart = parts.next(0);
                    while (iPart >= 0) {
                        service.getPartitionControl(iPart).disablePersistentStore();
                        iPart = parts.next(iPart + 1);
                    }
                    break;
                }
            }
            this.setDisabled(true);
        }
    }

    public void onInit() {
        PartitionedService service = (PartitionedService)this.get_Module();
        PartitionedService$Continuations contHelper = service.getContinuations();
        this.setActiveFailureHandler(contHelper.instantiatePersistenceErrorHandler(contHelper.instantiateActivePersistenceError()));
    }

    public void onMembershipChanged(int nMemberEvent) {
        PartitionedService$PersistenceControl$SnapshotController ctrlSnapshot = this.getSnapshotController();
        if (ctrlSnapshot != null) {
            ctrlSnapshot.setSnapshotNames(null);
        }
    }

    public void onOwnershipSeniority() {
        if (this.isValid()) {
            this.setSnapshotController((PartitionedService$PersistenceControl$SnapshotController)this._newChild("SnapshotController"));
        }
    }

    public synchronized void onPrimaryOwnershipChanged(int iPartition) {
        this.getPartitionVersionExclusionList().reset(iPartition);
    }

    public void onServiceResume() {
        this.setResumeOnFailover(false);
    }

    public void onServiceSuspend(boolean fAutoResume) {
        if (fAutoResume) {
            this.setResumeOnFailover(true);
        }
    }

    public synchronized void onTransientException(String sGUID) {
        this.getPartitionVersionExclusionList().exclude(GUIDHelper.getPartition(sGUID), (int)GUIDHelper.getVersion(sGUID));
    }

    public PersistenceManager openActiveManager() {
        PersistenceEnvironment env = this.getPersistenceEnvironment();
        PersistenceManager mgrActive = this.getActiveManager();
        if (!(env != null) ? false : mgrActive == null) {
            mgrActive = env.openActive();
            this.setActiveManager(mgrActive);
        }
        return mgrActive;
    }

    public PersistentStore openActiveStore(String sGUID, PersistentStore storeFrom) {
        try {
            return new SafePersistenceWrappers.SafePersistentStore(this.getActiveManager().open(sGUID, storeFrom), this.getActiveFailureHandler());
        }
        catch (PersistenceException e) {
            this.onActivePersistenceFailure(e);
            return NullImplementation.getPersistentStore();
        }
    }

    public PersistenceManager openSnapshot(String sSnapshot) {
        PersistenceManager mgr = null;
        try {
            mgr = this.getPersistenceEnvironment().openSnapshot(sSnapshot);
        }
        catch (PersistenceException e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to recover from snapshot \"")).append(sSnapshot).append("\": ").append(Component.getStackTrace(e)).toString(), 2);
        }
        return mgr;
    }

    public void recordLatencyStats(long cMillis) {
        this.setStatsLatencyTotal(this.getStatsLatencyTotal() + cMillis);
        this.setStatsLatencyCount(this.getStatsLatencyCount() + (long)1);
        if (cMillis > this.getStatsLatencyMax()) {
            this.setStatsLatencyMax(cMillis);
        }
    }

    public void release() {
        PersistenceManager mgr;
        PartitionedService$PersistenceControl$SnapshotController ctrlSnapshot = this.getSnapshotController();
        if (ctrlSnapshot != null) {
            ctrlSnapshot.release();
            this.setSnapshotController(null);
        }
        if ((mgr = this.getActiveManager()) != null) {
            mgr.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeSnapshot(PartitionedService$SnapshotRequest msgRequest) {
        PartitionedService service = (PartitionedService)this.get_Module();
        Grid$Response msgResponse = (Grid$Response)service.instantiateMessage("Response");
        msgResponse.respondTo(msgRequest);
        msgResponse.setResult(SimpleResponse.RESULT_SUCCESS);
        if (this.isValid() ^ true) {
            Component._trace("Service is not configured for persistent snapshot removal.", 2);
            msgResponse.setResult(SimpleResponse.RESULT_FAILURE);
            service.send(msgResponse);
            return;
        }
        String sSnapshot = msgRequest.getSnapshotName();
        try {
            if (!(this.getPersistenceEnvironment().removeSnapshot(sSnapshot) ^ true)) {
                // empty if block
            }
        }
        catch (PersistenceException e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to remove persistent snapshot \"")).append(sSnapshot).append("\" : ").append(Component.getStackTrace(e)).toString(), 2);
            msgResponse.setResult(SimpleResponse.RESULT_FAILURE);
        }
        service.send(msgResponse);
    }

    public void resetStats() {
        this.setStatsLatencyMax(0L);
        this.setStatsLatencyCount(0L);
        this.setStatsLatencyTotal(0L);
    }

    public void retrieveSnapshot(PartitionedService$SnapshotArchiveRequest msgRequest) {
    }

    protected void setActiveFailureHandler(Continuation cont) {
        this.__m_ActiveFailureHandler = cont;
    }

    public void setActiveFailureMode(int nMode) {
        this.__m_ActiveFailureMode = nMode;
    }

    protected void setActiveManager(PersistenceManager mgr) {
        this.__m_ActiveManager = mgr;
    }

    protected void setActiveRecoveryRequests(AtomicInteger atomicRecoverRequests) {
        this.__m_ActiveRecoveryRequests = atomicRecoverRequests;
    }

    public void setAsync(boolean fAsync) {
        this.__m_Async = fAsync;
    }

    protected void setDisabled(boolean fDisabled) {
        this.__m_Disabled = fDisabled;
    }

    public void setForceRecovery(boolean fRecovery) {
        this.__m_ForceRecovery = fRecovery;
    }

    protected void setPartitionVersionExclusionList(PartitionVersionExclusionList storage) {
        this.__m_PartitionVersionExclusionList = storage;
    }

    public void setPersistenceEnvironment(PersistenceEnvironment env) {
        Component._assert(this.getPersistenceEnvironment() == null, "Environment is not resettable");
        this.__m_PersistenceEnvironment = env;
    }

    public void setQuorumRaw(Binary binRaw) {
        this.__m_QuorumRaw = binRaw;
    }

    protected void setResumeOnFailover(boolean fFailover) {
        this.__m_ResumeOnFailover = fFailover;
    }

    public void setSnapshotArchiver(SnapshotArchiver archiverSnapshot) {
        this.__m_SnapshotArchiver = archiverSnapshot;
    }

    protected void setSnapshotController(PartitionedService$PersistenceControl$SnapshotController controller) {
        this.__m_SnapshotController = controller;
    }

    protected void setStatsLatencyCount(long cStats) {
        this.__m_StatsLatencyCount = cStats;
    }

    protected void setStatsLatencyMax(long cMillisMax) {
        this.__m_StatsLatencyMax = cMillisMax;
    }

    protected void setStatsLatencyTotal(long cMillisTotal) {
        this.__m_StatsLatencyTotal = cMillisTotal;
    }
}

