/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.persistence.AsyncPersistenceException;
import com.oracle.coherence.persistence.PersistenceException;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.BackupRequest;
import com.tangosol.coherence.component.util.PartialJob;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$PartitionControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$PersistenceControl;
import com.tangosol.internal.tracing.Span;
import com.tangosol.util.Base;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class PartitionedCache$BatchContext
extends Component
implements Collector {
    private Set __m_EntryInfos;
    private Set __m_EntryInfosOOB;
    private Object __m_Events;
    private long __m_LastBackupCompletedTime;
    private AtomicInteger __m_OutstandingOperationCounter;
    private Span __m_PersistenceTracingSpan;
    private Message __m_PrimaryResponse;
    private SparseArray __m_SkipCompleteArray;

    public PartitionedCache$BatchContext() {
        this(null, null, true);
    }

    public PartitionedCache$BatchContext(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLastBackupCompletedTime(-1L);
            this.setSkipCompleteArray(new SparseArray());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public synchronized void accumulateEntryInfos(Set setInfo, boolean fOOB) {
        Set set = fOOB ? this.getEntryInfosOOB() : this.getEntryInfos();
        if (set == null) {
            set = setInfo;
        } else {
            set.addAll(setInfo);
        }
        if (fOOB) {
            this.setEntryInfosOOB(set);
        } else {
            this.setEntryInfos(set);
        }
    }

    public void add(Object oValue) {
        Span span;
        PartitionedCache$PartitionControl ctrlPartition;
        PartitionedCache service = (PartitionedCache)this.get_Module();
        PartitionedCache$PersistenceControl ctrlPersistence = (PartitionedCache$PersistenceControl)service.getPersistenceControl();
        if (oValue instanceof PartitionedCache$PartitionControl) {
            ctrlPartition = (PartitionedCache$PartitionControl)oValue;
        } else {
            String sGUIDCurrent;
            String sGUIDFailed;
            AsyncPersistenceException eAsync = (AsyncPersistenceException)oValue;
            ctrlPartition = (PartitionedCache$PartitionControl)eAsync.getReceipt();
            int iPart = ctrlPartition.getPartitionId();
            if (service.isPrimaryOwner(iPart) && (sGUIDFailed = eAsync.getPersistentStore().getId()).equals(sGUIDCurrent = service.getPartitionControl(iPart).getPersistentStore().getId())) {
                ctrlPersistence.onActivePersistenceFailure(new PersistenceException(new StringBuilder(String.valueOf("Asynchronous persistence operation failed for partition ")).append(iPart).toString(), eAsync));
            }
        }
        ctrlPartition.finishPersist();
        long cLatency = 0L;
        if (this.isCompleteOnPersist(ctrlPartition.getPartitionId())) {
            if (this.tryBatchCompletion()) {
                cLatency = Base.getSafeTimeMillis() - this.getLastBackupCompletedTime();
            }
            ctrlPersistence.recordLatencyStats(cLatency);
        }
        if ((span = this.getPersistenceTracingSpan()) != null) {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completeOnPersist(boolean fSync, int nPartition) {
        Boolean FSkipComplete;
        SparseArray laSkipComplete;
        SparseArray sparseArray = laSkipComplete = this.getSkipCompleteArray();
        synchronized (sparseArray) {
            FSkipComplete = (Boolean)laSkipComplete.get(nPartition);
            if (FSkipComplete == null) {
                FSkipComplete = fSync ^ true;
                laSkipComplete.set(nPartition, FSkipComplete);
            }
        }
        return FSkipComplete ^ true;
    }

    public void flush() {
        ((PartitionedCache)this.get_Module()).flush();
    }

    public Set getEntryInfos() {
        return this.__m_EntryInfos;
    }

    public Set getEntryInfosOOB() {
        return this.__m_EntryInfosOOB;
    }

    public Object getEvents() {
        return this.__m_Events;
    }

    public long getLastBackupCompletedTime() {
        return this.__m_LastBackupCompletedTime;
    }

    public AtomicInteger getOutstandingOperationCounter() {
        return this.__m_OutstandingOperationCounter;
    }

    public Span getPersistenceTracingSpan() {
        return this.__m_PersistenceTracingSpan;
    }

    public Message getPrimaryResponse() {
        return this.__m_PrimaryResponse;
    }

    public SparseArray getSkipCompleteArray() {
        return this.__m_SkipCompleteArray;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$BatchContext".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedCache$BatchContext();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isCompleteOnPersist(int nPartition) {
        SparseArray laSkipComplete;
        SparseArray sparseArray = laSkipComplete = this.getSkipCompleteArray();
        synchronized (sparseArray) {
            Boolean FSkipComplete = (Boolean)laSkipComplete.get(nPartition);
            boolean bl = FSkipComplete == null ? true : FSkipComplete ^ true;
            return bl;
        }
    }

    public void onBackupCompleted(BackupRequest msgBackup) {
        if (!this.tryBatchCompletion() && msgBackup.isSyncMsg()) {
            this.setLastBackupCompletedTime(Base.getSafeTimeMillis());
        }
    }

    protected void onCompleted() {
    }

    public void onJobCompleted(PartialJob job) {
        this.tryBatchCompletion();
    }

    public void setEntryInfos(Set setInfos) {
        this.__m_EntryInfos = setInfos;
    }

    public void setEntryInfosOOB(Set setB) {
        this.__m_EntryInfosOOB = setB;
    }

    public void setEvents(Object oEvents) {
        this.__m_Events = oEvents;
    }

    public void setLastBackupCompletedTime(long ldtTime) {
        this.__m_LastBackupCompletedTime = ldtTime;
    }

    public void setOutstandingOperationCounter(AtomicInteger atomic) {
        this.__m_OutstandingOperationCounter = atomic;
    }

    public void setPersistenceTracingSpan(Span spanTracing) {
        this.__m_PersistenceTracingSpan = spanTracing;
    }

    public void setPrimaryResponse(Message msgResponse) {
        this.__m_PrimaryResponse = msgResponse;
    }

    public void setSkipCompleteArray(SparseArray arrayComplete) {
        this.__m_SkipCompleteArray = arrayComplete;
    }

    protected boolean tryBatchCompletion() {
        PartitionedCache service;
        if (this.getOutstandingOperationCounter().decrementAndGet() == 0 && (service = (PartitionedCache)this.get_Module()).getServiceState() != Service.SERVICE_STOPPED) {
            service.dispatchServerEvents(this.getEntryInfos(), this.getEntryInfosOOB());
            service.publishToClients(this.getPrimaryResponse(), this.getEvents());
            return true;
        }
        return false;
    }
}

