/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.RequestContext;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.WrapperContext;
import com.tangosol.coherence.component.util.WrapperContext$StorageContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$EventsHelper;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$InvocationContext$StorageContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$ResourceCoordinator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage$BinaryEntry;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage$EntryStatus;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.util.ConversionHelper;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.security.StorageAccessAuthorizer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ChainedCollection;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class PartitionedCache$InvocationContext
extends WrapperContext {
    protected static final int MAX_ATTEMPTS = 15;
    private int __m_AccessGranted;
    private int __m_AccessReason;
    private PartitionedCache$Storage __m_AccessStorage;
    private Subject __m_AccessSubject;
    private boolean __m_Active;
    private boolean __m_AllowReadThrough;
    private transient int __m_Attempt;
    private boolean __m_Committed;
    private Map __m_EnlistedStatuses;
    private Set __m_LockedStorage;
    private PartitionSet __m_PinnedPartitions;
    private boolean __m_ReadOnlyRequest;
    private Map __m_StorageEntries;
    private Map __m_StorageStatusMap;
    private static ListMap __mapChildren;

    static {
        PartitionedCache$InvocationContext.__initStatic();
    }

    public PartitionedCache$InvocationContext() {
        this(null, null, true);
    }

    public PartitionedCache$InvocationContext(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAllowReadThrough(true);
            this.setLockedStorage(new LiteSet());
            this.setStorageMap(new LiteMap());
            this.setStorageStatusMap(new LiteMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("StorageContext", PartitionedCache$InvocationContext$StorageContext.get_CLASS());
    }

    protected static void checkSlidingExpiry(PartitionedCache$Storage storage, PartitionedCache$Storage$EntryStatus status, PartitionedCache$Storage$BinaryEntry entry) {
        if (!(entry.isValueChanged() ^ true) ? false : storage.isExpirySliding()) {
            block3: {
                status.setPending(true);
                try {
                    if (!(status.isAnyAction() ^ true)) break block3;
                    entry.expire(storage.getBackingConfigurableCache().getExpiryDelay());
                    status.setExpiryOnly(true);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    status.setPending(false);
                    throw throwable;
                }
            }
            Object var4_3 = null;
            status.setPending(false);
        }
    }

    protected void clearStatuses() {
        PartitionedCache service = this.getService();
        Set setLockedStorage = this.getLockedStorage();
        Map mapStorageStatus = this.getStorageStatusMap();
        Iterator iter = mapStorageStatus.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            PartitionedCache$Storage storage = (PartitionedCache$Storage)entry.getKey();
            Map mapKeyStatus = (Map)entry.getValue();
            if (!(setLockedStorage.contains(storage) ^ true)) continue;
            Iterator iterStatus = mapKeyStatus.values().iterator();
            while (iterStatus.hasNext()) {
                PartitionedCache$Storage$EntryStatus status = (PartitionedCache$Storage$EntryStatus)iterStatus.next();
                service.unlockKey(storage, status.getKey(), false);
            }
        }
        mapStorageStatus.clear();
    }

    protected Map createEntryView(Map mapStatuses) {
        Converter convNull = NullImplementation.getConverter();
        Converter convUp = this.getService().getBinaryEntryConverter();
        return ConverterCollections.getMap(mapStatuses, convNull, convNull, ConversionHelper.getCollectionConverter(convUp, convNull), convNull);
    }

    public PartitionedCache$Storage$EntryStatus enlistSynthetic(PartitionedCache$Storage storage, Binary binKey) {
        Map mapStorage = this.getStorageStatusMap();
        LiteMap<Binary, PartitionedCache$Storage$EntryStatus> mapKeyStatus = (LiteMap<Binary, PartitionedCache$Storage$EntryStatus>)mapStorage.get(storage);
        PartitionedCache$Storage$EntryStatus status = mapKeyStatus == null ? null : (PartitionedCache$Storage$EntryStatus)mapKeyStatus.get(binKey);
        if (status == null) {
            status = this.getService().getResourceCoordinator().ensureStatus(storage, binKey);
            status.setManaged(true);
            if (mapKeyStatus == null) {
                mapKeyStatus = new LiteMap<Binary, PartitionedCache$Storage$EntryStatus>();
                mapStorage.put(storage, mapKeyStatus);
            }
            mapKeyStatus.put(binKey, status);
            status.setBinaryEntry(storage.instantiateBinaryEntry(binKey, null, false));
        }
        return status;
    }

    public int getAccessGranted() {
        return this.__m_AccessGranted;
    }

    public int getAccessReason() {
        return this.__m_AccessReason;
    }

    public PartitionedCache$Storage getAccessStorage() {
        return this.__m_AccessStorage;
    }

    public Subject getAccessSubject() {
        return this.__m_AccessSubject;
    }

    protected int getAttempt() {
        return this.__m_Attempt;
    }

    protected Map getEnlistedStatuses() {
        return this.__m_EnlistedStatuses;
    }

    public PartitionedCache$Storage$EntryStatus getEntryStatus(PartitionedCache$Storage storage, Binary binKey) {
        Map mapStatuses = (Map)this.getStorageStatusMap().get(storage);
        return mapStatuses == null ? null : (PartitionedCache$Storage$EntryStatus)mapStatuses.get(binKey);
    }

    public Collection getEntryStatuses() {
        Collection collMaps = this.getStorageStatusMap().values();
        if (collMaps.size() == 1) {
            Map mapStatus = (Map)collMaps.iterator().next();
            return mapStatus.values();
        }
        return new ChainedCollection(ConverterCollections.getCollection(collMaps, ConversionHelper.getMapValuesConverter(), NullImplementation.getConverter()));
    }

    protected Set getLockedStorage() {
        return this.__m_LockedStorage;
    }

    public PartitionSet getPinnedPartitions() {
        PartitionSet parts = this.__m_PinnedPartitions;
        if (parts == null) {
            parts = new PartitionSet(this.getService().getPartitionCount());
            this.setPinnedPartitions(parts);
        }
        return parts;
    }

    public PartitionedCache getService() {
        return (PartitionedCache)this.get_Module();
    }

    public PartitionedCache$Storage getStorage(String sCacheName) {
        return ((PartitionedCache)this.get_Module()).getStorage(sCacheName);
    }

    protected Map getStorageEntries() {
        return this.__m_StorageEntries;
    }

    public Map getStorageStatusMap() {
        return this.__m_StorageStatusMap;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$InvocationContext".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PartitionedCache$InvocationContext();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean hasEntriesEnlisted(PartitionedCache$Storage storage) {
        Map mapStatuses = (Map)this.getStorageStatusMap().get(storage);
        return !(mapStatuses != null) ? false : mapStatuses.isEmpty() ^ true;
    }

    public boolean hasEntryEnlisted(PartitionedCache$Storage storage, Binary binKey) {
        Map mapStatuses = (Map)this.getStorageStatusMap().get(storage);
        return !(mapStatuses != null) ? false : mapStatuses.containsKey(binKey);
    }

    public void initialize() {
        Converter convNull = NullImplementation.getConverter();
        PartitionedCache service = this.getService();
        ConverterCollections.ConverterMap mapStorageEntries = ConverterCollections.getMap(this.getStorageStatusMap(), convNull, convNull, ConversionHelper.getMapValuesConverter(service.getBinaryEntryConverter(), convNull), convNull);
        this.setStorageEntries(mapStorageEntries);
        this.setPrePinnedPartitions(new PartitionSet(service.getPartitionCount()));
    }

    protected WrapperContext$StorageContext instantiateStorageContext(PartitionedCache$Storage storage) {
        PartitionedCache$InvocationContext$StorageContext ctx = new PartitionedCache$InvocationContext$StorageContext();
        this._linkChild(ctx);
        ctx.setStorage(storage);
        return ctx;
    }

    public boolean isActive() {
        return this.__m_Active;
    }

    public boolean isAllowReadThrough() {
        return this.__m_AllowReadThrough;
    }

    public boolean isCommitted() {
        return this.__m_Committed;
    }

    public boolean isReadOnly() {
        return this.isReadOnlyRequest() ? true : this.isCommitted();
    }

    public boolean isReadOnlyRequest() {
        return this.__m_ReadOnlyRequest;
    }

    public PartitionedCache$Storage$EntryStatus[] lockEntries(PartitionedCache$Storage storage, Binary[] aKeys, int cSize) {
        Map mapStorage = this.getStorageStatusMap();
        LiteMap<Binary, PartitionedCache$Storage$EntryStatus> mapKeyStatus = (LiteMap<Binary, PartitionedCache$Storage$EntryStatus>)mapStorage.get(storage);
        PartitionedCache service = this.getService();
        PartitionedCache$ResourceCoordinator coordinator = service.getResourceCoordinator();
        PartitionedCache$Storage$EntryStatus[] aStatus = new PartitionedCache$Storage$EntryStatus[cSize];
        if (mapKeyStatus == null) {
            mapKeyStatus = new LiteMap<Binary, PartitionedCache$Storage$EntryStatus>();
            mapStorage.put(storage, mapKeyStatus);
        }
        int i = 0;
        while (i < cSize) {
            Binary binKey = aKeys[i];
            service.lockKey(storage, binKey, false);
            PartitionedCache$Storage$EntryStatus status = coordinator.getStatus(storage, binKey);
            Component._assert(!(status != null) ? false : status.getBinaryEntry() == null);
            mapKeyStatus.put(binKey, status);
            status.setBinaryEntry(storage.instantiateBinaryEntry(binKey, null, false));
            aStatus[i] = status;
            ++i;
        }
        return aStatus;
    }

    public PartitionedCache$Storage$EntryStatus lockEntry(PartitionedCache$Storage storage, PartitionedCache$Storage$BinaryEntry binEntry, boolean fEnter) {
        Map mapStorage = this.getStorageStatusMap();
        LiteMap<Binary, PartitionedCache$Storage$EntryStatus> mapKeyStatus = (LiteMap<Binary, PartitionedCache$Storage$EntryStatus>)mapStorage.get(storage);
        Binary binKey = binEntry.getBinaryKey();
        PartitionedCache service = this.getService();
        PartitionSet partsPinned = this.getPinnedPartitions();
        PartitionedCache$Storage$EntryStatus status = mapKeyStatus == null ? null : (PartitionedCache$Storage$EntryStatus)mapKeyStatus.get(binKey);
        int nPartition = status == null ? this.getKeyPartition(binKey) : status.getPartition();
        fEnter = !fEnter ? false : partsPinned.contains(nPartition) ^ true;
        if (!(status == null) ? false : service.lockKey(storage, binKey, fEnter)) {
            if (fEnter ? true : service.isConcurrent() ^ true) {
                partsPinned.add(nPartition);
            }
            Component._assert(!((status = service.getResourceCoordinator().getStatus(storage, binKey)) != null) ? false : status.getBinaryEntry() == null);
            if (mapKeyStatus == null) {
                mapKeyStatus = new LiteMap<Binary, PartitionedCache$Storage$EntryStatus>();
                mapStorage.put(storage, mapKeyStatus);
            }
            mapKeyStatus.put(binKey, status);
            status.setBinaryEntry(binEntry);
            Map mapEnlisted = this.getEnlistedStatuses();
            if (mapEnlisted != null) {
                LiteSet<PartitionedCache$Storage$EntryStatus> setStatus = (LiteSet<PartitionedCache$Storage$EntryStatus>)mapEnlisted.get(storage);
                if (setStatus == null) {
                    setStatus = new LiteSet<PartitionedCache$Storage$EntryStatus>();
                    mapEnlisted.put(storage, setStatus);
                }
                setStatus.add(status);
            }
        }
        return status;
    }

    public PartitionedCache$Storage$EntryStatus lockEntry(PartitionedCache$Storage storage, Binary binKey, boolean fEnter) {
        return this.lockEntry(storage, storage.instantiateBinaryEntry(binKey, null, false), fEnter);
    }

    public void lockStorage(PartitionedCache$Storage storage) {
        this.getService().getResourceCoordinator().lockAll(storage, -1L);
        this.getLockedStorage().add(storage);
    }

    public void markCommitted() {
        this.setCommitted(true);
    }

    public void markReadOnlyRequest() {
        this.setReadOnlyRequest(true);
    }

    public void postInvoke() {
        this.postInvokeAll(this.getEntryStatuses());
    }

    public void postInvokeAll(Collection colEntries) {
        int cEntries = colEntries.size();
        if (cEntries == 0) {
            return;
        }
        if (cEntries == 1) {
            PartitionedCache$Storage$EntryStatus status = (PartitionedCache$Storage$EntryStatus)colEntries.iterator().next();
            PartitionedCache$Storage$BinaryEntry entry = status.getBinaryEntry();
            if (entry != null) {
                PartitionedCache$Storage storage = entry.getStorage();
                PartitionedCache$InvocationContext.checkSlidingExpiry(storage, status, entry);
                storage.postInvoke(entry);
            }
            return;
        }
        HashMap<PartitionedCache$Storage, LinkedList<PartitionedCache$Storage$BinaryEntry>> mapStorage = new HashMap<PartitionedCache$Storage, LinkedList<PartitionedCache$Storage$BinaryEntry>>(cEntries);
        Iterator iterEntries = colEntries.iterator();
        while (iterEntries.hasNext()) {
            PartitionedCache$Storage$EntryStatus status = (PartitionedCache$Storage$EntryStatus)iterEntries.next();
            PartitionedCache$Storage$BinaryEntry entry = status.getBinaryEntry();
            if (!(entry != null)) continue;
            PartitionedCache$Storage storage = entry.getStorage();
            PartitionedCache$InvocationContext.checkSlidingExpiry(storage, status, entry);
            LinkedList<PartitionedCache$Storage$BinaryEntry> listEntries = (LinkedList<PartitionedCache$Storage$BinaryEntry>)mapStorage.get(storage);
            if (listEntries == null) {
                listEntries = new LinkedList<PartitionedCache$Storage$BinaryEntry>();
                mapStorage.put(storage, listEntries);
            }
            listEntries.add(entry);
        }
        Iterator iter = mapStorage.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ((PartitionedCache$Storage)entry.getKey()).postInvokeAll((List)entry.getValue());
        }
    }

    public void prepareAccess(RequestContext context, PartitionedCache$Storage storage, int nAccessRequired, int nReason) {
        StorageAccessAuthorizer authorizer = storage.getAccessAuthorizer();
        if (authorizer != null) {
            if (nAccessRequired != 0) {
                storage.checkAccess(context, nAccessRequired, nReason);
            }
            this.setAccessSubject(context == null ? null : context.getSubject());
            this.setAccessStorage(storage);
            this.setAccessReason(nReason);
            this.setAccessGranted(nAccessRequired);
        }
    }

    public Set processInterceptors() {
        return this.processInterceptors(this.getStorageEntries());
    }

    public Set processInterceptors(Map mapStorageEntries) {
        PartitionedCache$EventsHelper evtHelper = this.getService().getEventsHelper();
        LiteSet setEnlisted = null;
        try {
            boolean fPrecommit = true;
            Map mapEnlistedEntries = mapStorageEntries;
            LiteMap mapEnlistedStatuses = null;
            LiteMap mapEnlistedExtra = null;
            while (true) {
                Iterator iterStorage = mapEnlistedEntries.entrySet().iterator();
                while (iterStorage.hasNext()) {
                    Map.Entry entry = iterStorage.next();
                    PartitionedCache$Storage storage = (PartitionedCache$Storage)entry.getKey();
                    if (storage.getTriggerSet() != null ? true : evtHelper.hasPreCommitInterceptors(storage)) {
                        if (setEnlisted == null) {
                            setEnlisted = new LiteSet();
                            mapEnlistedExtra = new LiteMap();
                            this.setEnlistedStatuses(mapEnlistedExtra);
                        }
                        Collection colEntry = (Collection)entry.getValue();
                        storage.processInterceptors(colEntry);
                    }
                    if (!(mapEnlistedStatuses != null)) continue;
                    setEnlisted.addAll((Collection)mapEnlistedStatuses.get(storage));
                }
                if (mapEnlistedExtra == null) break;
                if (mapEnlistedExtra.isEmpty()) {
                    if (!fPrecommit) break;
                    evtHelper.onTransactionPreCommit(this.getEntryStatuses());
                    if (mapEnlistedExtra.isEmpty()) break;
                    fPrecommit = false;
                }
                mapEnlistedStatuses = mapEnlistedExtra;
                mapEnlistedEntries = this.createEntryView(mapEnlistedStatuses);
                mapEnlistedExtra = new LiteMap();
                this.setEnlistedStatuses(mapEnlistedExtra);
            }
            Object var5_6 = null;
            this.setEnlistedStatuses(null);
            this.markCommitted();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.setEnlistedStatuses(null);
            this.markCommitted();
            throw throwable;
        }
        return setEnlisted == null ? Collections.EMPTY_SET : setEnlisted;
    }

    public void release(boolean fUnpin) {
        this.setAttempt(0);
        this.clearStatuses();
        this.setActive(false);
        this.setReadOnlyRequest(false);
        this.setAllowReadThrough(true);
        this.setCommitted(false);
        this.getStorageMap().clear();
        PartitionedCache$ResourceCoordinator coordinator = this.getService().getResourceCoordinator();
        Set setLockedStorage = this.getLockedStorage();
        Iterator iter = setLockedStorage.iterator();
        while (iter.hasNext()) {
            coordinator.unlockAll((PartitionedCache$Storage)iter.next());
        }
        setLockedStorage.clear();
        PartitionSet partsPinned = this.getPinnedPartitions();
        if (fUnpin) {
            this.getService().unpinPartitions(partsPinned);
        }
        PartitionSet partsPinnedPre = this.getPrePinnedPartitions();
        Span span = TracingHelper.getActiveSpan();
        if (TracingHelper.isNoop(span) ^ true) {
            partsPinned.add(partsPinnedPre);
            span.setMetadata("partitions", partsPinned.toString(false));
        }
        partsPinned.clear();
        partsPinnedPre.clear();
    }

    public void resetAccess() {
        this.setAccessSubject(null);
        this.setAccessStorage(null);
        this.setAccessGranted(0);
        this.setAccessReason(0);
    }

    public void rollback(RuntimeException e, RequestMessage msgRequest) {
        this.rollback(e, msgRequest, "");
    }

    public void rollback(RuntimeException e, RequestMessage msgRequest, String sMsg) {
        int nAttempt = this.getAttempt() + 1;
        boolean fFail = nAttempt == MAX_ATTEMPTS;
        String sName = msgRequest.get_Name();
        int iRequest = sName.lastIndexOf("Request");
        sName = iRequest > 0 ? sName.substring(0, iRequest) : sName;
        this.setAttempt(nAttempt);
        Component._trace(String.format("%s %s %s request originating from member %d%s.", e.getMessage(), fFail ? "Failed" : "Retrying", sName, msgRequest.getFromMember().getId(), sMsg.isEmpty() ? sMsg : new StringBuilder(String.valueOf(" (")).append(sMsg).append(")").toString()), fFail ? 1 : 2);
        if (fFail) {
            GuardSupport.logStackTraces();
            throw e;
        }
        this.clearStatuses();
        Base.sleep(1);
    }

    protected void setAccessGranted(int nReason) {
        this.__m_AccessGranted = nReason;
    }

    protected void setAccessReason(int nReason) {
        this.__m_AccessReason = nReason;
    }

    protected void setAccessStorage(PartitionedCache$Storage storage) {
        this.__m_AccessStorage = storage;
    }

    protected void setAccessSubject(Subject subject) {
        this.__m_AccessSubject = subject;
    }

    public void setActive(boolean fActive) {
        this.__m_Active = fActive;
    }

    public void setAllowReadThrough(boolean fThrough) {
        this.__m_AllowReadThrough = fThrough;
    }

    protected void setAttempt(int nAttempt) {
        this.__m_Attempt = nAttempt;
    }

    public void setCommitted(boolean fRequest) {
        this.__m_Committed = fRequest;
    }

    protected void setEnlistedStatuses(Map mapStatuses) {
        this.__m_EnlistedStatuses = mapStatuses;
    }

    protected void setLockedStorage(Set setStorage) {
        this.__m_LockedStorage = setStorage;
    }

    protected void setPinnedPartitions(PartitionSet parts) {
        this.__m_PinnedPartitions = parts;
    }

    protected void setReadOnlyRequest(boolean fReadOnly) {
        this.__m_ReadOnlyRequest = fReadOnly;
    }

    protected void setStorageEntries(Map mapEntries) {
        this.__m_StorageEntries = mapEntries;
    }

    protected void setStorageStatusMap(Map map) {
        this.__m_StorageStatusMap = map;
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.get_Name())).append(" (Active=").append(this.isReadOnly() ^ true).append(" StorageMap=").append(this.getStorageMap()).append(')').toString();
    }
}

