/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.KeySetRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.PartialRequest;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheRequest.partialRequest.FilterRequest;
import com.tangosol.coherence.component.net.requestContext.AsyncContext;
import com.tangosol.coherence.component.net.requestContext.asyncContext.AsyncAggregatorContext;
import com.tangosol.coherence.component.net.requestContext.asyncContext.AsyncProcessorContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$BinaryMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$InvokeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$RequestCoordinator$BacklogContinuation;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.Member;
import com.tangosol.net.RequestPolicyException;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceStoppedException;
import com.tangosol.net.internal.MemberInfo;
import com.tangosol.net.internal.PartitionInfo;
import com.tangosol.net.internal.PartitionVersions;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.AsynchronousAgent;
import com.tangosol.util.Base;
import com.tangosol.util.Converter;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import com.tangosol.util.aggregator.AbstractAsynchronousAggregator;
import com.tangosol.util.processor.AbstractAsynchronousProcessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class PartitionedCache$RequestCoordinator
extends Util {
    private int __m_BacklogNormalCount;
    private int __m_CloggedCount;
    private AtomicInteger __m_DeferredRequestCounter;
    private Map __m_MemberInfoMap;
    private AtomicReferenceArray __m_PartitionInfoArray;
    private static ListMap __mapChildren;

    static {
        PartitionedCache$RequestCoordinator.__initStatic();
    }

    public PartitionedCache$RequestCoordinator() {
        this(null, null, true);
    }

    public PartitionedCache$RequestCoordinator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDeferredRequestCounter(new AtomicInteger());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("BacklogContinuation", PartitionedCache$RequestCoordinator$BacklogContinuation.get_CLASS());
    }

    public boolean checkBacklog(int nPartition, Continuation continuation) {
        PartitionedCache service = this.getService();
        PartitionInfo infoPart = this.getPartitionInfo(nPartition);
        MemberInfo infoMember = (MemberInfo)this.getMemberInfoMap().get(infoPart.getTarget());
        if (infoMember.getCounter().get() >= this.getCloggedCount()) {
            if (continuation != null) {
                SafeLinkedList list = infoMember.ensureBacklogContinuations();
                list.add(continuation);
                if (infoMember.getCounter().get() <= this.getBacklogNormalCount() ? true : service.getServiceState() == Service.SERVICE_STOPPED) {
                    return list.remove(continuation) ^ true;
                }
            }
            return true;
        }
        return service.ensureEventDispatcher().checkBacklog(continuation);
    }

    public boolean checkBacklog(PartitionSet partitions, Continuation continuation) {
        int iPart = partitions.next(0);
        while (iPart >= 0) {
            if (this.checkBacklog(iPart, continuation)) {
                return true;
            }
            iPart = partitions.next(iPart + 1);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDeferred() {
        if (this.getDeferredRequestCounter().get() > 0) {
            int i = 0;
            int c = this.getService().getPartitionCount();
            while (i < c) {
                LongArray laDeferred = this.getPartitionInfo(i).getDeferredRequests();
                if (laDeferred != null) {
                    LongArray longArray = laDeferred;
                    synchronized (longArray) {
                        Iterator iter = laDeferred.iterator();
                        while (iter.hasNext()) {
                            RequestMessage msgRequest = (RequestMessage)iter.next();
                            try {
                                this.validateRequest(msgRequest);
                            }
                            catch (Throwable e) {
                                AsyncContext ctx = (AsyncContext)msgRequest.getRequestContext();
                                ctx.processException(e);
                                ctx.processCompletion();
                                iter.remove();
                                this.getDeferredRequestCounter().decrementAndGet();
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void clearBacklog() {
        Map mapMemberInfo = this.getMemberInfoMap();
        if (mapMemberInfo != null) {
            Iterator iter = mapMemberInfo.values().iterator();
            while (iter.hasNext()) {
                MemberInfo info = (MemberInfo)iter.next();
                Service.notifyBacklogNormal(info.getBacklogContinuations());
            }
        }
        this.checkDeferred();
    }

    public AsyncContext createContext(PartitionedCache$BinaryMap mapBinary, AsynchronousAgent asyncAgent, Converter convValue) {
        AsyncContext context;
        PartitionedCache service = this.getService();
        if (asyncAgent instanceof AbstractAsynchronousProcessor) {
            AsyncProcessorContext ctx = new AsyncProcessorContext();
            ctx.setAsyncProcessor((AbstractAsynchronousProcessor)asyncAgent);
            context = ctx;
        } else {
            AsyncAggregatorContext ctx = new AsyncAggregatorContext();
            ctx.setAsyncAggregator((AbstractAsynchronousAggregator)asyncAgent);
            context = ctx;
        }
        context.setValueConverter(convValue);
        if (mapBinary.isAuthorizationEnabled()) {
            context.setSubject(SecurityHelper.getCurrentSubject());
        }
        mapBinary._linkChild(context);
        service.registerRequestContext(context);
        asyncAgent.bind(context);
        return context;
    }

    protected void decrementBacklog(Member member, int c) {
        SafeLinkedList list;
        int cNormal;
        MemberInfo info = (MemberInfo)this.getMemberInfoMap().get(member);
        int cBacklog = info.getCounter().addAndGet(-c);
        if ((!(cBacklog + c > (cNormal = this.getBacklogNormalCount())) ? false : cBacklog <= cNormal) && (!((list = info.getBacklogContinuations()) != null) ? false : list.isEmpty() ^ true)) {
            Service.notifyBacklogNormal(list);
        }
    }

    protected void doSubmit(RequestMessage msgRequest, com.tangosol.coherence.component.net.Member member) {
        block2: {
            if (!(member != null)) break block2;
            msgRequest.setToMemberSet(SingleMemberSet.instantiate(member));
            msgRequest.ensureRequestPoll().setExpiryTimeMillis(msgRequest.getRequestTimeout());
            try {
                this.getService().post(msgRequest);
            }
            catch (Throwable throwable) {}
        }
    }

    public long drainBacklog(int nPartition, long cMillisTimeout) throws InterruptedException {
        PartitionedCache$RequestCoordinator$BacklogContinuation continuation;
        if (this.checkBacklog(nPartition, null) && this.checkBacklog(nPartition, (Continuation)(continuation = new PartitionedCache$RequestCoordinator$BacklogContinuation()))) {
            if (cMillisTimeout == 0L) {
                continuation.getNotifier().await();
            } else {
                long ldtTimeout = cMillisTimeout == 0L ? Long.MAX_VALUE : Base.getSafeTimeMillis() + cMillisTimeout;
                continuation.getNotifier().await(cMillisTimeout);
                cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                if (cMillisTimeout < 0L) {
                    throw new RequestTimeoutException("Request timed out");
                }
            }
        }
        return cMillisTimeout;
    }

    public long drainBacklog(PartitionSet partitions, long cMillisTimeout) throws InterruptedException {
        int iPart = partitions.next(0);
        while (iPart >= 0) {
            cMillisTimeout = this.drainBacklog(iPart, cMillisTimeout);
            iPart = partitions.next(iPart + 1);
        }
        return cMillisTimeout;
    }

    public void finalizeResponse(int nPartition) {
        com.tangosol.coherence.component.net.Member memberOwner;
        PartitionInfo info = this.getPartitionInfo(nPartition);
        this.decrementBacklog(info.getTarget(), 1);
        if (info.getCounter().decrementAndGet() == 0 && !(info.getDeferredRequests() == null) && (!((memberOwner = this.getService().getPrimaryOwner(nPartition)) != null) ? false : info.getOwnershipVersion() != this.getService().getOwnershipVersion(nPartition))) {
            this.transitionPartitionOwner(nPartition, memberOwner);
        }
    }

    public void finalizeResponse(PartitionSet partitions) {
        int iPart = partitions.next(0);
        while (iPart >= 0) {
            this.finalizeResponse(iPart);
            iPart = partitions.next(iPart + 1);
        }
    }

    public int getBacklogNormalCount() {
        return this.__m_BacklogNormalCount;
    }

    public int getCloggedCount() {
        return this.__m_CloggedCount;
    }

    public AtomicInteger getDeferredRequestCounter() {
        return this.__m_DeferredRequestCounter;
    }

    public Map getMemberInfoMap() {
        return this.__m_MemberInfoMap;
    }

    protected PartitionInfo getPartitionInfo(int nPartition) {
        return (PartitionInfo)this.getPartitionInfoArray().get(nPartition);
    }

    protected AtomicReferenceArray getPartitionInfoArray() {
        return this.__m_PartitionInfoArray;
    }

    public PartitionedCache getService() {
        return (PartitionedCache)this.get_Module();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$RequestCoordinator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PartitionedCache$RequestCoordinator();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected void incrementBacklog(Member member, int c) {
        MemberInfo info = (MemberInfo)this.getMemberInfoMap().get(member);
        info.getCounter().addAndGet(c);
    }

    public void initialize() {
        PartitionedCache service = this.getService();
        this.setPartitionInfoArray(new AtomicReferenceArray(service.getPartitionCount()));
        SafeHashMap<Object, MemberInfo> mapInfo = new SafeHashMap<Object, MemberInfo>();
        mapInfo.put(null, new MemberInfo());
        this.setMemberInfoMap(mapInfo);
        int cMaxPending = service.ensureEventDispatcher().getCloggedCount();
        try {
            String sMaxPending = Config.getProperty("coherence.async.limit");
            if (sMaxPending != null) {
                cMaxPending = Integer.parseInt(sMaxPending);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        cMaxPending = Math.max(256, cMaxPending);
        this.setCloggedCount(cMaxPending);
        this.setBacklogNormalCount((cMaxPending >> 2) * 3);
    }

    protected PartitionInfo instantiatePartitionInfo(com.tangosol.coherence.component.net.Member member, int nVersion) {
        PartitionInfo info = new PartitionInfo(member, nVersion);
        if (member == null) {
            info.setDeferredRequests(new SparseArray());
        } else {
            Map mapInfo = this.getMemberInfoMap();
            if (mapInfo.containsKey(member) ^ true) {
                mapInfo.put(member, new MemberInfo());
            }
        }
        return info;
    }

    public void onInterval() {
        this.checkDeferred();
    }

    public void onServiceResumed() {
        PartitionedCache service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        int[][] aaiOwners = service.getPartitionAssignments();
        int iPart = 0;
        int cParts = service.getPartitionCount();
        while (iPart < cParts) {
            this.updatePartitionOwner(iPart, ((MemberSet)setMembers).getMember(aaiOwners[iPart][0]), true);
            ++iPart;
        }
    }

    public void onServiceSuspended() {
        int iPart = 0;
        int cParts = this.getService().getPartitionCount();
        while (iPart < cParts) {
            this.updatePartitionOwner(iPart, null);
            ++iPart;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected com.tangosol.coherence.component.net.Member prepareSubmit(RequestMessage msgRequest, int nPartition, Map mapMsgByOwner) {
        boolean fFinalizeResponse;
        LongArray laDeferred;
        com.tangosol.coherence.component.net.Member member;
        PartitionedCache service = (PartitionedCache)this.get_Module();
        block3: while (true) {
            PartitionInfo info = this.getPartitionInfo(nPartition);
            member = (com.tangosol.coherence.component.net.Member)info.getTarget();
            laDeferred = info.getDeferredRequests();
            fFinalizeResponse = false;
            if (laDeferred == null) {
                int cPending;
                AtomicInteger counter = info.getCounter();
                do {
                    if ((cPending = counter.get()) == -1) continue block3;
                } while (counter.compareAndSet(cPending, cPending + 1) ^ true);
                Component._assert(member != null);
                this.incrementBacklog(member, 1);
                DistributedCacheRequest msgFirst = mapMsgByOwner == null ? null : (DistributedCacheRequest)mapMsgByOwner.get(member);
                msgRequest = msgFirst == null ? msgRequest : msgFirst;
                Poll poll = msgRequest.ensureRequestPoll();
                if (!(!(!service.isSuspended() ? false : msgRequest.isSuspendable()) ? false : poll.getPollId() > service.getSuspendPollLimit().get())) {
                    return member;
                }
                fFinalizeResponse = true;
                laDeferred = info.getDeferredRequests();
                Component._assert(laDeferred != null);
            }
            LongArray longArray = laDeferred;
            synchronized (longArray) {
                this.validateRequest(msgRequest);
                if (!(info != this.getPartitionInfo(nPartition))) break;
                Object var10_11 = null;
            }
        }
        {
            laDeferred.set(msgRequest.getRequestContext().getRequestSUID(), msgRequest);
        }
        this.getDeferredRequestCounter().incrementAndGet();
        this.incrementBacklog(member, 1);
        if (fFinalizeResponse) {
            this.finalizeResponse(nPartition);
        }
        return null;
    }

    public boolean resubmitRequest(DistributedCacheRequest msgRequest, PartitionSet partRequest, PartitionSet partUpdate) {
        if (partUpdate != null) {
            PartitionedCache service = (PartitionedCache)this.get_Module();
            PartitionVersions versions = msgRequest.getOwnershipVersions();
            int iPart = partUpdate.next(0);
            while (iPart >= 0) {
                if (versions.getVersion(iPart) == service.getOwnershipVersion(iPart)) {
                    this.updatePartitionOwner(iPart, null);
                }
                iPart = partUpdate.next(iPart + 1);
            }
        }
        try {
            this.validateRequest(msgRequest);
        }
        catch (Throwable e) {
            ((AsyncContext)msgRequest.getRequestContext()).processException(e);
            return false;
        }
        if (msgRequest instanceof KeySetRequest) {
            KeySetRequest msgKSR = (KeySetRequest)msgRequest;
            Set setResend = msgKSR.getKeySet();
            return (setResend == null ? true : setResend.isEmpty()) ? true : this.submitKeySetRequest(msgKSR, setResend, null, true);
        }
        if (msgRequest instanceof FilterRequest) {
            return (partRequest == null ? true : partRequest.isEmpty()) ? true : this.submitPartialRequest((FilterRequest)msgRequest, partRequest, true);
        }
        throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid resubmit request: ")).append(msgRequest).toString());
    }

    public boolean resubmitRequest(PartitionedCache$InvokeRequest msgRequest, int iPart, boolean fUpdatePart) {
        if (!fUpdatePart ? false : msgRequest.getOwnershipVersion() == this.getService().getOwnershipVersion(iPart)) {
            this.updatePartitionOwner(iPart, null);
        }
        try {
            this.validateRequest(msgRequest);
        }
        catch (Throwable e) {
            ((AsyncContext)msgRequest.getRequestContext()).processException(e);
            return false;
        }
        if (msgRequest instanceof PartitionedCache$InvokeRequest) {
            return this.submitKeyRequest(msgRequest, iPart);
        }
        throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid resubmit request: ")).append(msgRequest).toString());
    }

    protected void setBacklogNormalCount(int c) {
        this.__m_BacklogNormalCount = c;
    }

    protected void setCloggedCount(int nCount) {
        this.__m_CloggedCount = nCount;
    }

    protected void setDeferredRequestCounter(AtomicInteger atomic) {
        this.__m_DeferredRequestCounter = atomic;
    }

    protected void setMemberInfoMap(Map map) {
        this.__m_MemberInfoMap = map;
    }

    protected void setPartitionInfo(int nPartition, PartitionInfo info) {
        this.getPartitionInfoArray().set(nPartition, info);
    }

    protected void setPartitionInfoArray(AtomicReferenceArray arrayInfo) {
        this.__m_PartitionInfoArray = arrayInfo;
    }

    public boolean submitKeyRequest(PartitionedCache$InvokeRequest msgRequest, int nPartition) {
        try {
            ((PartitionedCache)this.get_Module()).checkQuorum(msgRequest, msgRequest.isReadOnly());
            this.doSubmit(msgRequest, this.prepareSubmit(msgRequest, nPartition, null));
            return true;
        }
        catch (Throwable e) {
            ((AsyncContext)msgRequest.getRequestContext()).processException(e);
            return false;
        }
    }

    public boolean submitKeySetRequest(KeySetRequest msgRequest, Set setKeys, PartitionSet partitions, boolean fRepeat) {
        PartitionedCache service = this.getService();
        HashMap<com.tangosol.coherence.component.net.Member, KeySetRequest> mapMsgByOwner = new HashMap<com.tangosol.coherence.component.net.Member, KeySetRequest>();
        boolean fClone = false;
        try {
            service.checkQuorum(msgRequest, msgRequest.isReadOnly());
            Map mapKeysByPID = service.splitKeysByPartition(setKeys.iterator());
            Iterator iter = mapKeysByPID.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                int nPartition = (Integer)entry.getKey();
                Set setPartKeys = (Set)entry.getValue();
                if (fClone) {
                    msgRequest = (KeySetRequest)msgRequest.cloneMessage();
                } else {
                    fClone = true;
                }
                msgRequest.setKeySet(setPartKeys);
                msgRequest.setPartitions(service.instantiatePartitionSet(nPartition));
                com.tangosol.coherence.component.net.Member member = this.prepareSubmit(msgRequest, nPartition, mapMsgByOwner);
                if (!(member == null)) {
                    KeySetRequest msgFirst = (KeySetRequest)mapMsgByOwner.get(member);
                    if (msgFirst == null) {
                        mapMsgByOwner.put(member, msgRequest);
                    } else {
                        msgFirst.getKeySet().addAll(setPartKeys);
                        msgFirst.getPartitions().add(nPartition);
                    }
                }
                if (!(partitions != null)) continue;
                partitions.add(nPartition);
            }
        }
        catch (Throwable e) {
            ((AsyncContext)msgRequest.getRequestContext()).processException(e);
            return false;
        }
        if (mapMsgByOwner.isEmpty() ^ true) {
            if (fRepeat) {
                PartitionedCache$BinaryMap.reportRepeat(msgRequest.get_Name(), setKeys.size(), 0, ((PartitionedCache)this.get_Module()).calculatePartitionSet(setKeys));
            }
            Iterator iter = mapMsgByOwner.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.doSubmit((KeySetRequest)entry.getValue(), (com.tangosol.coherence.component.net.Member)entry.getKey());
            }
        }
        return true;
    }

    public boolean submitPartialRequest(PartialRequest msgRequest, PartitionSet partitions, boolean fRepeat) {
        PartitionedCache service = this.getService();
        AsyncContext context = (AsyncContext)msgRequest.getRequestContext();
        HashMap<com.tangosol.coherence.component.net.Member, PartialRequest> mapMsgByOwner = new HashMap<com.tangosol.coherence.component.net.Member, PartialRequest>();
        try {
            service.checkQuorum(msgRequest, msgRequest.isReadOnly());
            boolean fClone = false;
            int iPart = partitions.next(0);
            while (iPart >= 0) {
                if (fClone) {
                    msgRequest = (PartialRequest)msgRequest.cloneMessage();
                } else {
                    fClone = true;
                }
                msgRequest.setRequestMask(service.instantiatePartitionSet(iPart));
                msgRequest.setPartitions(context.getPartitionSet());
                com.tangosol.coherence.component.net.Member member = this.prepareSubmit(msgRequest, iPart, mapMsgByOwner);
                if (!(member == null)) {
                    PartialRequest msgFirst = (PartialRequest)mapMsgByOwner.get(member);
                    if (msgFirst == null) {
                        mapMsgByOwner.put(member, msgRequest);
                    } else {
                        msgFirst.getRequestMask().add(iPart);
                    }
                }
                iPart = partitions.next(iPart + 1);
            }
        }
        catch (Throwable e) {
            context.processException(e);
            return false;
        }
        if (mapMsgByOwner.isEmpty() ^ true) {
            if (fRepeat) {
                PartitionedCache$BinaryMap.reportRepeat(msgRequest.get_Name(), 0, 0, partitions);
            }
            Iterator iter = mapMsgByOwner.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.doSubmit((PartialRequest)entry.getValue(), (com.tangosol.coherence.component.net.Member)entry.getKey());
            }
        }
        return true;
    }

    public void syncAssignments() {
        PartitionedCache service = this.getService();
        int cPartitions = service.getPartitionCount();
        int[][] aaiOwner = service.getPartitionAssignments();
        ServiceMemberSet setMember = service.getServiceMemberSet();
        Component._assert(Thread.currentThread() == service.getThread());
        int iPart = 0;
        while (iPart < cPartitions) {
            this.updatePartitionOwner(iPart, setMember.getMember(aaiOwner[iPart][0]));
            ++iPart;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.get_Name());
        int i = 0;
        int c = this.getService().getPartitionCount();
        while (i < c) {
            PartitionInfo info = this.getPartitionInfo(i);
            int cPending = info.getCounter().get();
            LongArray laDeferred = info.getDeferredRequests();
            if (cPending != 0 ? true : laDeferred != null) {
                sb.append("\n  Partition ").append(i).append(": pending=").append(cPending).append(", deferred=").append(laDeferred == null ? 0 : laDeferred.getSize());
            }
            ++i;
        }
        Iterator iter = this.getMemberInfoMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Member member = (Member)entry.getKey();
            MemberInfo info = (MemberInfo)entry.getValue();
            int cPending = info.getCounter().get();
            SafeLinkedList list = info.getBacklogContinuations();
            if (!(cPending > 0 ? true : (!(list != null) ? false : list.isEmpty() ^ true))) continue;
            sb.append("\n    Member ").append(member.getId()).append(": pending=").append(cPending).append(", awaiting=").append(list == null ? 0 : list.size());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionPartitionOwner(int nPartition, com.tangosol.coherence.component.net.Member memberNew) {
        PartitionedCache service = this.getService();
        PartitionInfo infoOld = this.getPartitionInfo(nPartition);
        if (infoOld.getCounter().compareAndSet(0, -1)) {
            LongArray laDeferred;
            Component._assert(memberNew != null);
            PartitionInfo infoNew = this.instantiatePartitionInfo(memberNew, service.getOwnershipVersion(nPartition));
            LongArray longArray = laDeferred = infoOld.getDeferredRequests();
            synchronized (longArray) {
                int cDeferred = laDeferred.getSize();
                if (service.isSuspended()) {
                    infoNew.setDeferredRequests(laDeferred);
                } else {
                    Iterator iter = laDeferred.iterator();
                    while (iter.hasNext()) {
                        RequestMessage msgRequest = (RequestMessage)iter.next();
                        this.doSubmit(msgRequest, memberNew);
                    }
                    this.getDeferredRequestCounter().addAndGet(-cDeferred);
                    infoNew.getCounter().addAndGet(cDeferred);
                }
                Member memberOld = infoOld.getTarget();
                if (memberOld != memberNew) {
                    this.incrementBacklog(memberNew, cDeferred);
                    this.decrementBacklog(memberOld, cDeferred);
                }
                this.setPartitionInfo(nPartition, infoNew);
            }
        }
    }

    public void updatePartitionOwner(int nPartition, com.tangosol.coherence.component.net.Member member) {
        this.updatePartitionOwner(nPartition, member, false);
    }

    protected void updatePartitionOwner(int nPartition, com.tangosol.coherence.component.net.Member member, boolean fResume) {
        Component._assert(Thread.currentThread() == this.getService().getThread());
        PartitionInfo info = this.getPartitionInfo(nPartition);
        if (info == null) {
            this.setPartitionInfo(nPartition, this.instantiatePartitionInfo(member, this.getService().getOwnershipVersion(nPartition)));
        } else if ((info.getTarget() != member ? true : info.getOwnershipVersion() != this.getService().getOwnershipVersion(nPartition)) ? true : fResume) {
            if (info.getDeferredRequests() == null) {
                info.setDeferredRequests(new SparseArray());
            }
            if (member != null) {
                this.transitionPartitionOwner(nPartition, member);
            }
        }
    }

    protected void validateRequest(RequestMessage msgRequest) {
        PartitionedCache service = (PartitionedCache)this.get_Module();
        AsyncContext ctx = (AsyncContext)msgRequest.getRequestContext();
        PartitionedCache$BinaryMap mapBinary = ctx.getCache();
        Object e = null;
        if (Base.getLastSafeTimeMillis() >= msgRequest.getRequestTimeout()) {
            throw new RequestTimeoutException(new StringBuilder(String.valueOf("Async request timeout after ")).append(service.calculateRequestTimeout(msgRequest)).append("ms").toString());
        }
        if (service.getServiceState() == Service.SERVICE_STOPPED) {
            throw new ServiceStoppedException(new StringBuilder(String.valueOf("Service ")).append(service.getServiceName()).append(" has been terminated").toString());
        }
        if (mapBinary.isActive() ^ true) {
            throw new RequestPolicyException(new StringBuilder(String.valueOf("The reference to cache \"")).append(mapBinary.getCacheName()).append("\" has been released").toString());
        }
    }
}

