/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.connection.TcpConnection;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$BufferPool;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferWriteBuffer;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.SuspectConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.WrapperException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public class TcpAcceptor$TcpConnection
extends TcpConnection {
    public static final int IN_DECODED = 1;
    public static final int IN_INITIAL = 0;
    public static final int IN_PREPARED = 2;
    public static final int OUT_ENCODED = 2;
    public static final int OUT_INITIAL = 0;
    public static final int OUT_PREPARED = 1;
    private String __m_ClusterName;
    private transient long __m_ConnectTimeMillis;
    private ByteBuffer __m_IncomingByteBuffer;
    private int __m_IncomingBytesRead;
    private int __m_IncomingBytesTotal;
    private boolean __m_IncomingDisabled;
    private int __m_IncomingState;
    private ByteBufferWriteBuffer[] __m_IncomingWriteBufferArray;
    private int __m_IncomingWriteBufferIndex;
    private ByteBuffer __m_OutgoingByteBuffer;
    private int __m_OutgoingBytesTotal;
    private int __m_OutgoingBytesWritten;
    private boolean __m_OutgoingDisabled;
    private MultiBufferWriteBuffer __m_OutgoingMessage;
    private Queue __m_OutgoingQueue;
    private int __m_OutgoingState;
    private ByteBufferWriteBuffer[] __m_OutgoingWriteBufferArray;
    private int __m_OutgoingWriteBufferIndex;
    private boolean __m_Redirect;
    private List __m_RedirectList;
    private boolean __m_RedirectSupported;
    private SelectionKey __m_SelectionKey;
    private String __m_ServiceName;
    private SocketChannel __m_SocketChannel;
    private transient long __m_StatsBytesQueued;
    private transient long __m_StatsQueued;
    private boolean __m_Suspect;
    private int __m_SuspectBytesWorseCount;
    private int __m_SuspectCheckCount;
    private long __m_SuspectInitialBytes;
    private long __m_SuspectInitialLength;
    private long __m_SuspectInitialMillis;
    private long __m_SuspectLatestBytes;
    private long __m_SuspectLatestLength;
    private long __m_SuspectLatestMillis;
    private int __m_SuspectLengthWorseCount;
    private long __m_SuspectTargetBytes;
    private long __m_SuspectTargetLength;

    public TcpAcceptor$TcpConnection() {
        this(null, null, true);
    }

    public TcpAcceptor$TcpConnection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setChannelArray(new SparseArray());
            this.setChannelPendingArray(new SparseArray());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void assertOpen() {
        super.assertOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSuspect(boolean fSuspect, long cQueued, long cbQueued, long cSent, long cbSent) {
        TcpAcceptor acceptor = (TcpAcceptor)this.getConnectionManager();
        TcpAcceptor$BufferPool pool = acceptor.getBufferPoolOut();
        Queue queue = this.getOutgoingQueue();
        long cBehind = cQueued - cSent;
        long cbBehind = cbQueued - cbSent;
        if (((((((cQueued < 0L ? true : cSent < 0L) ? true : cBehind < 0L) ? true : cBehind > (long)Integer.MAX_VALUE) ? true : cbQueued < 0L) ? true : cbSent < 0L) ? true : cbBehind < 0L) ? true : cbBehind > (long)Integer.MAX_VALUE) {
            return;
        }
        if (fSuspect) {
            Queue queue2 = queue;
            synchronized (queue2) {
                if (!this.isSuspect() ? false : this.isSuspectEvaluate()) {
                    long LIMIT_BYTES = acceptor.getDefaultLimitBytes();
                    long LIMIT_LENGTH = acceptor.getDefaultLimitLength();
                    boolean fKill = false;
                    boolean fClear = false;
                    String sCause = null;
                    long cTarget = this.getSuspectTargetLength();
                    long cbTarget = this.getSuspectTargetBytes();
                    int cMax = pool.getCapacity();
                    if (!pool.isCapacityLimited() ? false : (cBehind > (long)cMax ? true : cbBehind > (long)(cMax * pool.getBufferSize()))) {
                        fKill = true;
                        sCause = new StringBuilder(String.valueOf("This one connection has used up the entire")).append(" configured capacity of the buffer pool;").append(" the connection is ").append(cBehind).append(" messages behind (").append(cbBehind).append(" bytes); the buffer pool is configured for ").append(cMax).append(" messages (").append(cMax * pool.getBufferSize()).append(" bytes).").toString();
                    } else if (!(pool.isCapacityLimited() ^ true) ? false : (cBehind > LIMIT_LENGTH ? true : cbBehind > LIMIT_BYTES)) {
                        fKill = true;
                        sCause = new StringBuilder(String.valueOf("This connection is ")).append(cBehind).append(" messages behind (").append(cbBehind).append(" bytes); the limit is ").append(LIMIT_LENGTH).append(" messages (").append(LIMIT_BYTES).append(" bytes).").toString();
                    } else if (cbBehind < cbTarget) {
                        fClear = true;
                        sCause = new StringBuilder(String.valueOf("The connection has reduced its backlog to ")).append(cbBehind).append(" bytes; the target was ").append(cbTarget).append(" bytes.").toString();
                    } else {
                        boolean fLengthWorse;
                        long cMillis = this.getSuspectLatestMillis();
                        int cElapsedSecs = (int)((cMillis - this.getSuspectInitialMillis()) / 1000L);
                        long cOrigLength = this.getSuspectInitialLength();
                        long cbOrigBytes = this.getSuspectInitialBytes();
                        long cPrevLength = this.getSuspectLatestLength();
                        long cbPrevBytes = this.getSuspectLatestBytes();
                        int cChecks = this.getSuspectCheckCount();
                        int cBytesWorse = this.getSuspectBytesWorseCount();
                        int cLengthWorse = this.getSuspectLengthWorseCount();
                        boolean fBytesWorse = cbBehind > cbPrevBytes;
                        if (fBytesWorse) {
                            ++cBytesWorse;
                        }
                        if (fLengthWorse = cBehind > cPrevLength) {
                            ++cLengthWorse;
                        }
                        int cPctBytesChange = (int)(cbBehind * 100L / cbOrigBytes);
                        int cPctLengthChange = (int)(cBehind * 100L / cOrigLength);
                        int cPctBytesWorse = cBytesWorse * 100 / ++cChecks;
                        int cPctLengthWorse = cLengthWorse * 100 / cChecks;
                        if (!(cbBehind > cbOrigBytes) ? false : ((!(!(cChecks > 20) ? false : cElapsedSecs > 60) ? false : (cPctBytesWorse > 90 ? true : cPctLengthWorse > 90)) ? true : (!(!(cChecks > 6) ? false : cElapsedSecs > 20) ? false : (cPctBytesWorse == 100 ? true : cPctLengthWorse == 100)))) {
                            fKill = true;
                            sCause = new StringBuilder(String.valueOf("The connection has been monitored as a ")).append("suspect for the past ").append(cElapsedSecs).append(" seconds and its backlog has increased ").append("with alarming consistency; the backlog ").append("length has increased ").append(cPctLengthWorse).append("% of the time and the backlog memory ").append("usage has increased ").append(cPctBytesWorse).append("% of the time; the connection is now ").append(cBehind).append(" messages behind (").append(cbBehind).append(" bytes).").toString();
                        } else if (!(!(!(cbBehind < cbOrigBytes) ? false : cChecks > 20) ? false : cElapsedSecs > 60) ? false : (cPctBytesWorse < 10 ? true : cPctLengthWorse < 10)) {
                            fClear = true;
                            sCause = new StringBuilder(String.valueOf("The connection has been monitored as a ")).append("suspect for the past ").append(cElapsedSecs).append(" seconds and its backlog has decreased ").append("with reassuring consistency; the backlog ").append("length has decreased ").append(100 - cPctLengthWorse).append("% of the time and the backlog memory ").append("usage has decreased ").append(100 - cPctBytesWorse).append("% of the time; the connection is now only ").append(cBehind).append(" messages behind (").append(cbBehind).append(" bytes).").toString();
                        }
                        this.setSuspectLatestBytes(cbBehind);
                        this.setSuspectLatestLength(cBehind);
                        this.setSuspectCheckCount(cChecks);
                        this.setSuspectLengthWorseCount(cLengthWorse);
                        this.setSuspectBytesWorseCount(cBytesWorse);
                    }
                    if (fClear) {
                        Component._trace(new StringBuilder(String.valueOf("Extend*TCP has determined that ")).append(this.toString()).append(" is no longer a suspect: ").append(sCause).toString(), 3);
                        this.setSuspect(false);
                    } else if (fKill) {
                        Component._trace(new StringBuilder(String.valueOf("Extend*TCP has determined that ")).append(this.toString()).append(" must be closed to maintain ").append("system stability: ").append(sCause).toString(), 1);
                        this.setSuspect(false);
                        this.setCloseOnExit(true);
                        this.setCloseNotify(false);
                        this.setCloseThrowable(new SuspectConnectionException(sCause, (Connection)this));
                    }
                }
            }
        }
        if (!((pool.getOverflow() > 0 ? true : cBehind > (long)acceptor.getDefaultSuspectLength()) ? true : cbBehind > acceptor.getDefaultSuspectBytes()) ? false : this.isSuspectEvaluate()) {
            long NOMINAL_BYTES = acceptor.getDefaultNominalBytes();
            long NOMINAL_LENGTH = acceptor.getDefaultNominalLength();
            long SUSPECT_BYTES = acceptor.getDefaultSuspectBytes();
            long SUSPECT_LENGTH = acceptor.getDefaultSuspectLength();
            long cTarget = NOMINAL_LENGTH;
            long cbTarget = NOMINAL_BYTES;
            String sCause = null;
            if (cBehind > SUSPECT_LENGTH ? true : cbBehind > SUSPECT_BYTES) {
                fSuspect = true;
                sCause = new StringBuilder(String.valueOf("The connection has fallen ")).append(cBehind).append(" messages (").append(cbBehind).append(" bytes) behind; the threshold is ").append(SUSPECT_LENGTH).append(" messages or ").append(SUSPECT_BYTES).append(" bytes.").toString();
            }
            int cAliveSecs = (int)((this.getSuspectLatestMillis() - this.getConnectTimeMillis()) / 1000L);
            if (!pool.isCapacityLimited() ? false : cAliveSecs > 30) {
                int cConnections = acceptor.getConnectionSet().size();
                int cbCapacity = pool.getCapacity() * pool.getBufferSize();
                int cbSuspect = (int)Math.min(SUSPECT_BYTES, Math.max(NOMINAL_BYTES, (long)(cbCapacity / cConnections / 2 * 3)));
                if (cbBehind > (long)cbSuspect) {
                    cbTarget = Math.min(SUSPECT_BYTES, Math.max(NOMINAL_BYTES, (long)(cbCapacity / cConnections)));
                    fSuspect = true;
                    sCause = new StringBuilder(String.valueOf("The connection has fallen ")).append(cBehind).append(" messages (").append(cbBehind).append(" bytes) behind; with ").append(cConnections).append(" connections, the fair share per connection is").append(cbTarget).append(" bytes.").toString();
                }
            }
            if (fSuspect) {
                int cConns = 0;
                int cWorse = 0;
                try {
                    Iterator iter = acceptor.getConnectionSet().iterator();
                    while (iter.hasNext()) {
                        TcpAcceptor$TcpConnection conn = (TcpAcceptor$TcpConnection)iter.next();
                        if (!(!(conn != null) ? false : conn != this)) continue;
                        ++cConns;
                        long cThatBehind = conn.getStatsQueued() - conn.getStatsSent();
                        long cbThatBehind = conn.getStatsBytesQueued() - conn.getStatsBytesSent();
                        if (!((!(!(cThatBehind > 0L) ? false : cThatBehind < (long)Integer.MAX_VALUE) ? false : cThatBehind > cBehind) ? true : (!(!(cbThatBehind > 0L) ? false : cbThatBehind < (long)Integer.MAX_VALUE) ? false : cbThatBehind > cbBehind))) continue;
                        ++cWorse;
                    }
                }
                catch (ConcurrentModificationException e) {
                    return;
                }
                if (cWorse < Math.max(3, cConns / 20)) {
                    Queue queue3 = queue;
                    synchronized (queue3) {
                        this.setSuspect(true);
                        this.setSuspectInitialMillis(this.getSuspectLatestMillis());
                        this.setSuspectInitialBytes(cbBehind);
                        this.setSuspectInitialLength(cBehind);
                        this.setSuspectLatestBytes(cbBehind);
                        this.setSuspectLatestLength(cBehind);
                        this.setSuspectCheckCount(0);
                        this.setSuspectLengthWorseCount(0);
                        this.setSuspectBytesWorseCount(0);
                        this.setSuspectTargetBytes(cbTarget);
                        this.setSuspectTargetLength(cTarget);
                    }
                    Component._trace(new StringBuilder(String.valueOf("Extend*TCP has marked ")).append(this.toString()).append(" as suspect: ").append(sCause).toString(), 3);
                }
            }
        }
    }

    public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
        ThreadGate gate = this.getThreadGate();
        gate.barEntry(-1L);
        try {
            this.notifyWaitingThreads();
            boolean bl = super.closeInternal(fNotify, e, cMillis);
            Object var7_7 = null;
            gate.open();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            gate.open();
            throw throwable;
        }
    }

    public String getClusterName() {
        return this.__m_ClusterName;
    }

    public long getConnectTimeMillis() {
        return this.__m_ConnectTimeMillis;
    }

    public ByteBuffer getIncomingByteBuffer() {
        return this.__m_IncomingByteBuffer;
    }

    public int getIncomingBytesRead() {
        return this.__m_IncomingBytesRead;
    }

    public int getIncomingBytesTotal() {
        return this.__m_IncomingBytesTotal;
    }

    public int getIncomingState() {
        return this.__m_IncomingState;
    }

    public ByteBufferWriteBuffer[] getIncomingWriteBufferArray() {
        return this.__m_IncomingWriteBufferArray;
    }

    public int getIncomingWriteBufferIndex() {
        return this.__m_IncomingWriteBufferIndex;
    }

    public ByteBuffer getOutgoingByteBuffer() {
        return this.__m_OutgoingByteBuffer;
    }

    public int getOutgoingBytesTotal() {
        return this.__m_OutgoingBytesTotal;
    }

    public int getOutgoingBytesWritten() {
        return this.__m_OutgoingBytesWritten;
    }

    public MultiBufferWriteBuffer getOutgoingMessage() {
        return this.__m_OutgoingMessage;
    }

    public Queue getOutgoingQueue() {
        return this.__m_OutgoingQueue;
    }

    public int getOutgoingState() {
        return this.__m_OutgoingState;
    }

    public ByteBufferWriteBuffer[] getOutgoingWriteBufferArray() {
        return this.__m_OutgoingWriteBufferArray;
    }

    public int getOutgoingWriteBufferIndex() {
        return this.__m_OutgoingWriteBufferIndex;
    }

    public List getRedirectList() {
        return this.__m_RedirectList;
    }

    public SelectionKey getSelectionKey() {
        return this.__m_SelectionKey;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public SocketChannel getSocketChannel() {
        return this.__m_SocketChannel;
    }

    public long getStatsBytesQueued() {
        return this.__m_StatsBytesQueued;
    }

    public long getStatsQueued() {
        return this.__m_StatsQueued;
    }

    public int getSuspectBytesBetterCount() {
        return this.getSuspectCheckCount() - this.getSuspectBytesWorseCount();
    }

    public int getSuspectBytesWorseCount() {
        return this.__m_SuspectBytesWorseCount;
    }

    public int getSuspectCheckCount() {
        return this.__m_SuspectCheckCount;
    }

    public long getSuspectInitialBytes() {
        return this.__m_SuspectInitialBytes;
    }

    public long getSuspectInitialLength() {
        return this.__m_SuspectInitialLength;
    }

    public long getSuspectInitialMillis() {
        return this.__m_SuspectInitialMillis;
    }

    public long getSuspectLatestBytes() {
        return this.__m_SuspectLatestBytes;
    }

    public long getSuspectLatestLength() {
        return this.__m_SuspectLatestLength;
    }

    public long getSuspectLatestMillis() {
        return this.__m_SuspectLatestMillis;
    }

    public int getSuspectLengthBetterCount() {
        return this.getSuspectCheckCount() - this.getSuspectLengthWorseCount();
    }

    public int getSuspectLengthWorseCount() {
        return this.__m_SuspectLengthWorseCount;
    }

    public long getSuspectTargetBytes() {
        return this.__m_SuspectTargetBytes;
    }

    public long getSuspectTargetLength() {
        return this.__m_SuspectTargetLength;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor$TcpConnection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new TcpAcceptor$TcpConnection();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isIncomingDisabled() {
        return this.__m_IncomingDisabled;
    }

    public boolean isOutgoingDisabled() {
        return this.__m_OutgoingDisabled;
    }

    public boolean isRedirect() {
        return this.__m_Redirect;
    }

    public boolean isRedirectSupported() {
        return this.__m_RedirectSupported;
    }

    public boolean isSuspect() {
        return this.__m_Suspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSuspectEvaluate() {
        boolean fEvaluate = false;
        Queue queue = this.getOutgoingQueue();
        synchronized (queue) {
            long ldtCurrent = Base.getSafeTimeMillis();
            long ldtPrevious = this.getSuspectLatestMillis();
            if (ldtCurrent > ldtPrevious + 3000L) {
                this.setSuspectLatestMillis(ldtCurrent);
                fEvaluate = true;
            }
        }
        return fEvaluate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThreads() {
        MultiBufferWriteBuffer o = this.getOutgoingMessage();
        if (o != null) {
            MultiBufferWriteBuffer multiBufferWriteBuffer = o;
            synchronized (multiBufferWriteBuffer) {
                o.notify();
            }
        }
        Iterator iter = this.getOutgoingQueue().iterator();
        while (iter.hasNext()) {
            MultiBufferWriteBuffer multiBufferWriteBuffer = o = iter.next();
            synchronized (multiBufferWriteBuffer) {
                o.notify();
            }
        }
    }

    public void onInit() {
        this.setOutgoingQueue(new DualQueue());
        this.setConnectTimeMillis(System.currentTimeMillis());
        super.onInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(WriteBuffer wb) throws ConnectionException {
        this.assertOpen();
        TcpAcceptor acceptor = (TcpAcceptor)this.getConnectionManager();
        Queue queue = this.getOutgoingQueue();
        WriteBuffer writeBuffer = wb;
        synchronized (writeBuffer) {
            boolean fSuspect;
            long cbSent;
            long cSent;
            long cbQueued;
            long cQueued;
            boolean fFlush;
            int cb = wb.length();
            Queue queue2 = queue;
            synchronized (queue2) {
                queue.add(wb);
                fFlush = queue.size() == 1;
                cQueued = this.getStatsQueued() + (long)1;
                cbQueued = this.getStatsBytesQueued() + (long)cb;
                this.setStatsQueued(cQueued);
                this.setStatsBytesQueued(cbQueued);
                cSent = this.getStatsSent();
                cbSent = this.getStatsBytesSent();
                fSuspect = this.isSuspect();
            }
            if (fFlush) {
                acceptor.getConnectionFlushQueue().add(this);
                acceptor.getProcessor().wakeup();
            }
            if (acceptor.isSuspectProtocolEnabled()) {
                this.checkSuspect(fSuspect, cQueued, cbQueued, cSent, cbSent);
            }
        }
    }

    public void setClusterName(String sName) {
        this.__m_ClusterName = sName;
    }

    protected void setConnectTimeMillis(long cMillis) {
        this.__m_ConnectTimeMillis = cMillis;
    }

    public void setIncomingByteBuffer(ByteBuffer bb) {
        this.__m_IncomingByteBuffer = bb;
    }

    public void setIncomingBytesRead(int cb) {
        this.__m_IncomingBytesRead = cb;
    }

    public void setIncomingBytesTotal(int cb) {
        this.__m_IncomingBytesTotal = cb;
    }

    public void setIncomingDisabled(boolean fDisabled) {
        SelectionKey key;
        if (fDisabled ^ this.isIncomingDisabled() && (key = this.getSelectionKey()) != null) {
            if (fDisabled) {
                key.interestOps(key.interestOps() & ~SelectionKey.OP_READ);
            } else {
                key.interestOps(key.interestOps() | SelectionKey.OP_READ);
            }
            this.__m_IncomingDisabled = fDisabled;
        }
    }

    public void setIncomingState(int nState) {
        this.__m_IncomingState = nState;
    }

    public void setIncomingWriteBufferArray(ByteBufferWriteBuffer[] awb) {
        this.__m_IncomingWriteBufferArray = awb;
    }

    public void setIncomingWriteBufferIndex(int i) {
        this.__m_IncomingWriteBufferIndex = i;
    }

    public void setOutgoingByteBuffer(ByteBuffer bb) {
        this.__m_OutgoingByteBuffer = bb;
    }

    public void setOutgoingBytesTotal(int cb) {
        this.__m_OutgoingBytesTotal = cb;
    }

    public void setOutgoingBytesWritten(int cb) {
        this.__m_OutgoingBytesWritten = cb;
    }

    public void setOutgoingDisabled(boolean fDisabled) {
        SelectionKey key;
        if (fDisabled ^ this.isOutgoingDisabled() && (key = this.getSelectionKey()) != null) {
            if (fDisabled) {
                key.interestOps(key.interestOps() & ~SelectionKey.OP_WRITE);
            } else {
                key.interestOps(key.interestOps() | SelectionKey.OP_WRITE);
            }
            this.__m_OutgoingDisabled = fDisabled;
        }
    }

    public void setOutgoingMessage(MultiBufferWriteBuffer mwb) {
        this.__m_OutgoingMessage = mwb;
    }

    public void setOutgoingQueue(Queue queue) {
        this.__m_OutgoingQueue = queue;
    }

    public void setOutgoingState(int nState) {
        this.__m_OutgoingState = nState;
    }

    public void setOutgoingWriteBufferArray(ByteBufferWriteBuffer[] awb) {
        this.__m_OutgoingWriteBufferArray = awb;
    }

    public void setOutgoingWriteBufferIndex(int i) {
        this.__m_OutgoingWriteBufferIndex = i;
    }

    public void setRedirect(boolean f) {
        this.__m_Redirect = f;
    }

    public void setRedirectList(List list) {
        this.__m_RedirectList = list;
    }

    public void setRedirectSupported(boolean f) {
        this.__m_RedirectSupported = f;
    }

    public void setSelectionKey(SelectionKey key) {
        this.__m_SelectionKey = key;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setSocketChannel(SocketChannel channel) {
        this.__m_SocketChannel = channel;
    }

    public void setStatsBytesQueued(long cb) {
        this.__m_StatsBytesQueued = cb;
    }

    public void setStatsQueued(long cMessage) {
        this.__m_StatsQueued = cMessage;
    }

    protected void setSuspect(boolean fSuspect) {
        this.__m_Suspect = fSuspect;
    }

    protected void setSuspectBytesWorseCount(int cChecks) {
        this.__m_SuspectBytesWorseCount = cChecks;
    }

    protected void setSuspectCheckCount(int cChecks) {
        this.__m_SuspectCheckCount = cChecks;
    }

    protected void setSuspectInitialBytes(long cb) {
        this.__m_SuspectInitialBytes = cb;
    }

    protected void setSuspectInitialLength(long c) {
        this.__m_SuspectInitialLength = c;
    }

    protected void setSuspectInitialMillis(long cMillis) {
        this.__m_SuspectInitialMillis = cMillis;
    }

    protected void setSuspectLatestBytes(long cb) {
        this.__m_SuspectLatestBytes = cb;
    }

    protected void setSuspectLatestLength(long c) {
        this.__m_SuspectLatestLength = c;
    }

    protected void setSuspectLatestMillis(long cMillis) {
        this.__m_SuspectLatestMillis = cMillis;
    }

    protected void setSuspectLengthWorseCount(int cChecks) {
        this.__m_SuspectLengthWorseCount = cChecks;
    }

    protected void setSuspectTargetBytes(long cb) {
        this.__m_SuspectTargetBytes = cb;
    }

    protected void setSuspectTargetLength(long c) {
        this.__m_SuspectTargetLength = c;
    }
}

