/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.logOutput;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.FileHelper;
import com.tangosol.coherence.component.util.LogOutput;
import com.tangosol.internal.net.logging.LoggingDependencies;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Standard
extends LogOutput {
    private int __m_LogLevel;
    private PrintStream __m_PrintStream;

    public Standard() {
        this(null, null, true);
    }

    public Standard(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void close() {
        super.close();
        PrintStream stream = this.getPrintStream();
        stream.flush();
        if (!(stream != System.out) ? false : stream != System.err) {
            stream.close();
        }
    }

    public void configure(LoggingDependencies deps) {
        super.configure(deps);
        PrintStream stream = null;
        String sDest = deps.getDestination();
        String sErr = null;
        if ("stdout".equalsIgnoreCase(sDest)) {
            stream = System.out;
        } else if ("stderr".equalsIgnoreCase(sDest)) {
            stream = System.err;
        } else {
            if (sDest != null) {
                try {
                    File file = new File(sDest).getCanonicalFile();
                    boolean fExists = file.exists();
                    if (!fExists ? false : file.isDirectory()) {
                        sErr = new StringBuilder(String.valueOf("\nThe specified log file \"")).append(file).append("\" refers to a directory").toString();
                    } else if (!(fExists ^ true) ? false : file.getParentFile().exists() ^ true) {
                        sErr = new StringBuilder(String.valueOf("\nThe parent directory of the specified log file \"")).append(file).append("\" does not exist").toString();
                    } else if (FileHelper.isFullyAccessible(file)) {
                        stream = new PrintStream(new FileOutputStream(file));
                    } else {
                        sErr = new StringBuilder(String.valueOf("\nThe specified log file \"")).append(file).append("\" appears to be locked by another process").toString();
                    }
                }
                catch (Exception e) {
                    sErr = new StringBuilder(String.valueOf("\nError opening the specified log file \"")).append(sDest).append("\" (").append(e.getMessage()).append(")").toString();
                }
            }
            if (stream == null) {
                if (sErr != null) {
                    sErr = new StringBuilder(String.valueOf(sErr)).append("; using System.out for log output instead.\n").toString();
                    System.err.println(sErr);
                }
                stream = System.out;
            }
        }
        this.setLogLevel(deps.getSeverityLevel());
        this.setPrintStream(stream);
    }

    public int getLogLevel() {
        return this.__m_LogLevel;
    }

    protected PrintStream getPrintStream() {
        return this.__m_PrintStream;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/logOutput/Standard".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Standard();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isEnabled(int nLevel) {
        return nLevel <= this.getLogLevel();
    }

    protected void log(Object oLevel, String sMessage) {
        this.log(oLevel, null, sMessage);
    }

    protected void log(Object oLevel, Throwable throwable) {
        this.log(oLevel, throwable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(Object oLevel, Throwable throwable, String sMessage) {
        PrintStream stream;
        PrintStream printStream = stream = this.getPrintStream();
        synchronized (printStream) {
            if (sMessage != null) {
                stream.println(sMessage);
            }
            if (throwable != null) {
                throwable.printStackTrace(stream);
            }
            stream.flush();
        }
    }

    public void setLogLevel(int nLevel) {
        this.__m_LogLevel = nLevel;
    }

    protected void setPrintStream(PrintStream stream) {
        this.__m_PrintStream = stream;
    }

    protected Object translateLevel(Integer ILevel) {
        return ILevel;
    }
}

