/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.EnvironmentVariableResolver;
import com.tangosol.coherence.config.SystemPropertyResolver;
import java.util.function.Supplier;

public abstract class Config {
    private static final SystemPropertyResolver SYS_PROPS = SystemPropertyResolver.getInstance();
    private static final EnvironmentVariableResolver ENV_VARS = EnvironmentVariableResolver.getInstance();

    public static String getProperty(String sName) {
        return Config.getPropertyInternal(sName, SYS_PROPS, ENV_VARS);
    }

    public static String getProperty(String sName, String sDefault) {
        String sValue = Config.getProperty(sName);
        return sValue == null ? sDefault : sValue;
    }

    public static String getProperty(String sName, Supplier<String> supDefault) {
        String sValue = Config.getProperty(sName);
        return sValue == null ? supDefault.get() : sValue;
    }

    public static boolean getBoolean(String sName) {
        return Config.getBoolean(sName, false);
    }

    public static boolean getBoolean(String sName, boolean fDefault) {
        String sValue = Config.getProperty(sName);
        return sValue == null ? fDefault : Boolean.parseBoolean(sValue);
    }

    public static Integer getInteger(String sName) {
        String sValue = Config.getProperty(sName);
        try {
            return sValue == null ? null : Integer.valueOf(Integer.parseInt(sValue));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Integer getInteger(String sName, int iDefault) {
        Integer i = Config.getInteger(sName);
        return i == null ? Integer.valueOf(iDefault) : i;
    }

    public static Long getLong(String sName) {
        String sValue = Config.getProperty(sName);
        try {
            return sValue == null ? null : Long.valueOf(Long.parseLong(Config.getProperty(sName)));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Long getLong(String sName, long lDefault) {
        Long l = Config.getLong(sName);
        return l == null ? Long.valueOf(lDefault) : l;
    }

    public static Float getFloat(String sName) {
        String sValue = Config.getProperty(sName);
        try {
            return sValue == null ? null : Float.valueOf(Float.parseFloat(Config.getProperty(sName)));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Float getFloat(String sName, float fDefault) {
        Float d = Config.getFloat(sName);
        return d == null ? new Float(fDefault) : d;
    }

    public static Double getDouble(String sName) {
        String sValue = Config.getProperty(sName);
        try {
            return sValue == null ? null : Double.valueOf(Double.parseDouble(sValue));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Double getDouble(String sName, double dDefault) {
        Double d = Config.getDouble(sName);
        return d == null ? new Double(dDefault) : d;
    }

    public static Duration getDuration(String sName) {
        String sValue = Config.getProperty(sName);
        try {
            return sValue == null || sValue.isEmpty() ? null : new Duration(sValue);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Duration getDuration(String sName, Duration dDefault) {
        Duration d = Config.getDuration(sName);
        return d == null ? dDefault : d;
    }

    public static String getenv(String sName) {
        return Config.getEnvInternal(sName, ENV_VARS);
    }

    static String getPropertyInternal(String sName, SystemPropertyResolver sysProps, EnvironmentVariableResolver envVars) {
        String sValue = sysProps.getProperty(sName);
        if (sValue == null) {
            if (sName.startsWith("coherence.")) {
                sValue = Config.getPropertyBackwardsCompatibleMode(sName, sysProps);
            } else if (sName.startsWith("tangosol.coherence.")) {
                sValue = sysProps.getProperty(sName.replaceFirst("tangosol.", ""));
            } else if (sName.startsWith("tangosol.")) {
                sValue = sysProps.getProperty(sName.replaceFirst("tangosol", "coherence"));
            }
        }
        if (sValue == null) {
            sValue = Config.getEnvInternal(sName, envVars);
        }
        return sValue;
    }

    static String getEnvInternal(String sName, EnvironmentVariableResolver envVars) {
        String sNameUpper;
        String sValue = envVars.getEnv(sName);
        if (sValue == null) {
            if (sName.startsWith("coherence.")) {
                sValue = Config.getEnvironmentBackwardsCompatibleMode(sName, envVars);
            } else if (sName.startsWith("tangosol.coherence.")) {
                sValue = envVars.getEnv(sName.replaceFirst("tangosol.", ""));
            } else if (sName.startsWith("tangosol.")) {
                sValue = envVars.getEnv(sName.replaceFirst("tangosol", "coherence"));
            }
        }
        if (sValue == null && (sValue = envVars.getEnv(sNameUpper = sName.toUpperCase().replaceAll("\\.", "_"))) == null) {
            if (sNameUpper.startsWith("COHERENCE_")) {
                sValue = envVars.getEnv("TANGOSOL_" + sNameUpper);
                return sValue == null ? envVars.getEnv(sNameUpper.replaceFirst("COHERENCE", "TANGOSOL")) : sValue;
            }
            if (sNameUpper.startsWith("TANGOSOL_COHERENCE_")) {
                return envVars.getEnv(sNameUpper.replaceFirst("TANGOSOL_", ""));
            }
            if (sNameUpper.startsWith("TANGOSOL_")) {
                return envVars.getEnv(sNameUpper.replaceFirst("TANGOSOL", "COHERENCE"));
            }
        }
        return sValue;
    }

    private static String getPropertyBackwardsCompatibleMode(String sName, SystemPropertyResolver sysProps) {
        String sValue = sysProps.getProperty("tangosol." + sName);
        return sValue == null ? sysProps.getProperty(sName.replaceFirst("coherence", "tangosol")) : sValue;
    }

    private static String getEnvironmentBackwardsCompatibleMode(String sName, EnvironmentVariableResolver envVars) {
        String sValue = envVars.getEnv("tangosol." + sName);
        return sValue == null ? envVars.getEnv(sName.replaceFirst("coherence", "tangosol")) : sValue;
    }
}

