/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;

public interface SystemPropertyResolver {
    public String getProperty(String var1);

    default public String getProperty(String sPropertyName, String sDefaultValue) {
        return Optional.ofNullable(this.getProperty(sPropertyName)).orElse(sDefaultValue);
    }

    public static SystemPropertyResolver getInstance() {
        ServiceLoader<SystemPropertyResolver> serviceLoader = ServiceLoader.load(SystemPropertyResolver.class);
        Iterator<SystemPropertyResolver> resolvers = serviceLoader.iterator();
        return resolvers.hasNext() ? resolvers.next() : new Default();
    }

    public static class Default
    implements SystemPropertyResolver {
        @Override
        public String getProperty(String sPropertyName) {
            return System.getProperty(sPropertyName);
        }
    }
}

