/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.builder.SubscriberGroupBuilder;
import com.tangosol.coherence.config.scheme.Scheme;
import com.tangosol.coherence.config.scheme.TopicScheme;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.util.ClassHelper;
import java.util.Collection;
import java.util.LinkedList;

public class TopicMapping
extends ResourceMapping {
    private String m_sNameValueClass;
    private final Class<? extends TopicScheme> f_clsSchemeType;
    private Collection<SubscriberGroupBuilder> m_colSubscriberGroupBuilder = new LinkedList<SubscriberGroupBuilder>();

    public TopicMapping(String sTopicNamePattern, String sCachingSchemeName, Class<? extends TopicScheme> clsScheme) {
        super(sTopicNamePattern, sCachingSchemeName);
        this.f_clsSchemeType = clsScheme;
        this.m_sNameValueClass = null;
    }

    @Override
    public String getConfigElementName() {
        return "topic-name";
    }

    @Override
    public void validateScheme(Scheme scheme) {
        if (this.f_clsSchemeType == null || this.f_clsSchemeType.isAssignableFrom(scheme.getClass())) {
            return;
        }
        String sElement = this.getConfigElementName();
        String sPattern = this.getNamePattern();
        String sScheme = scheme.getSchemeName();
        String sMsg = String.format("Mapping <%s>%s</%s> maps to scheme %s, which is not a valid %s", sScheme, sElement, sPattern, sElement, this.f_clsSchemeType.getSimpleName());
        throw new IllegalStateException(sMsg);
    }

    public String getValueClassName() {
        return this.m_sNameValueClass;
    }

    @Injectable(value="value-type")
    public void setValueClassName(String sElementClassName) {
        this.m_sNameValueClass = ClassHelper.getFullyQualifiedClassNameOf(sElementClassName);
    }

    public boolean usesRawTypes() {
        return this.m_sNameValueClass == null;
    }

    @Injectable(value="subscriber-groups")
    public void setSubscriberGroupBuilders(Collection<SubscriberGroupBuilder> colBuilders) {
        this.m_colSubscriberGroupBuilder.addAll(colBuilders);
    }

    public Collection<SubscriberGroupBuilder> getSubscriberGroupBuilders() {
        return this.m_colSubscriberGroupBuilder;
    }
}

