/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.ConfigurableAddressProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.RefreshableAddressProvider;
import java.util.ArrayList;
import java.util.List;

public class ListBasedAddressProviderBuilder
implements AddressProviderBuilder {
    private List<ConfigurableAddressProvider.AddressHolder> m_listAddress = new ArrayList<ConfigurableAddressProvider.AddressHolder>();
    private boolean m_fRefreshable = false;

    @Override
    public AddressProvider realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        this.validate();
        ConfigurableAddressProvider provider = new ConfigurableAddressProvider(this.m_listAddress, true);
        return this.m_fRefreshable ? new RefreshableAddressProvider(provider) : provider;
    }

    @Override
    public AddressProvider createAddressProvider(ClassLoader loader) {
        return this.realize(null, loader, null);
    }

    public ListBasedAddressProviderBuilder add(String sAddr, int nPort) {
        this.m_fRefreshable |= sAddr != null && InetAddressHelper.isHostName(sAddr);
        this.m_listAddress.add(new ConfigurableAddressProvider.AddressHolder(sAddr, nPort));
        return this;
    }

    public boolean isRefreshable() {
        return this.m_fRefreshable;
    }

    private void validate() {
        for (ConfigurableAddressProvider.AddressHolder holder : this.m_listAddress) {
            try {
                holder.validate();
            }
            catch (Exception e) {
                throw new ConfigurationException("invalid address in AddressListProviderBuilder", "fix constraint violation", e);
            }
        }
    }
}

