/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.AddressProvider;
import com.tangosol.run.xml.XmlElement;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class LocalAddressProviderBuilder
implements AddressProviderBuilder {
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    private String m_sAddr;
    private InetAddress m_addr;
    private int m_nPortMax;
    private int m_nPortMin;
    private int m_nPortMinOriginal;
    private XmlElement m_xmlConfig = null;

    private LocalAddressProviderBuilder(InetAddress addr, String sAddr, int nPortMin, int nPortMax, XmlElement xmlConfig) {
        assert (this.m_addr == null || this.m_sAddr == null);
        this.m_addr = addr;
        this.m_sAddr = sAddr;
        this.m_nPortMin = nPortMin;
        this.m_nPortMinOriginal = nPortMin;
        this.m_nPortMax = nPortMax;
        this.m_xmlConfig = xmlConfig;
    }

    public LocalAddressProviderBuilder(InetAddress addr, int nPortMin, int nPortMax) {
        this(addr, null, nPortMin, nPortMax, null);
    }

    public LocalAddressProviderBuilder(String sAddr, int nPortMin, int nPortMax, XmlElement xmlConfig) {
        this(null, sAddr, nPortMin, nPortMax, xmlConfig);
    }

    public LocalAddressProviderBuilder(String sAddr, int nPortMin, int nPortMax) {
        this(sAddr, nPortMin, nPortMax, null);
    }

    @Override
    public AddressProvider realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        this.resolveAddress();
        this.validate();
        return new AddressProvider(){
            int m_nPort;
            {
                this.m_nPort = LocalAddressProviderBuilder.this.m_nPortMin;
            }

            @Override
            public InetSocketAddress getNextAddress() {
                if (this.m_nPort > LocalAddressProviderBuilder.this.m_nPortMax) {
                    this.m_nPort = LocalAddressProviderBuilder.this.m_nPortMin;
                    return null;
                }
                return new InetSocketAddress(LocalAddressProviderBuilder.this.m_addr, this.m_nPort++);
            }

            @Override
            public void accept() {
                this.m_nPort = LocalAddressProviderBuilder.this.m_nPortMin;
            }

            @Override
            public void reject(Throwable eCause) {
            }

            public String toString() {
                return "LocalAddressProvider[" + LocalAddressProviderBuilder.this.m_addr + ":" + LocalAddressProviderBuilder.this.m_nPortMin + (LocalAddressProviderBuilder.this.m_nPortMin == LocalAddressProviderBuilder.this.m_nPortMax ? "]" : " .. " + LocalAddressProviderBuilder.this.m_nPortMax + "]");
            }
        };
    }

    @Override
    public AddressProvider createAddressProvider(ClassLoader loader) {
        return this.realize(null, loader, null);
    }

    public InetAddress resolveAddress() {
        if (this.m_addr == null && this.m_sAddr != null && !this.m_sAddr.isEmpty()) {
            try {
                this.m_addr = InetAddresses.getLocalAddress(this.m_sAddr);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.m_addr;
    }

    public LocalAddressProviderBuilder setAddress(InetAddress addr) {
        this.m_addr = addr;
        return this;
    }

    public int getPortMin() {
        return this.m_nPortMin;
    }

    public LocalAddressProviderBuilder setPortMin(int nPort) {
        this.m_nPortMin = nPort;
        return this;
    }

    public int getPortMinOriginal() {
        return this.m_nPortMinOriginal;
    }

    public LocalAddressProviderBuilder setPortMax(int nPort) {
        this.m_nPortMax = nPort;
        return this;
    }

    private void validate() {
        if (this.m_nPortMin < 0 || this.m_nPortMin > 65535) {
            throw new ConfigurationException("Invalid <local-address> configuration [" + this.m_xmlConfig + "]", "Please specify a valid <port>, invalid value is " + this.m_nPortMin);
        }
        if (this.m_nPortMax < this.m_nPortMin || this.m_nPortMax > 65535) {
            throw new ConfigurationException("Invalid <local-address> configuration [" + this.m_xmlConfig + "]", "Please specify a valid <port-auto-adjust>, port-auto-adjust is " + this.m_nPortMax + " and port value is " + this.m_nPortMin);
        }
    }
}

