/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.MapListener;
import java.util.Map;

public interface MapBuilder {
    public Map realizeMap(ParameterResolver var1, Dependencies var2);

    public static class Dependencies {
        private boolean m_fBackup;
        private boolean m_fBinaryMap;
        private boolean m_fBlind;
        private ConfigurableCacheFactory m_ccf;
        private BackingMapManagerContext m_ctxBackingMapManager;
        private String m_sCacheName;
        private ClassLoader m_contextClassLoader;
        private String m_sServiceType;
        Map<Map, MapListener> m_mapMapListeners;

        public Dependencies(ConfigurableCacheFactory ccf, BackingMapManagerContext ctxBackingMapManager, ClassLoader loader, String sCacheName, String sServiceType) {
            this(ccf, ctxBackingMapManager, loader, sCacheName, sServiceType, null);
        }

        public Dependencies(ConfigurableCacheFactory ccf, BackingMapManagerContext ctxBackingMapManager, ClassLoader loader, String sCacheName, String sServiceType, Map<Map, MapListener> mapMapListeners) {
            this.m_ccf = ccf;
            this.m_ctxBackingMapManager = ctxBackingMapManager;
            this.m_contextClassLoader = loader == null ? Base.getContextClassLoader() : loader;
            this.m_sCacheName = sCacheName;
            this.m_sServiceType = sServiceType;
            this.m_fBinaryMap = ctxBackingMapManager != null && "DistributedCache".equals(sServiceType);
            this.m_mapMapListeners = mapMapListeners;
        }

        public boolean isBinary() {
            return this.m_fBinaryMap;
        }

        public boolean isBackup() {
            return this.m_fBackup;
        }

        public void setBackup(boolean fBackup) {
            this.m_fBackup = fBackup;
        }

        public boolean isBlind() {
            return this.m_fBlind;
        }

        public void setBlind(boolean fBlind) {
            this.m_fBlind = fBlind;
        }

        public BackingMapManagerContext getBackingMapManagerContext() {
            return this.m_ctxBackingMapManager;
        }

        public String getCacheName() {
            return this.m_sCacheName;
        }

        public ConfigurableCacheFactory getConfigurableCacheFactory() {
            return this.m_ccf;
        }

        public ClassLoader getClassLoader() {
            return this.m_contextClassLoader;
        }

        public String getServiceType() {
            return this.m_sServiceType;
        }

        public Map<Map, MapListener> getMapListenersRegistry() {
            return this.m_mapMapListeners;
        }
    }
}

