/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.Value;
import com.tangosol.util.ClassHelper;
import java.lang.reflect.Type;
import java.util.Map;

public class ParameterizedBuilderHelper {
    public static Object getAssignableValue(Class<?> clzRequiredType, Parameter parameter, ParameterResolver resolver, ClassLoader loader) throws ClassCastException {
        Value value = parameter.evaluate(resolver);
        if (value == null || value.isNull()) {
            return null;
        }
        if (clzRequiredType.isAssignableFrom(Value.class)) {
            return value;
        }
        Object oValue = value.get();
        Class<?> clzValue = oValue.getClass();
        if (clzRequiredType.isAssignableFrom(clzValue) || clzRequiredType.isPrimitive() && ParameterizedBuilderHelper.isAssignablePrimitive(clzRequiredType, clzValue)) {
            return oValue;
        }
        if (oValue instanceof ParameterizedBuilder) {
            Object object = ((ParameterizedBuilder)oValue).realize(resolver, loader, null);
            if (clzRequiredType.isAssignableFrom(object.getClass()) || clzRequiredType.isPrimitive() && ParameterizedBuilderHelper.isAssignablePrimitive(clzRequiredType, object.getClass())) {
                return object;
            }
            throw new ClassCastException(String.format("Can't coerce [%s] into a [%s].", object.getClass().getCanonicalName(), clzRequiredType.getCanonicalName()));
        }
        if (parameter.isExplicitlyTyped()) {
            Class<?> clzParameterType = parameter.getExplicitType();
            if (clzRequiredType.isAssignableFrom(clzParameterType) || clzRequiredType.isPrimitive() && ParameterizedBuilderHelper.isAssignablePrimitive(clzRequiredType, clzParameterType)) {
                return value.as(clzParameterType);
            }
            throw new ClassCastException(String.format("Can't coerce [%s] into a [%s].", value, clzParameterType));
        }
        return value.as(clzRequiredType);
    }

    public static boolean isAssignablePrimitive(Class<?> clzPrimitive, Class<?> clzWrapper) {
        return clzPrimitive.equals(Boolean.TYPE) && clzWrapper.equals(Boolean.class) || clzPrimitive.equals(Byte.TYPE) && clzWrapper.equals(Byte.class) || clzPrimitive.equals(Character.TYPE) && clzWrapper.equals(Character.class) || clzPrimitive.equals(Double.TYPE) && clzWrapper.equals(Double.class) || clzPrimitive.equals(Float.TYPE) && clzWrapper.equals(Float.class) || clzPrimitive.equals(Integer.TYPE) && clzWrapper.equals(Integer.class) || clzPrimitive.equals(Long.TYPE) && clzWrapper.equals(Long.class) || clzPrimitive.equals(Short.TYPE) && clzWrapper.equals(Short.class);
    }

    @Deprecated
    public static boolean realizes(ParameterizedBuilder<?> bldr, Class<?> clzClass, ParameterResolver resolver, ClassLoader loader) {
        Type[] aTypes;
        if (bldr == null) {
            return false;
        }
        if (bldr instanceof ParameterizedBuilder.ReflectionSupport) {
            ParameterizedBuilder.ReflectionSupport reflectionSupport = (ParameterizedBuilder.ReflectionSupport)((Object)bldr);
            return reflectionSupport.realizes(clzClass, resolver, loader);
        }
        Map<String, Type[]> mapTypes = ClassHelper.getReifiedTypes(bldr.getClass(), ParameterizedBuilder.class);
        if (mapTypes.containsKey("T") && (aTypes = mapTypes.get("T")).length == 1 && aTypes[0] instanceof Type) {
            Class<?> clzBuilt = ClassHelper.getClass(aTypes[0]);
            return clzClass.isAssignableFrom(clzBuilt);
        }
        return false;
    }
}

