/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.DefaultBuilderCustomization;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.partition.MirroringAssignmentStrategy;
import com.tangosol.net.partition.PartitionAssignmentStrategy;
import com.tangosol.net.partition.SimpleAssignmentStrategy;
import com.tangosol.run.xml.XmlElement;

public class PartitionAssignmentStrategyBuilder
extends DefaultBuilderCustomization<PartitionAssignmentStrategy>
implements ParameterizedBuilder<PartitionAssignmentStrategy> {
    private ParameterizedBuilder<?> m_builder;
    private XmlElement m_xmlElement;
    private String m_sStrategy;

    public PartitionAssignmentStrategyBuilder(ParameterizedBuilder<?> bldr, XmlElement xmlElement) {
        this.m_builder = bldr;
        this.m_sStrategy = null;
        this.m_xmlElement = xmlElement;
    }

    public PartitionAssignmentStrategyBuilder(String sStrategy, XmlElement xmlElement) {
        this.m_sStrategy = sStrategy;
        this.m_xmlElement = xmlElement;
        this.m_builder = null;
    }

    @Override
    public PartitionAssignmentStrategy realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        ParameterizedBuilder<?> builder = this.m_builder;
        String sPAS = this.m_sStrategy;
        XmlElement xmlPAS = this.m_xmlElement;
        if (builder != null) {
            try {
                return (PartitionAssignmentStrategy)builder.realize(resolver, loader, listParameters);
            }
            catch (Exception e) {
                String sName = xmlPAS == null ? "" : xmlPAS.getName();
                throw new ConfigurationException("Invalid <" + sName + "> declaration.  The specified builder doesn't produce a PartitionAssignmentStrategy in [" + xmlPAS + "]", "Please specify a <" + sName + ">", e);
            }
        }
        if ("simple".equals(sPAS)) {
            return new SimpleAssignmentStrategy();
        }
        if (sPAS != null && sPAS.startsWith("mirror:")) {
            return new MirroringAssignmentStrategy(sPAS.substring(7).trim());
        }
        throw new ConfigurationException("Invalid <partition-assignment-strategy> declaration of '" + sPAS + "' in [" + xmlPAS + "]", "Please specify a valid partition-assignment-strategy");
    }
}

