/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.SimpleParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderHelper;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.json.bind.annotation.JsonbProperty;

public class StaticFactoryInstanceBuilder<T>
implements ParameterizedBuilder<T>,
ParameterizedBuilder.ReflectionSupport,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="exprFactoryClassName")
    private Expression<String> m_exprFactoryClassName = new LiteralExpression<String>("undefined");
    @JsonbProperty(value="exprFactoryMethodName")
    private Expression<String> m_exprFactoryMethodName = new LiteralExpression<String>("undefined");
    @JsonbProperty(value="methodParameters")
    private ParameterList m_listMethodParameters = new SimpleParameterList();

    @Injectable(value="class-factory-name")
    public void setFactoryClassName(Expression<String> exprFactoryClassName) {
        this.m_exprFactoryClassName = exprFactoryClassName;
    }

    @Injectable(value="method-name")
    public void setFactoryMethodName(Expression<String> exprFactoryMethodName) {
        this.m_exprFactoryMethodName = exprFactoryMethodName;
    }

    @Injectable(value="init-params")
    public void setFactoryMethodParameters(ParameterList listParameters) {
        if (listParameters != null) {
            this.m_listMethodParameters = listParameters;
        }
    }

    protected ClassLoader ensureClassLoader(ClassLoader loader) {
        return loader == null ? this.getClass().getClassLoader() : loader;
    }

    @Override
    public T realize(ParameterResolver resolver, ClassLoader loader, ParameterList listMethodParameters) {
        try {
            loader = this.ensureClassLoader(loader);
            String sClassName = this.m_exprFactoryClassName.evaluate(resolver);
            Class<?> clzFactory = loader.loadClass(sClassName);
            ParameterList listParameters = listMethodParameters == null ? this.m_listMethodParameters : listMethodParameters;
            String sMethodName = this.m_exprFactoryMethodName.evaluate(resolver);
            int cMethodParameters = listParameters.size();
            Method compatibleMethod = null;
            Object[] aMethodParameters = cMethodParameters == 0 ? null : new Object[cMethodParameters];
            Method[] aMethods = clzFactory.getMethods();
            for (int i = 0; i < aMethods.length && compatibleMethod == null; ++i) {
                if (!aMethods[i].getName().equals(sMethodName) || aMethods[i].getParameterTypes().length != cMethodParameters || !Modifier.isStatic(aMethods[i].getModifiers()) || aMethods[i].getReturnType() == null) continue;
                Class<?>[] aMethodParameterTypes = aMethods[i].getParameterTypes();
                boolean fIsCompatible = true;
                try {
                    int j = 0;
                    for (Parameter parameter : listParameters) {
                        aMethodParameters[j] = ParameterizedBuilderHelper.getAssignableValue(aMethodParameterTypes[j], parameter, resolver, loader);
                        ++j;
                    }
                }
                catch (Exception exception) {
                    fIsCompatible = false;
                }
                if (!fIsCompatible) continue;
                compatibleMethod = aMethods[i];
            }
            if (compatibleMethod == null) {
                throw new NoSuchMethodException(String.format("Unable to find a compatible method for [%s] with the parameters [%s]", sMethodName, listParameters));
            }
            return (T)compatibleMethod.invoke(clzFactory, aMethodParameters);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public boolean realizes(Class<?> clzClass, ParameterResolver resolver, ClassLoader loader) {
        try {
            loader = this.ensureClassLoader(loader);
            String sClassName = this.m_exprFactoryClassName.evaluate(resolver);
            Class<?> clzFactory = loader.loadClass(sClassName);
            String sMethodName = this.m_exprFactoryMethodName.evaluate(resolver);
            Method compatibleMethod = null;
            for (Method method : clzFactory.getMethods()) {
                if (!method.getName().equals(sMethodName) || !Modifier.isStatic(method.getModifiers()) || method.getReturnType() == null || !clzClass.isAssignableFrom(method.getReturnType())) continue;
                compatibleMethod = method;
                break;
            }
            return compatibleMethod != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_exprFactoryClassName = (Expression)ExternalizableHelper.readObject(in, null);
        this.m_exprFactoryMethodName = (Expression)ExternalizableHelper.readObject(in, null);
        this.m_listMethodParameters = (ParameterList)ExternalizableHelper.readObject(in, null);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_exprFactoryClassName);
        ExternalizableHelper.writeObject(out, this.m_exprFactoryMethodName);
        ExternalizableHelper.writeObject(out, this.m_listMethodParameters);
    }

    @Override
    public void readExternal(PofReader reader) throws IOException {
        this.m_exprFactoryClassName = (Expression)reader.readObject(0);
        this.m_exprFactoryMethodName = (Expression)reader.readObject(1);
        this.m_listMethodParameters = (ParameterList)reader.readObject(2);
    }

    @Override
    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.m_exprFactoryClassName);
        writer.writeObject(1, this.m_exprFactoryMethodName);
        writer.writeObject(2, this.m_listMethodParameters);
    }
}

