/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder.storemanager;

import com.oracle.coherence.common.util.MemorySize;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.storemanager.AbstractStoreManagerBuilder;
import com.tangosol.coherence.config.builder.storemanager.BinaryStoreManagerBuilder;
import com.tangosol.coherence.config.builder.storemanager.BinaryStoreManagerBuilderCustomization;
import com.tangosol.coherence.config.unit.Bytes;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.AsyncBinaryStoreManager;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.util.Base;

public class AsyncStoreManagerBuilder
extends AbstractStoreManagerBuilder<AsyncBinaryStoreManager>
implements BinaryStoreManagerBuilderCustomization {
    private BinaryStoreManagerBuilder m_bldrStoreManager;
    private Expression<Bytes> m_exprAsyncLimit = new LiteralExpression<Bytes>(new Bytes(new MemorySize("4MB")));

    @Override
    public BinaryStoreManager realize(ParameterResolver resolver, ClassLoader loader, boolean fPaged) {
        this.validate(resolver);
        int cbMaxAsync = (int)this.getAsyncLimit(resolver);
        BinaryStoreManager asyncManager = null;
        BinaryStoreManager storeManager = this.getBinaryStoreManagerBuilder().realize(resolver, loader, fPaged);
        ParameterizedBuilder bldrCustom = this.getCustomBuilder();
        if (bldrCustom == null) {
            asyncManager = cbMaxAsync <= 0 ? new AsyncBinaryStoreManager(storeManager) : new AsyncBinaryStoreManager(storeManager, cbMaxAsync);
        } else {
            ResolvableParameterList listArgs = new ResolvableParameterList();
            listArgs.add(new Parameter("store-manager", storeManager));
            if (cbMaxAsync <= 0) {
                listArgs.add(new Parameter("async-limit", cbMaxAsync));
            }
            asyncManager = (BinaryStoreManager)bldrCustom.realize(resolver, loader, listArgs);
        }
        return asyncManager;
    }

    @Override
    public BinaryStoreManagerBuilder getBinaryStoreManagerBuilder() {
        return this.m_bldrStoreManager;
    }

    @Override
    public void setBinaryStoreManagerBuilder(BinaryStoreManagerBuilder bldr) {
        this.m_bldrStoreManager = bldr;
    }

    public long getAsyncLimit(ParameterResolver resolver) {
        return this.m_exprAsyncLimit.evaluate(resolver).getByteCount();
    }

    @Injectable
    public void setAsyncLimit(Expression<Bytes> expr) {
        this.m_exprAsyncLimit = expr;
    }

    @Override
    protected void validate(ParameterResolver resolver) {
        super.validate(resolver);
        Base.checkNotNull(this.getBinaryStoreManagerBuilder(), "StoreMangerBuilder");
    }
}

