/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.tangosol.coherence.config.unit.Millis;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.net.cache.BundlingNamedCache;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.util.Base;
import java.util.ArrayList;

public class BundleManager {
    private ArrayList<BundleConfig> m_listConfig = new ArrayList();

    @Injectable
    public void addConfig(BundleConfig config) {
        this.m_listConfig.add(config);
    }

    public void ensureBundles(ParameterResolver resolver, BundlingNamedCache cache) {
        for (BundleConfig config : this.m_listConfig) {
            config.validate(resolver);
            String sOperation = config.getOperationName(resolver);
            int cBundle = config.getPreferredSize(resolver);
            if (sOperation.equals("all")) {
                this.initializeBundler(resolver, cache.ensureGetBundler(cBundle), config);
                this.initializeBundler(resolver, cache.ensurePutBundler(cBundle), config);
                this.initializeBundler(resolver, cache.ensureRemoveBundler(cBundle), config);
                continue;
            }
            if (sOperation.equals("get")) {
                this.initializeBundler(resolver, cache.ensureGetBundler(cBundle), config);
                continue;
            }
            if (sOperation.equals("put")) {
                this.initializeBundler(resolver, cache.ensurePutBundler(cBundle), config);
                continue;
            }
            if (sOperation.equals("remove")) {
                this.initializeBundler(resolver, cache.ensureRemoveBundler(cBundle), config);
                continue;
            }
            throw new IllegalArgumentException("Invalid bundler \"operation-name\" :\n" + sOperation);
        }
    }

    public void ensureBundles(ParameterResolver resolver, ReadWriteBackingMap.StoreWrapper wrapperStore) {
        for (BundleConfig config : this.m_listConfig) {
            config.validate(resolver);
            String sOperation = config.getOperationName(resolver);
            int cBundle = config.getPreferredSize(resolver);
            if (sOperation.equals("all")) {
                this.initializeBundler(resolver, wrapperStore.ensureLoadBundler(cBundle), config);
                this.initializeBundler(resolver, wrapperStore.ensureStoreBundler(cBundle), config);
                this.initializeBundler(resolver, wrapperStore.ensureEraseBundler(cBundle), config);
                continue;
            }
            if (sOperation.equals("load")) {
                this.initializeBundler(resolver, wrapperStore.ensureLoadBundler(cBundle), config);
                continue;
            }
            if (sOperation.equals("store")) {
                this.initializeBundler(resolver, wrapperStore.ensureStoreBundler(cBundle), config);
                continue;
            }
            if (sOperation.equals("erase")) {
                this.initializeBundler(resolver, wrapperStore.ensureEraseBundler(cBundle), config);
                continue;
            }
            throw new IllegalArgumentException("Invalid bundler \"operation-name\" :\n" + sOperation);
        }
    }

    protected void initializeBundler(ParameterResolver resolver, AbstractBundler bundler, BundleConfig config) {
        if (bundler != null) {
            bundler.setThreadThreshold(config.getThreadThreshold(resolver));
            bundler.setDelayMillis(config.getDelayMillis(resolver));
            bundler.setAllowAutoAdjust(config.isAutoAdjust(resolver));
        }
    }

    public static class BundleConfig {
        private Expression<Boolean> m_exprAutoAdjust = new LiteralExpression<Boolean>(Boolean.FALSE);
        private Expression<Millis> m_exprDelay = new LiteralExpression<Millis>(new Millis("1"));
        private Expression<String> m_exprOperationName = new LiteralExpression<String>("all");
        private Expression<Integer> m_exprPreferredSize = new LiteralExpression<Integer>(0);
        private Expression<Integer> m_exprThreadThreshold = new LiteralExpression<Integer>(4);

        public boolean isAutoAdjust(ParameterResolver resolver) {
            return this.m_exprAutoAdjust.evaluate(resolver);
        }

        @Injectable
        public void setAutoAdjust(Expression<Boolean> expr) {
            this.m_exprAutoAdjust = expr;
        }

        public long getDelayMillis(ParameterResolver resolver) {
            return this.m_exprDelay.evaluate(resolver).get();
        }

        @Injectable
        public void setDelayMillis(Expression<Millis> expr) {
            this.m_exprDelay = expr;
        }

        public String getOperationName(ParameterResolver resolver) {
            return this.m_exprOperationName.evaluate(resolver);
        }

        @Injectable
        public void setOperationName(Expression<String> expr) {
            this.m_exprOperationName = expr;
        }

        public int getPreferredSize(ParameterResolver resolver) {
            return this.m_exprPreferredSize.evaluate(resolver);
        }

        @Injectable
        public void setPreferredSize(Expression<Integer> expr) {
            this.m_exprPreferredSize = expr;
        }

        public int getThreadThreshold(ParameterResolver resolver) {
            return this.m_exprThreadThreshold.evaluate(resolver);
        }

        @Injectable
        public void setThreadThreshold(Expression<Integer> expr) {
            this.m_exprThreadThreshold = expr;
        }

        protected void validate(ParameterResolver resolver) {
            Base.checkNotEmpty(this.getOperationName(resolver), "OperationName");
        }
    }
}

