/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.UnitCalculatorBuilder;
import com.tangosol.coherence.config.builder.storemanager.BinaryStoreManagerBuilder;
import com.tangosol.coherence.config.builder.storemanager.BinaryStoreManagerBuilderCustomization;
import com.tangosol.coherence.config.scheme.AbstractLocalCachingScheme;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.coherence.config.unit.Units;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.io.BinaryStore;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.io.nio.BinaryMapStore;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OldCache;
import com.tangosol.net.cache.SerializationCache;
import com.tangosol.net.cache.SerializationMap;
import com.tangosol.net.cache.SimpleSerializationMap;
import com.tangosol.util.Base;
import java.util.Map;

public class ExternalScheme
extends AbstractLocalCachingScheme<Object>
implements BinaryStoreManagerBuilderCustomization {
    private UnitCalculatorBuilder m_bldrUnitCalculator;
    private BinaryStoreManagerBuilder m_bldrBinaryStoreManager;
    private Expression<Seconds> m_exprExpiryDelay = new LiteralExpression<Seconds>(new Seconds(0));
    private Expression<Units> m_exprHighUnits = new LiteralExpression<Units>(new Units(0L));
    private Expression<Integer> m_exprUnitFactor = new LiteralExpression<Integer>(1);

    @Override
    public Map realizeMap(ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        this.validate(resolver);
        Units highUnits = this.getHighUnits(resolver);
        ClassLoader loader = dependencies.getClassLoader();
        BinaryStoreManager storeManager = this.getBinaryStoreManagerBuilder().realize(resolver, loader, false);
        long cHighUnits = highUnits.getUnitCount();
        int nUnitFactor = this.getUnitFactor(resolver);
        while (cHighUnits >= Integer.MAX_VALUE) {
            cHighUnits /= 1024L;
            nUnitFactor *= 1024;
        }
        Map map = this.instantiateSerializationMap(resolver, storeManager.createBinaryStore(), dependencies.isBinary(), loader, (int)cHighUnits, (int)this.getExpiryDelay(resolver).as(Duration.Magnitude.MILLI));
        if (map instanceof ConfigurableCacheMap) {
            ((ConfigurableCacheMap)map).setUnitFactor(nUnitFactor);
            OldCache.UnitCalculator defaultCalculator = highUnits.isMemorySize() && dependencies.isBinary() ? LocalCache.INSTANCE_BINARY : null;
            UnitCalculatorBuilder bldrUnitCalculator = this.getUnitCalculatorBuilder();
            ((ConfigurableCacheMap)map).setUnitCalculator(bldrUnitCalculator == null ? defaultCalculator : bldrUnitCalculator.realize(resolver, loader, null));
        }
        return map;
    }

    @Override
    public BinaryStoreManagerBuilder getBinaryStoreManagerBuilder() {
        return this.m_bldrBinaryStoreManager;
    }

    @Override
    public void setBinaryStoreManagerBuilder(BinaryStoreManagerBuilder bldr) {
        this.m_bldrBinaryStoreManager = bldr;
    }

    public Seconds getExpiryDelay(ParameterResolver resolver) {
        return this.m_exprExpiryDelay.evaluate(resolver);
    }

    @Injectable
    public void setExpiryDelay(Expression<Seconds> expr) {
        this.m_exprExpiryDelay = expr;
    }

    public Units getHighUnits(ParameterResolver resolver) {
        return this.m_exprHighUnits.evaluate(resolver);
    }

    @Injectable
    public void setHighUnits(Expression<Units> expr) {
        this.m_exprHighUnits = expr;
    }

    public UnitCalculatorBuilder getUnitCalculatorBuilder() {
        return this.m_bldrUnitCalculator;
    }

    @Injectable(value="unit-calculator")
    public void setUnitCalculatorBuilder(UnitCalculatorBuilder bldr) {
        this.m_bldrUnitCalculator = bldr;
    }

    public int getUnitFactor(ParameterResolver resolver) {
        return this.m_exprUnitFactor.evaluate(resolver);
    }

    @Injectable
    public void setUnitFactor(Expression<Integer> expr) {
        this.m_exprUnitFactor = expr;
    }

    protected Map instantiateSerializationMap(ParameterResolver resolver, BinaryStore store, boolean fBinaryMap, ClassLoader loader, int cHighUnits, int cExpiryMillis) {
        ParameterizedBuilder bldrCustom = this.getCustomBuilder();
        if (bldrCustom == null) {
            if (cHighUnits > 0 || cExpiryMillis > 0) {
                SerializationCache cache;
                SerializationCache serializationCache = cache = fBinaryMap ? this.instantiateSerializationCache(store, cHighUnits, true) : this.instantiateSerializationCache(store, cHighUnits, loader);
                if (cExpiryMillis > 0) {
                    cache.setExpiryDelay(cExpiryMillis);
                }
                return cache;
            }
            if (fBinaryMap && store.getClass() == BinaryMapStore.class) {
                return ((BinaryMapStore)store).getBinaryMap();
            }
            return fBinaryMap ? this.instantiateSerializationMap(store, true) : this.instantiateSerializationMap(store, loader);
        }
        ResolvableParameterList listArgs = new ResolvableParameterList();
        listArgs.add(new Parameter("store", store));
        if (cHighUnits > 0 || cExpiryMillis > 0) {
            listArgs.add(new Parameter("high-units", cHighUnits));
            if (fBinaryMap) {
                listArgs.add(new Parameter("fBinary", fBinaryMap));
            } else {
                listArgs.add(new Parameter("loader", loader));
            }
            SerializationCache cache = (SerializationCache)bldrCustom.realize(resolver, loader, listArgs);
            if (cExpiryMillis > 0) {
                cache.setExpiryDelay(cExpiryMillis);
            }
            return cache;
        }
        if (fBinaryMap) {
            listArgs.add(new Parameter("fBinary", fBinaryMap));
        } else {
            listArgs.add(new Parameter("loader", loader));
        }
        Map map = (Map)bldrCustom.realize(resolver, loader, listArgs);
        if (map instanceof SerializationMap || map instanceof SimpleSerializationMap) {
            return map;
        }
        throw new IllegalArgumentException("Custom external cache does not extend either " + SerializationMap.class.getName() + " or " + SimpleSerializationMap.class.getName());
    }

    protected SerializationCache instantiateSerializationCache(BinaryStore store, int cMax, ClassLoader loader) {
        return new SerializationCache(store, cMax, loader);
    }

    protected SerializationCache instantiateSerializationCache(BinaryStore store, int cMax, boolean fBinaryMap) {
        return new SerializationCache(store, cMax, fBinaryMap);
    }

    protected SerializationMap instantiateSerializationMap(BinaryStore store, ClassLoader loader) {
        return new SerializationMap(store, loader);
    }

    protected SerializationMap instantiateSerializationMap(BinaryStore store, boolean fBinaryMap) {
        return new SerializationMap(store, fBinaryMap);
    }

    protected SimpleSerializationMap instantiateSimpleSerializationMap(BinaryStore store, ClassLoader loader) {
        return new SimpleSerializationMap(store, loader);
    }

    protected SimpleSerializationMap instantiateSimpleSerializationMap(BinaryStore store, boolean fBinaryMap) {
        return new SimpleSerializationMap(store, fBinaryMap);
    }

    @Override
    protected void validate(ParameterResolver resolver) {
        super.validate(resolver);
        Base.checkNotNull(this.m_bldrBinaryStoreManager, "BinaryStoreManager");
    }
}

