/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.scheme;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.EvictionPolicyBuilder;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.UnitCalculatorBuilder;
import com.tangosol.coherence.config.scheme.AbstractLocalCachingScheme;
import com.tangosol.coherence.config.scheme.CacheStoreScheme;
import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.coherence.config.unit.Units;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.injection.SimpleInjector;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OldCache;
import com.tangosol.util.Base;
import com.tangosol.util.ResourceResolver;
import com.tangosol.util.ResourceResolverHelper;

public class LocalScheme
extends AbstractLocalCachingScheme<LocalCache> {
    private CacheStoreScheme m_schemeCacheStore;
    private UnitCalculatorBuilder m_bldrUnitCalculator;
    private EvictionPolicyBuilder m_bldrEvictionPolicy;
    private Expression<Seconds> m_exprExpiryDelay = new LiteralExpression<Seconds>(new Seconds(0));
    private Expression<Units> m_exprHighUnits = new LiteralExpression<Units>(new Units(0L));
    private Expression<Units> m_exprLowUnits = new LiteralExpression<Units>(new Units(0L));
    private Expression<Boolean> m_exprPreload = new LiteralExpression<Boolean>(Boolean.FALSE);
    private Expression<Integer> m_exprUnitFactor = new LiteralExpression<Integer>(1);

    @Override
    public LocalCache realizeMap(ParameterResolver resolver, MapBuilder.Dependencies dependencies) {
        LocalCache cache;
        block16: {
            ConfigurableCacheMap.EvictionPolicy policy;
            Object loaderObj;
            this.validate(resolver);
            Units highUnits = this.getHighUnits(resolver);
            long cHighUnits = highUnits.getUnitCount();
            long cLowUnits = this.getLowUnits(resolver).getUnitCount();
            int nUnitFactor = this.getUnitFactor(resolver);
            int cExpiryDelayMillis = (int)this.getExpiryDelay(resolver).as(Duration.Magnitude.MILLI);
            while (cHighUnits >= Integer.MAX_VALUE) {
                cHighUnits /= 1024L;
                cLowUnits /= 1024L;
                nUnitFactor *= 1024;
            }
            if (cHighUnits <= 0L) {
                cHighUnits = Integer.MAX_VALUE;
            }
            if (cLowUnits <= 0L) {
                cLowUnits = (long)((double)cHighUnits * 0.8);
            }
            if (cExpiryDelayMillis < 0) {
                cExpiryDelayMillis = 0;
            }
            cache = null;
            ClassLoader loader = dependencies.getClassLoader();
            ParameterizedBuilder bldrCustom = this.getCustomBuilder();
            if (bldrCustom == null) {
                cache = new LocalCache((int)cHighUnits, cExpiryDelayMillis);
            } else {
                ResolvableParameterList listArgs = new ResolvableParameterList();
                listArgs.add(new Parameter("high-units", cHighUnits));
                listArgs.add(new Parameter("expiry-delay", cExpiryDelayMillis));
                cache = (LocalCache)bldrCustom.realize(resolver, loader, listArgs);
                SimpleInjector injector = new SimpleInjector();
                ResourceResolver resourceResolver = ResourceResolverHelper.resourceResolverFrom(ResourceResolverHelper.resourceResolverFrom(resolver, this.getDefaultParameterResolver()), ResourceResolverHelper.resourceResolverFrom(dependencies));
                injector.inject(cache, resourceResolver);
            }
            if (CacheFactory.getCluster().isRunning()) {
                cache.setOptimizeGetTime(true);
            }
            OldCache.UnitCalculator defaultCalculator = highUnits.isMemorySize() && dependencies.isBinary() ? LocalCache.INSTANCE_BINARY : null;
            UnitCalculatorBuilder bldrUnitCalculator = this.getUnitCalculatorBuilder();
            cache.setLowUnits((int)cLowUnits);
            cache.setUnitFactor(nUnitFactor);
            cache.setUnitCalculator(bldrUnitCalculator == null ? defaultCalculator : bldrUnitCalculator.realize(resolver, loader, null));
            CacheStoreScheme schemeCacheStore = this.getCacheStoreScheme();
            Object object = loaderObj = schemeCacheStore == null ? null : schemeCacheStore.realizeLocal(resolver, dependencies);
            if (loaderObj instanceof CacheLoader) {
                cache.setCacheLoader((CacheLoader)loaderObj);
            } else if (loaderObj != null) {
                throw new IllegalArgumentException("The LocalCache cache-store scheme does not specify a CacheLoader");
            }
            EvictionPolicyBuilder bldrPolicy = this.getEvictionPolicyBuilder();
            ConfigurableCacheMap.EvictionPolicy evictionPolicy = policy = bldrPolicy == null ? null : bldrPolicy.realize(resolver, loader, null);
            if (policy instanceof OldCache.InternalEvictionPolicy) {
                cache.setEvictionType(((OldCache.InternalEvictionPolicy)policy).getEvictionType());
            } else {
                cache.setEvictionPolicy(policy);
            }
            if (this.isPreLoad(resolver)) {
                try {
                    cache.loadAll();
                }
                catch (Throwable e) {
                    String sText = "An exception occurred while pre-loading the \"" + dependencies.getCacheName() + "\" cache:" + '\n' + Base.indentString(Base.getStackTrace(e), "    ");
                    if (!(e instanceof Error)) {
                        sText = sText + "\n(The exception has been logged and will be ignored.)";
                    }
                    Logger.warn(sText);
                    if (!(e instanceof Error)) break block16;
                    throw (Error)e;
                }
            }
        }
        return cache;
    }

    public CacheStoreScheme getCacheStoreScheme() {
        return this.m_schemeCacheStore;
    }

    @Injectable(value="cachestore-scheme")
    public void setCacheStoreScheme(CacheStoreScheme scheme) {
        this.m_schemeCacheStore = scheme;
    }

    public EvictionPolicyBuilder getEvictionPolicyBuilder() {
        return this.m_bldrEvictionPolicy;
    }

    @Injectable(value="eviction-policy")
    public void setEvictionPolicyBuilder(EvictionPolicyBuilder bldr) {
        this.m_bldrEvictionPolicy = bldr;
    }

    public Seconds getExpiryDelay(ParameterResolver resolver) {
        return this.m_exprExpiryDelay.evaluate(resolver);
    }

    @Injectable
    public void setExpiryDelay(Expression<Seconds> expr) {
        this.m_exprExpiryDelay = expr;
    }

    public Units getHighUnits(ParameterResolver resolver) {
        return this.m_exprHighUnits.evaluate(resolver);
    }

    @Injectable
    public void setHighUnits(Expression<Units> expr) {
        this.m_exprHighUnits = expr;
    }

    public Units getLowUnits(ParameterResolver resolver) {
        return this.m_exprLowUnits.evaluate(resolver);
    }

    @Injectable
    public void setLowUnits(Expression<Units> expr) {
        this.m_exprLowUnits = expr;
    }

    public boolean isPreLoad(ParameterResolver resolver) {
        return this.m_exprPreload.evaluate(resolver);
    }

    @Injectable
    public void setPreLoad(Expression<Boolean> expr) {
        this.m_exprPreload = expr;
    }

    public UnitCalculatorBuilder getUnitCalculatorBuilder() {
        return this.m_bldrUnitCalculator;
    }

    @Injectable(value="unit-calculator")
    public void setUnitCalculatorBuilder(UnitCalculatorBuilder builder) {
        this.m_bldrUnitCalculator = builder;
    }

    public int getUnitFactor(ParameterResolver resolver) {
        return this.m_exprUnitFactor.evaluate(resolver);
    }

    @Injectable
    public void setUnitFactor(Expression<Integer> expr) {
        this.m_exprUnitFactor = expr;
    }

    @Override
    protected void validate(ParameterResolver resolver) {
        super.validate(resolver);
        if (this.getExpiryDelay(resolver).as(Duration.Magnitude.MILLI) > Integer.MAX_VALUE) {
            throw new ConfigurationException("Illegal value specified for <expiry-delay> for local scheme '" + this.getSchemeName() + "'", "The expiry delay cannot exceed 2147483 seconds or ~24 days.");
        }
    }
}

