/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.ParameterMacroExpression;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.coherence.config.xml.processor.AbstractEmptyElementProcessor;
import com.tangosol.coherence.config.xml.processor.ElementProcessorHelper;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.net.PasswordProvider;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.util.Arrays;

@XmlSimpleName(value="password-provider")
public class PasswordProviderBuilderProcessor
extends AbstractEmptyElementProcessor<ParameterizedBuilder<PasswordProvider>> {
    public PasswordProviderBuilderProcessor() {
        super(AbstractEmptyElementProcessor.EmptyElementBehavior.IGNORE);
    }

    @Override
    public ParameterizedBuilder<PasswordProvider> onProcess(ProcessingContext context, XmlElement xmlElement) throws ConfigurationException {
        ParameterizedBuilder<PasswordProvider> bldr = ElementProcessorHelper.processParameterizedBuilder(context, xmlElement);
        if (bldr == null) {
            ParameterizedBuilderRegistry registry = context.getCookie(ParameterizedBuilderRegistry.class);
            String name = this.getNameFromXML(xmlElement);
            Base.azzert(name != null, "<name>valid-id</name> is missing/empty. Failed to lookup a builder for PasswordProvider");
            ParameterizedBuilder<PasswordProvider> bldrFound = registry.getBuilder(PasswordProvider.class, name);
            if (bldrFound != null && bldrFound instanceof InstanceBuilder) {
                bldr = this.newPasswordProviderBuilderFromExisitng(context, xmlElement, bldrFound);
            }
        }
        if (bldr == null) {
            throw new ConfigurationException("<password-provider> fails to correctly define a PasswordProvider implementation: " + xmlElement, "Please define a valid <password-provider>");
        }
        return bldr;
    }

    private String getNameFromXML(XmlElement xmlElement) {
        Object sName = xmlElement.getElement("name").getValue();
        return null == sName ? null : sName.toString().trim();
    }

    private ParameterizedBuilder<PasswordProvider> newPasswordProviderBuilderFromExisitng(ProcessingContext context, XmlElement xmlElement, ParameterizedBuilder bldrFound) {
        InstanceBuilder bldr = (InstanceBuilder)bldrFound;
        ParameterList listConstructorParams = bldr.getConstructorParameterList();
        ResolvableParameterList resolvableParameterList = listConstructorParams instanceof ResolvableParameterList ? (ResolvableParameterList)listConstructorParams : new ResolvableParameterList(listConstructorParams);
        XmlElement element = xmlElement.getSafeElement("init-params");
        ResolvableParameterList listOverrideParams = (ResolvableParameterList)context.processElement(element);
        for (Parameter parameter : listOverrideParams) {
            resolvableParameterList.add(parameter);
        }
        InstanceBuilder<PasswordProvider> bldrOverridden = new InstanceBuilder<PasswordProvider>();
        bldrOverridden.setClassName(bldr.getClassName());
        bldrOverridden.setConstructorParameterList(resolvableParameterList);
        return bldrOverridden;
    }

    public static ParameterizedBuilder<PasswordProvider> getPasswordProviderBuilderForPasswordStr(String password) {
        ParameterMacroExpression<String> expr = new ParameterMacroExpression<String>(DefaultPasswordProvider.class.getName(), String.class);
        ResolvableParameterList resolvableParameterList = new ResolvableParameterList();
        if (null != password) {
            resolvableParameterList.add(new Parameter("param1", password));
        }
        InstanceBuilder<PasswordProvider> bldr = new InstanceBuilder<PasswordProvider>();
        bldr.setClassName(expr);
        bldr.setConstructorParameterList(resolvableParameterList);
        return bldr;
    }

    public static ParameterizedBuilder<PasswordProvider> getNullPasswordProviderBuilder() {
        return PasswordProviderBuilderProcessor.getPasswordProviderBuilderForPasswordStr(null);
    }

    public static class DefaultPasswordProvider
    implements PasswordProvider {
        private final char[] f_achPass;

        public DefaultPasswordProvider() {
            this(null);
        }

        public DefaultPasswordProvider(String pass) {
            this.f_achPass = null == pass ? null : pass.toCharArray();
        }

        @Override
        public char[] get() {
            return null == this.f_achPass ? null : Arrays.copyOf(this.f_achPass, this.f_achPass.length);
        }
    }
}

