/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.oracle.coherence.common.base.Timeout;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.coherence.dslquery.CohQLException;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.Statement;
import com.tangosol.coherence.dslquery.StatementResult;
import com.tangosol.coherence.dsltools.precedence.EndOfStatementOPToken;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.util.Base;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;

public class StatementExecutor {
    public Object execute(Reader reader, ExecutionContext ctx) {
        CoherenceQueryLanguage language = ctx.getCoherenceQueryLanguage();
        OPParser parser = ctx.instantiateParser(reader);
        OPScanner scanner = parser.getScanner();
        PrintWriter out = ctx.getWriter();
        Object oResult = null;
        do {
            try {
                String sConfirmation;
                scanner.advanceWhenMatching(EndOfStatementOPToken.INSTANCE.getValue());
                if (scanner.isEnd()) break;
                boolean fShowPlan = false;
                boolean fTrace = ctx.isTraceEnabled();
                boolean fExecute = true;
                while (scanner.matches("show") || scanner.matches("plan")) {
                    scanner.advance();
                    fShowPlan = true;
                }
                Object term = parser.parse();
                if (fTrace) {
                    out.println("\nParsed: " + term);
                }
                Statement statement = language.prepareStatement((NodeTerm)term, ctx, null, null);
                if (fShowPlan || fTrace) {
                    out.print("plan: ");
                    statement.showPlan(out);
                    out.println();
                    if (fShowPlan) continue;
                }
                if (ctx.isSanityChecking()) {
                    statement.sanityCheck(ctx);
                }
                if ((sConfirmation = statement.getExecutionConfirmation(ctx)) != null && !ctx.isSilent()) {
                    fExecute = this.confirmExecution(ctx.getReader(), out, sConfirmation);
                }
                if (fExecute) {
                    StatementResult result;
                    if (statement.isManagingTimeout()) {
                        result = statement.execute(ctx);
                    } else {
                        try (Timeout t = Timeout.after(ctx.getTimeout().as(Duration.Magnitude.MILLI));){
                            result = statement.execute(ctx);
                        }
                    }
                    String sTitle = ctx.isSilent() ? null : ctx.getTitle();
                    result.print(out, sTitle);
                    oResult = result.getResult();
                    continue;
                }
                oResult = null;
            }
            catch (Throwable e) {
                if (ctx.isStopOnError()) {
                    throw Base.ensureRuntimeException(e);
                }
                String sError = "Error: " + e.getMessage();
                out.println(sError);
            }
        } while (!scanner.isEnd());
        return oResult;
    }

    private boolean confirmExecution(BufferedReader reader, PrintWriter out, String sPrompt) {
        try {
            String sLine;
            while (true) {
                out.print(sPrompt);
                out.flush();
                sLine = reader.readLine();
                if (sLine != null) break;
                out.println("Please answer either y or n");
            }
            return sLine.equals("y") || sLine.equals("Y");
        }
        catch (IOException ioe) {
            throw new CohQLException("IOException reading confirmation " + ioe.getMessage());
        }
    }
}

